/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fop.service.dom;

import ch.elexis.fop.service.FormattedOutputFactory;
import ch.elexis.fop.service.XSLTUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DomToMimeType {
    private static Logger logger = LoggerFactory.getLogger(DomToMimeType.class);
    private static DomToMimeType instance;

    private DomToMimeType() {
    }

    public static DomToMimeType getInstance() {
        if (instance == null) {
            instance = new DomToMimeType();
        }
        return instance;
    }

    public void transform(Object documentObject, InputStream xslt, OutputStream outputStream, String outputFormat, Map<String, String> transformerParameters, URIResolver resolver) {
        if (!(documentObject instanceof Document)) {
            return;
        }
        FOUserAgent foUserAgent = FormattedOutputFactory.getFopFactory().newFOUserAgent();
        try {
            try {
                Fop fop = FormattedOutputFactory.getFopFactory().newFop(outputFormat, foUserAgent, outputStream);
                Transformer transformer = XSLTUtil.getTransformerForXSLT(xslt, resolver);
                if (transformerParameters != null && transformerParameters.keySet().size() > 0) {
                    for (String keyParameter : transformerParameters.keySet()) {
                        transformer.setParameter(keyParameter, transformerParameters.get(keyParameter));
                    }
                }
                DOMSource src = new DOMSource((Document)documentObject);
                SAXResult res = new SAXResult(fop.getDefaultHandler());
                transformer.transform(src, res);
            }
            catch (TransformerException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
            catch (FOPException e) {
                logger.error("Error during XML tranformation.", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

