/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.core.task;

import ch.elexis.core.model.tasks.IIdentifiedRunnable;
import ch.elexis.core.model.tasks.IIdentifiedRunnableFactory;
import ch.elexis.core.model.tasks.TaskException;
import ch.elexis.core.services.IAccessControlService;
import ch.elexis.core.tasks.model.ITaskService;
import ch.elexis.fire.core.IFIREService;
import ch.elexis.fire.core.task.FIREExportIdentifiedRunnable;
import ch.elexis.fire.core.task.FIREExportTaskDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class FIREExportIdentifiedRunnableFactory
implements IIdentifiedRunnableFactory {
    @Reference
    private ITaskService taskService;
    @Reference
    private IFIREService fireService;
    @Reference
    private IAccessControlService accessControlService;

    @Activate
    public void activate() {
        this.accessControlService.doPrivileged(() -> {
            try {
                FIREExportTaskDescriptor.getOrCreate(this.taskService);
            }
            catch (TaskException e) {
                throw new ComponentException((Throwable)e);
            }
        });
        this.taskService.bindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    @Deactivate
    public void deactivate() {
        this.taskService.unbindIIdentifiedRunnableFactory((IIdentifiedRunnableFactory)this);
    }

    public List<IIdentifiedRunnable> getProvidedRunnables() {
        ArrayList<IIdentifiedRunnable> ret = new ArrayList<IIdentifiedRunnable>();
        ret.add(new FIREExportIdentifiedRunnable(this.fireService));
        return ret;
    }
}

