/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.fire.core.internal;

import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.IFindingsService;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.findings.util.fhir.IFhirTransformer;
import ch.elexis.core.findings.util.fhir.IFhirTransformerRegistry;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.ISickCertificate;
import ch.elexis.core.model.IVaccination;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.fire.core.IFIREService;
import ch.elexis.fire.core.internal.FIREUploadBundle;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Resource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component
public class FIREService
implements IFIREService {
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference(target="(service.model.name=ch.elexis.core.findings.model)")
    private IModelService findingsModelService;
    @Reference
    private IFhirTransformerRegistry transformerRegistry;
    @Reference
    private IFindingsService findingsService;
    @Reference
    private IConfigService configService;
    private MessageDigest sha256Digest;
    private IFhirTransformer<Patient, IPatient> patientTransformer;
    private IFhirTransformer<Encounter, IEncounter> encounterTransformer;
    private IFhirTransformer<Practitioner, IMandator> mandatorTransformer;
    private IFhirTransformer<Observation, ILabResult> labTransformer;
    private IFhirTransformer<MedicationRequest, IPrescription> prescriptionTransformer;
    private IFhirTransformer<Condition, ISickCertificate> sickCertificateTransformer;
    private IFhirTransformer<Immunization, IVaccination> vaccinationTransformer;

    @Activate
    public void activate() throws NoSuchAlgorithmException {
        this.sha256Digest = MessageDigest.getInstance("SHA-256");
    }

    private IFhirTransformer<Patient, IPatient> getPatientTransformer() {
        if (this.patientTransformer == null) {
            this.patientTransformer = this.transformerRegistry.getTransformerFor(Patient.class, IPatient.class);
        }
        return this.patientTransformer;
    }

    private IFhirTransformer<Encounter, IEncounter> getEncounterTransformer() {
        if (this.encounterTransformer == null) {
            this.encounterTransformer = this.transformerRegistry.getTransformerFor(Encounter.class, IEncounter.class);
        }
        return this.encounterTransformer;
    }

    private IFhirTransformer<Practitioner, IMandator> getMandatorTransformer() {
        if (this.mandatorTransformer == null) {
            this.mandatorTransformer = this.transformerRegistry.getTransformerFor(Practitioner.class, IMandator.class);
        }
        return this.mandatorTransformer;
    }

    private IFhirTransformer<Observation, ILabResult> getLabTransformer() {
        if (this.labTransformer == null) {
            this.labTransformer = this.transformerRegistry.getTransformerFor(Observation.class, ILabResult.class);
        }
        return this.labTransformer;
    }

    private IFhirTransformer<MedicationRequest, IPrescription> getPrescriptionTransformer() {
        if (this.prescriptionTransformer == null) {
            this.prescriptionTransformer = this.transformerRegistry.getTransformerFor(MedicationRequest.class, IPrescription.class);
        }
        return this.prescriptionTransformer;
    }

    private IFhirTransformer<Condition, ISickCertificate> getSickCertificateTransformer() {
        if (this.sickCertificateTransformer == null) {
            this.sickCertificateTransformer = this.transformerRegistry.getTransformerFor(Condition.class, ISickCertificate.class);
        }
        return this.sickCertificateTransformer;
    }

    private IFhirTransformer<Immunization, IVaccination> getVaccinationTransformer() {
        if (this.vaccinationTransformer == null) {
            this.vaccinationTransformer = this.transformerRegistry.getTransformerFor(Immunization.class, IVaccination.class);
        }
        return this.vaccinationTransformer;
    }

    @Override
    public Long getInitialTimestamp() {
        return Long.valueOf(this.configService.get("fire.intialExport", "-1"));
    }

    @Override
    public Long getIncrementalTimestamp() {
        return Long.valueOf(this.configService.get("fire.incrementalExport", "-1"));
    }

    @Override
    public List<File> initialExport(IProgressMonitor progressMonitor) {
        long timestamp = System.currentTimeMillis();
        List<File> ret = new ArrayList<File>();
        progressMonitor.beginTask("FIRE initial export", -1);
        try {
            this.clearExportDirectory();
            BundleFile currentBundle = this.getBundleFile(true);
            Throwable throwable = null;
            Object var7_8 = null;
            try (IQueryCursor cursor = this.coreModelService.getQuery(IPatient.class).executeAsCursor();){
                while (cursor.hasNext()) {
                    IPatient patient = (IPatient)cursor.next();
                    if (patient.getDateOfBirth() == null) continue;
                    Optional fhirPatient = this.getPatientTransformer().getFhirObject((Object)patient);
                    if (fhirPatient.isPresent()) {
                        Bundle patientBundle = this.exportPatient(patient, (Patient)fhirPatient.get(), currentBundle.getBundle());
                        currentBundle.addEntry(patientBundle);
                    }
                    currentBundle = currentBundle.writeIfNecessary(ret);
                    if (!progressMonitor.isCanceled()) continue;
                    LoggerFactory.getLogger(this.getClass()).warn("Cancelled initial export");
                    return Collections.emptyList();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            currentBundle.write(ret);
            ret = this.moveExportToUploadDirectory(ret);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception on initial export", (Throwable)e);
            return Collections.emptyList();
        }
        this.configService.set("fire.intialExport", Long.toString(timestamp));
        return ret;
    }

    private Bundle exportPatient(IPatient patient, Patient fhirPatient, Bundle ret) {
        String firePatientId = this.getFIREPatientId(patient.getId());
        fhirPatient = this.toFIRE(fhirPatient);
        fhirPatient.addIdentifier(new Identifier().setSystem("fire.export.patID").setValue(firePatientId));
        Bundle patientBundle = new Bundle();
        patientBundle.setId(firePatientId);
        patientBundle.setType(Bundle.BundleType.COLLECTION);
        patientBundle.addEntry().setResource((Resource)fhirPatient);
        List encounters = patient.getCoverages().stream().flatMap(c -> c.getEncounters().stream()).collect(Collectors.toList());
        encounters.stream().forEach(ie -> {
            Encounter fhirEncounter = this.getEncounterTransformer().getFhirObject(ie).orElse(null);
            if (fhirEncounter != null) {
                if (ie.getMandator() != null) {
                    this.addMandatorToBundle(ie.getMandator(), ret);
                    if (ie.getMandator().getBiller().isPerson() && ie.getMandator().getBiller().isMandator() && !ie.getMandator().equals(ie.getMandator().getBiller())) {
                        IContact biller = ie.getMandator().getBiller();
                        this.addMandatorToBundle((IMandator)this.coreModelService.load(biller.getId(), IMandator.class).get(), ret);
                    }
                }
                this.toFIRE(fhirEncounter);
                patientBundle.addEntry().setResource((Resource)fhirEncounter);
            }
        });
        List conditions = this.findingsService.getPatientsFindings(patient.getId(), ICondition.class);
        conditions.forEach(c -> {
            Condition fhirCondition = (Condition)ModelUtil.getAsResource((String)c.getRawContent());
            patientBundle.addEntry().setResource((Resource)fhirCondition);
        });
        IQuery resultQuery = this.coreModelService.getQuery(ILabResult.class);
        resultQuery.and((EStructuralFeature)ModelPackage.Literals.ILAB_RESULT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        List labObservation = resultQuery.execute();
        labObservation.forEach(lr -> {
            Observation labResult = this.getLabTransformer().getFhirObject(lr).orElse(null);
            if (labResult != null) {
                patientBundle.addEntry().setResource((Resource)labResult);
            }
        });
        List prescriptions = patient.getMedication(null);
        prescriptions.forEach(lr -> {
            MedicationRequest medicationRequest = this.getPrescriptionTransformer().getFhirObject(lr).orElse(null);
            if (medicationRequest != null) {
                patientBundle.addEntry().setResource((Resource)medicationRequest);
            }
        });
        IQuery sickQuery = this.coreModelService.getQuery(ISickCertificate.class);
        sickQuery.and((EStructuralFeature)ModelPackage.Literals.ISICK_CERTIFICATE__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        List sickCertificates = sickQuery.execute();
        sickCertificates.forEach(sc -> {
            Condition condition = this.getSickCertificateTransformer().getFhirObject(sc).orElse(null);
            if (condition != null) {
                patientBundle.addEntry().setResource((Resource)condition);
            }
        });
        IQuery vaccQuery = this.coreModelService.getQuery(IVaccination.class);
        vaccQuery.and((EStructuralFeature)ModelPackage.Literals.IVACCINATION__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)patient);
        List vaccinations = vaccQuery.execute();
        vaccinations.forEach(va -> {
            Immunization immunization = this.getVaccinationTransformer().getFhirObject(va).orElse(null);
            if (immunization != null) {
                patientBundle.addEntry().setResource((Resource)immunization);
            }
        });
        return patientBundle;
    }

    private void addMandatorToBundle(IMandator mandator, Bundle ret) {
        Optional<Bundle.BundleEntryComponent> found = this.findBundleEntry(mandator.getId(), ret);
        if (found.isEmpty()) {
            Optional fhirPractitioner = this.getMandatorTransformer().getFhirObject((Object)mandator);
            fhirPractitioner.ifPresent(p -> {
                Bundle.BundleEntryComponent bundleEntryComponent = ret.addEntry().setResource((Resource)this.toFIRE((Practitioner)p));
            });
        }
    }

    private Optional<Bundle.BundleEntryComponent> findBundleEntry(String resourceId, Bundle bundle) {
        if (bundle != null) {
            Optional<Bundle.BundleEntryComponent> found = bundle.getEntry().stream().filter(be -> be.getResource() != null && resourceId.equals(be.getResource().getIdElement().getIdPart())).findFirst();
            return found;
        }
        return Optional.empty();
    }

    private Practitioner toFIRE(Practitioner fhirPractitioner) {
        fhirPractitioner.getName().clear();
        fhirPractitioner.getTelecom().clear();
        fhirPractitioner.getAddress().clear();
        fhirPractitioner.setText(null);
        return fhirPractitioner;
    }

    private Encounter toFIRE(Encounter fhirEncounter) {
        fhirEncounter.setText(null);
        return fhirEncounter;
    }

    private Patient toFIRE(Patient fhirPatient) {
        if (fhirPatient.hasBirthDate()) {
            LocalDate birthDate = LocalDate.ofInstant(fhirPatient.getBirthDate().toInstant(), ZoneId.systemDefault());
            fhirPatient.setBirthDate(Date.from(birthDate.withDayOfMonth(1).withMonth(1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        }
        fhirPatient.getName().clear();
        fhirPatient.getTelecom().clear();
        fhirPatient.getAddress().clear();
        fhirPatient.setText(null);
        fhirPatient.setExtension(Collections.emptyList());
        fhirPatient.setIdentifier(new ArrayList<Identifier>(fhirPatient.getIdentifier().stream().filter(i -> i.getSystem().startsWith("www.elexis")).toList()));
        return fhirPatient;
    }

    protected String getFIREPatientId(String id) {
        String originalString = this.getPracticeIdentifier() + "." + id;
        byte[] encodedhash = this.sha256Digest.digest(originalString.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])encodedhash);
    }

    @Override
    public List<File> incrementalExport(Long lastExportTimestamp, IProgressMonitor progressMonitor) {
        long timestamp = System.currentTimeMillis();
        List<File> ret = new ArrayList<File>();
        try {
            this.clearExportDirectory();
            BundleFile currentBundle = this.getBundleFile(false);
            List<IPatient> changedPatients = this.getChanged(lastExportTimestamp, IPatient.class);
            currentBundle = this.addIncrementalPatients(changedPatients, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            List<IEncounter> changedEncounters = this.getChanged(lastExportTimestamp, IEncounter.class);
            currentBundle = this.addIncrementalEncounters(changedEncounters, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            List<ICondition> changedConditions = this.getChangedFindings(lastExportTimestamp, ICondition.class);
            currentBundle = this.addIncrementalConditions(changedConditions, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            List<IPrescription> changedPrescriptions = this.getChanged(lastExportTimestamp, IPrescription.class);
            currentBundle = this.addIncrementalPrescriptions(changedPrescriptions, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            List<ILabResult> changedLabResults = this.getChanged(lastExportTimestamp, ILabResult.class);
            currentBundle = this.addIncrementalLabResult(changedLabResults, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            List<IVaccination> changedVaccinations = this.getChanged(lastExportTimestamp, IVaccination.class);
            currentBundle = this.addIncrementalVaccination(changedVaccinations, currentBundle, ret);
            if (progressMonitor.isCanceled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Cancelled incremental export");
                return Collections.emptyList();
            }
            currentBundle.write(ret);
            ret = this.moveExportToUploadDirectory(ret);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception on incremental export", (Throwable)e);
            return Collections.emptyList();
        }
        this.configService.set("fire.incrementalExport", Long.toString(timestamp));
        return ret;
    }

    private BundleFile addIncrementalPatients(List<IPatient> changedPatients, BundleFile currentBundle, List<File> ret) throws IOException {
        for (IPatient iPatient : changedPatients) {
            if (iPatient.getDateOfBirth() == null) continue;
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(iPatient.getId()), currentBundle.getBundle());
            Optional fhirPatient = this.getPatientTransformer().getFhirObject((Object)iPatient);
            if (fhirPatient.isPresent()) {
                this.toFIRE((Patient)fhirPatient.get());
                currentBundle.addResourceToBundle(patientBundle, (Resource)fhirPatient.get());
            }
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    private BundleFile addIncrementalEncounters(List<IEncounter> changedEncounters, BundleFile currentBundle, List<File> ret) throws IOException {
        for (IEncounter en : changedEncounters) {
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(en.getPatient().getId()), currentBundle.getBundle());
            Optional fhirEncounter = this.getEncounterTransformer().getFhirObject((Object)en);
            if (fhirEncounter.isPresent()) {
                if (en.getMandator() != null) {
                    this.addMandatorToBundle(en.getMandator(), currentBundle.getBundle());
                    if (en.getMandator().getBiller().isPerson() && en.getMandator().getBiller().isMandator() && !en.getMandator().equals(en.getMandator().getBiller())) {
                        IContact biller = en.getMandator().getBiller();
                        this.addMandatorToBundle((IMandator)this.coreModelService.load(biller.getId(), IMandator.class).get(), currentBundle.getBundle());
                    }
                }
                this.toFIRE((Encounter)fhirEncounter.get());
                currentBundle.addResourceToBundle(patientBundle, (Resource)fhirEncounter.get());
            }
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    private BundleFile addIncrementalConditions(List<ICondition> changedConditions, BundleFile currentBundle, List<File> ret) throws IOException {
        for (ICondition co : changedConditions) {
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(co.getPatientId()), currentBundle.getBundle());
            Condition fhirCondition = (Condition)ModelUtil.getAsResource((String)co.getRawContent());
            currentBundle.addResourceToBundle(patientBundle, (Resource)fhirCondition);
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    private BundleFile addIncrementalPrescriptions(List<IPrescription> changedPrescriptions, BundleFile currentBundle, List<File> ret) throws IOException {
        for (IPrescription pr : changedPrescriptions) {
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(pr.getPatient().getId()), currentBundle.getBundle());
            Optional mr = this.getPrescriptionTransformer().getFhirObject((Object)pr);
            if (!mr.isPresent()) continue;
            currentBundle.addResourceToBundle(patientBundle, (Resource)mr.get());
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    private BundleFile addIncrementalLabResult(List<ILabResult> changedLabResults, BundleFile currentBundle, List<File> ret) throws IOException {
        for (ILabResult lr : changedLabResults) {
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(lr.getPatient().getId()), currentBundle.getBundle());
            Optional ob = this.getLabTransformer().getFhirObject((Object)lr);
            if (!ob.isPresent()) continue;
            currentBundle.addResourceToBundle(patientBundle, (Resource)ob.get());
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    private BundleFile addIncrementalVaccination(List<IVaccination> changedVaccinations, BundleFile currentBundle, List<File> ret) throws IOException {
        for (IVaccination va : changedVaccinations) {
            Bundle patientBundle = this.getOrCreatePatientBundle(this.getFIREPatientId(va.getPatient().getId()), currentBundle.getBundle());
            Optional im = this.getVaccinationTransformer().getFhirObject((Object)va);
            if (!im.isPresent()) continue;
            currentBundle.addResourceToBundle(patientBundle, (Resource)im.get());
            currentBundle = currentBundle.writeIfNecessary(ret);
        }
        return currentBundle;
    }

    protected Bundle getPatientBundle(String firePatientId, Bundle exportBundle) {
        for (Bundle.BundleEntryComponent entry : exportBundle.getEntry()) {
            if (entry.getResource() == null || !firePatientId.equals(entry.getResource().getId())) continue;
            return (Bundle)entry.getResource();
        }
        return null;
    }

    protected Bundle getOrCreatePatientBundle(String firePatientId, Bundle exportBundle) {
        Bundle ret = this.getPatientBundle(firePatientId, exportBundle);
        if (ret == null) {
            ret = new Bundle();
            ret.setId(firePatientId);
            ret.setType(Bundle.BundleType.COLLECTION);
            exportBundle.addEntry().setResource((Resource)ret);
        }
        return ret;
    }

    private <T> List<T> getChanged(Long lastExportTimestamp, Class<T> clazz) {
        IQuery query = this.coreModelService.getQuery(clazz);
        query.and("lastupdate", IQuery.COMPARATOR.GREATER, (Object)lastExportTimestamp);
        return query.execute();
    }

    private <T> List<T> getChangedFindings(Long lastExportTimestamp, Class<T> clazz) {
        IQuery query = this.findingsModelService.getQuery(clazz);
        query.and("lastupdate", IQuery.COMPARATOR.GREATER, (Object)lastExportTimestamp);
        return query.execute();
    }

    private BundleFile getBundleFile(boolean initial) throws UnsupportedEncodingException {
        Bundle bundle = new Bundle();
        bundle.setId(this.getPracticeIdentifier());
        bundle.setMeta(new Meta().setLastUpdated(new Date()).addTag("fire.export.practiceID", this.getPracticeIdentifier(), null).addTag("fire.export.pmsName", "Elexis", null));
        bundle.setType(Bundle.BundleType.COLLECTION);
        if (initial) {
            bundle.getMeta().addTag(new Coding("fire.export.type", "initial", null));
        } else {
            bundle.getMeta().addTag(new Coding("fire.export.type", "incremental", null));
        }
        return new BundleFile(bundle, this.getExportFile(), initial);
    }

    private String getPracticeIdentifier() {
        if (this.isOidMedelexisProjectAvailable()) {
            return this.getOidMedelexisProject();
        }
        return this.getElexisInstallationId();
    }

    private String getElexisInstallationId() {
        return this.configService.get("installation/timestamp", "defaultElexisInstallationId");
    }

    private boolean isOidMedelexisProjectAvailable() {
        return this.configService.getLocal("software/oid", null) != null && this.configService.getLocal("medelexis/projectid", null) != null;
    }

    private String getOidMedelexisProject() {
        String oid = this.configService.getLocal("software/oid", null);
        String projectId = this.configService.getLocal("medelexis/projectid", null);
        return oid + ".100." + projectId;
    }

    @Override
    public boolean uploadBundle(File file) {
        try {
            FIREUploadBundle upload = new FIREUploadBundle(file);
            return CompletableFuture.supplyAsync(upload).get();
        }
        catch (InterruptedException | ExecutionException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception uploading bundle", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private void increaseBundleCount() {
        int value = this.configService.get("fire.export.bundle.count", 1);
        this.configService.set("fire.export.bundle.count", value + 1);
    }

    private int getBundleCount() {
        return this.configService.get("fire.export.bundle.count", 1);
    }

    private void clearExportDirectory() throws IOException {
        File exportDirectory = new File(CoreUtil.getWritableUserDir(), "fireexport");
        if (exportDirectory.exists()) {
            FileUtils.cleanDirectory((File)exportDirectory);
        }
    }

    private List<File> moveExportToUploadDirectory(List<File> exportFiles) throws IOException {
        if (exportFiles != null) {
            ArrayList<File> uploadFiles = new ArrayList<File>();
            for (File exportFile : exportFiles) {
                File uploadDirectory = new File(exportFile.getParentFile(), "upload");
                if (!uploadDirectory.exists()) {
                    uploadDirectory.mkdir();
                }
                File uploadFile = new File(uploadDirectory, exportFile.getName());
                FileUtils.moveFile((File)exportFile, (File)uploadFile);
                uploadFiles.add(uploadFile);
            }
            return uploadFiles;
        }
        return Collections.emptyList();
    }

    private File getExportFile() {
        File exportDirectory = new File(CoreUtil.getWritableUserDir(), "fireexport");
        if (!exportDirectory.exists()) {
            exportDirectory.mkdir();
        }
        return new File(exportDirectory, this.getBundleName() + ".json");
    }

    private String getBundleText(Bundle bundle) {
        return ModelUtil.getFhirJson((IBaseResource)bundle);
    }

    private String getResourceText(Resource resource) {
        return ModelUtil.getFhirJson((IBaseResource)resource);
    }

    private void writeBundle(Bundle bundle, File currentFile) throws IOException {
        FileUtils.writeStringToFile((File)currentFile, (String)this.getBundleText(bundle), (Charset)Charset.forName("UTF-8"));
        this.increaseBundleCount();
    }

    private String getBundleName() {
        return "elexis_00" + this.getPracticeIdentifier() + "_" + StringUtils.leftPad((String)Integer.toString(this.getBundleCount()), (int)6, (String)"0") + "_" + LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    @Override
    public Bundle readBundle(File file) {
        try {
            IBaseResource resource = ModelUtil.getAsResource((String)Files.readString(file.toPath()));
            if (resource instanceof Bundle) {
                return (Bundle)resource;
            }
            LoggerFactory.getLogger(this.getClass()).error("File contains [" + String.valueOf(resource) + "] is not an bundle");
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Exception reading bundle file", (Throwable)e);
        }
        return null;
    }

    private class BundleFile {
        private File file;
        private Bundle bundle;
        private int bundleSize;
        private boolean initial;

        public BundleFile(Bundle bundle, File file, boolean initial) throws UnsupportedEncodingException {
            this.initial = initial;
            this.file = file;
            this.bundle = bundle;
            this.bundleSize = this.getBundleSize(bundle);
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public boolean startNextBundle() throws UnsupportedEncodingException {
            return this.bundleSize > 0x1900000;
        }

        private void updateBundleSize(Bundle addedBundle) throws UnsupportedEncodingException {
            this.bundleSize += this.getBundleSize(addedBundle);
        }

        private void updateBundleSize(Resource resource) throws UnsupportedEncodingException {
            this.bundleSize += this.getResourceSize(resource);
        }

        private int getBundleSize(Bundle addedBundle) throws UnsupportedEncodingException {
            return FIREService.this.getBundleText(addedBundle).getBytes("UTF-8").length;
        }

        private int getResourceSize(Resource resource) throws UnsupportedEncodingException {
            return FIREService.this.getResourceText(resource).getBytes("UTF-8").length;
        }

        public void addEntry(Bundle addedBundle) throws UnsupportedEncodingException {
            this.bundle.addEntry().setResource((Resource)addedBundle);
            this.updateBundleSize(addedBundle);
        }

        public void addResourceToBundle(Bundle bundle, Resource resource) throws UnsupportedEncodingException {
            bundle.addEntry().setResource(resource);
            this.updateBundleSize(resource);
        }

        public BundleFile writeIfNecessary(List<File> ret) throws IOException {
            if (this.startNextBundle()) {
                FIREService.this.writeBundle(this.bundle, this.file);
                ret.add(this.file);
                return FIREService.this.getBundleFile(this.initial);
            }
            return this;
        }

        public void write(List<File> ret) throws IOException {
            FIREService.this.writeBundle(this.bundle, this.file);
            ret.add(this.file);
        }
    }
}

