/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.services.holder.ConfigServiceHolder;

public class PreferenceConstants {
    public static final String BASIS_PFAD1 = "ch.elexis.externe_dokumente/BasisPfad";
    public static final String BASIS_PFAD2 = "ch.elexis.externe_dokumente/BasisPfad2";
    public static final String BASIS_PFAD3 = "ch.elexis.externe_dokumente/BasisPfad3";
    public static final String BASIS_PFAD4 = "ch.elexis.externe_dokumente/BasisPfad4";
    public static final String NAME_PFAD1 = "ch.elexis.externe_dokumente/NamePfad";
    public static final String NAME_PFAD2 = "ch.elexis.externe_dokumente/NamePfad2";
    public static final String NAME_PFAD3 = "ch.elexis.externe_dokumente/NamePfad3";
    public static final String NAME_PFAD4 = "ch.elexis.externe_dokumente/NamePfad4";
    public static final String SELECTED_PATHS = "ch.elexis.externe_dokumente/SelectedPaths";
    public static final String CONCERNS = "ch.elexis.externe_dokumente/Concerns";
    public static final String EMAIL_PROGRAM = "ch.elexis.externe_dokumente/Email_app";
    private static int selected = -1;

    public static PathElement[] getPrefenceElements() {
        PathElement[] prefElems = new PathElement[]{new PathElement(NAME_PFAD1, BASIS_PFAD1), new PathElement(NAME_PFAD2, BASIS_PFAD2), new PathElement(NAME_PFAD3, BASIS_PFAD3), new PathElement(NAME_PFAD4, BASIS_PFAD4)};
        return prefElems;
    }

    public static String[] getActiveBasePaths() {
        String[] paths = new String[]{CoreHub.localCfg.get(BASIS_PFAD1, ""), CoreHub.localCfg.get(BASIS_PFAD2, ""), CoreHub.localCfg.get(BASIS_PFAD3, ""), CoreHub.localCfg.get(BASIS_PFAD4, "")};
        int j = 0;
        while (j < paths.length) {
            if (!PreferenceConstants.pathIsSelected(j)) {
                paths[j] = null;
            }
            ++j;
        }
        return paths;
    }

    private static void ensureValueLoaded() {
        if (selected == -1) {
            selected = Integer.parseInt(ConfigServiceHolder.getUser((String)SELECTED_PATHS, (String)"0"));
        }
    }

    public static boolean pathIsSelected(int whichOne) {
        PreferenceConstants.ensureValueLoaded();
        return (selected & 1 << whichOne) != 0;
    }

    public static void saveSelected() {
        PreferenceConstants.ensureValueLoaded();
        ConfigServiceHolder.setUser((String)SELECTED_PATHS, (String)Integer.toString(selected));
    }

    public static void pathSetSelected(int whichOne, boolean yes) {
        PreferenceConstants.ensureValueLoaded();
        int mask = 1 << whichOne;
        selected = yes ? (selected |= mask) : (selected &= ~mask);
    }

    public static class PathElement {
        public String prefName;
        public String name;
        public String prefBaseDir;
        public String baseDir;

        PathElement(String prefsName, String prefsBaseDirName) {
            this.prefName = prefsName;
            this.prefBaseDir = prefsBaseDirName;
            this.name = CoreHub.localCfg.get(this.prefName, "");
            this.baseDir = CoreHub.localCfg.get(prefsBaseDirName, "");
        }
    }
}

