/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.JobPool;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.dialogs.FileEditDialog;
import ch.elexis.extdoc.dialogs.MoveIntoSubDirsDialog;
import ch.elexis.extdoc.dialogs.VerifierDialog;
import ch.elexis.extdoc.preferences.PreferenceConstants;
import ch.elexis.extdoc.util.Email;
import ch.elexis.extdoc.util.ListFiles;
import ch.elexis.extdoc.util.MatchPatientToPath;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExterneDokumente
extends ViewPart
implements IRefreshable {
    private static final int DEFAULT_SIZE = 1;
    private Button[] pathCheckBoxes = new Button[4];
    private final String[] activePaths = new String[4];
    private TableViewer viewer;
    private Action doubleClickAction;
    private Action sendMailAction;
    private Action openFolderAction;
    private Action openAction;
    private IAction editAction;
    private IAction renameAction;
    private Action moveIntoSubDirsActions;
    private Action deleteAction;
    private Action verifyAction;
    private Patient actPatient;
    private Mandant actMandant;
    private boolean isFirstTime = true;
    private TimestampComparator timeComparator;
    private FilenameComparator nameComparator;
    BackgroundJob globalJob;
    int lastSize = 1;
    private static Logger logger = null;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    @Optional
    @Inject
    void activePatient(IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            this.actPatient = (Patient)NoPoUtil.loadAsPersistentObject((Identifiable)patient);
            this.actMandant = CoreHub.actMandant;
            this.refreshInternal();
        }, (Object)this.viewer);
    }

    public void setFocus() {
        if (this.isFirstTime) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Ansicht veraltet", (String)("Die Ansicht " + this.getTitle() + " ist veraltet und wird nicht mehr unterst\u00fctzt. Bitte verwenden Sie die Dokumente Ansicht."));
            this.isFirstTime = false;
        }
        this.viewer.getControl().setFocus();
    }

    public static void addFile(String f) {
        Patient act = ElexisEventDispatcher.getSelectedPatient();
        if (act == null) {
            SWTHelper.showError((String)Messages.ExterneDokumente_no_patient_found, (String)Messages.ExterneDokumente_select_patient_first);
            return;
        }
        File file = new File(f);
        if (!file.canRead()) {
            SWTHelper.showError((String)Messages.ExterneDokumente_read_errpor, (String)MessageFormat.format(Messages.ExterneDokumente_could_not_read_File, f));
            return;
        }
        try {
            int len;
            FileInputStream in = new FileInputStream(f);
            FileOutputStream out = new FileOutputStream(MatchPatientToPath.getSubDirPath(act));
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.ExterneDokumente_import_failed, (String)Messages.ExterneDokumente_exception_while_copying);
        }
        logger.info(Messages.ExterneDokumente_imported + file.getAbsolutePath());
    }

    public void createPartControl(Composite parent) {
        logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        Composite topArea = new Composite(parent, 0);
        topArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
        topArea.setLayout((Layout)new GridLayout());
        Composite bottomArea = new Composite(parent, 0);
        bottomArea.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        bottomArea.setLayout((Layout)new GridLayout());
        Composite pathArea = new Composite(topArea, 0);
        pathArea.setLayout((Layout)new GridLayout(4, false));
        SelectionAdapter checkBoxListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExterneDokumente.this.refreshInternal();
            }
        };
        PreferenceConstants.PathElement[] prefs = PreferenceConstants.getPrefenceElements();
        int j = 0;
        while (j < prefs.length) {
            boolean emptyPath;
            PreferenceConstants.PathElement cur = prefs[j];
            boolean bl = emptyPath = cur.name == null || cur.name.length() == 0 || cur.baseDir == null || cur.baseDir.length() == 0;
            if (j == 0 || !emptyPath) {
                this.pathCheckBoxes[j] = new Button(pathArea, 32);
                this.pathCheckBoxes[j].setText(cur.name);
                this.pathCheckBoxes[j].setSelection(PreferenceConstants.pathIsSelected(j));
                this.pathCheckBoxes[j].addSelectionListener((SelectionListener)checkBoxListener);
                if (emptyPath) {
                    this.pathCheckBoxes[j].setToolTipText(Messages.ExterneDokumente_not_defined_in_preferences);
                } else if (!emptyPath) {
                    this.pathCheckBoxes[j].setToolTipText(cur.baseDir);
                }
            }
            ++j;
        }
        this.viewer = new TableViewer(bottomArea, 66306);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        this.timeComparator = new TimestampComparator();
        this.nameComparator = new FilenameComparator();
        TableColumn tc = new TableColumn(table, 16384);
        tc.setText(Messages.ExterneDokumente_file_date);
        tc.setWidth(120);
        tc.setToolTipText(Messages.ExterneDokumente_click_to_sort_by_date);
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExterneDokumente.this.viewer.getComparator() == ExterneDokumente.this.timeComparator) {
                    ExterneDokumente.this.timeComparator.changeSortOrder();
                } else {
                    ExterneDokumente.this.viewer.setComparator((ViewerComparator)ExterneDokumente.this.timeComparator);
                }
                ExterneDokumente.this.viewer.refresh();
            }
        });
        tc = new TableColumn(table, 16384);
        tc.setText(Messages.ExterneDokumente_file_name);
        tc.setWidth(400);
        tc.setToolTipText(Messages.ExterneDokumente_click_to_sort_by_name);
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExterneDokumente.this.viewer.getComparator() == ExterneDokumente.this.nameComparator) {
                    ExterneDokumente.this.nameComparator.changeSortOrder();
                } else {
                    ExterneDokumente.this.viewer.setComparator((ViewerComparator)ExterneDokumente.this.nameComparator);
                }
                ExterneDokumente.this.viewer.refresh();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)this.timeComparator);
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        Transfer[] transferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, transferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                String[] files;
                String[] stringArray = files = (String[])event.data;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    ExterneDokumente.addFile(file);
                    ExterneDokumente.this.viewer.refresh();
                    ++n2;
                }
            }
        });
        this.actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(Messages.ExterneDokumente_pop_menu);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExterneDokumente.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.openFolderAction);
        manager.add((IAction)this.sendMailAction);
        manager.add(this.renameAction);
        manager.add(this.editAction);
        manager.add((IAction)this.verifyAction);
        manager.add((IAction)this.moveIntoSubDirsActions);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.openFolderAction);
        manager.add((IAction)this.sendMailAction);
        manager.add(this.renameAction);
        manager.add(this.editAction);
        manager.add((IAction)this.deleteAction);
        manager.add((IAction)this.moveIntoSubDirsActions);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.openAction);
        manager.add(this.editAction);
        manager.add((IAction)this.sendMailAction);
        manager.add((IAction)this.openFolderAction);
    }

    private void makeActions() {
        this.sendMailAction = new Action(){

            public void run() {
                Object element2 = null;
                ArrayList<File> attachements = new ArrayList<File>();
                StructuredSelection selection = (StructuredSelection)ExterneDokumente.this.viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    for (Object element2 : selection) {
                        if (!(element2 instanceof File)) continue;
                        attachements.add(element2);
                    }
                }
                if (ExterneDokumente.this.actPatient != null) {
                    Object inhalt = Email.getEmailPreface(ExterneDokumente.this.actPatient);
                    inhalt = (String)inhalt + "\n\n\nMedikation: \n" + ExterneDokumente.this.actPatient.getMedikation();
                    inhalt = (String)inhalt + "\nAlle Konsultationen\n" + Email.getAllKonsultations(ExterneDokumente.this.actPatient) + "\n\n";
                    Email.openMailApplication("", null, (String)inhalt, attachements);
                }
            }
        };
        this.sendMailAction.setText(Messages.ExterneDokumente_sendEmail);
        this.sendMailAction.setImageDescriptor(Images.IMG_MAIL.getImageDescriptor());
        this.sendMailAction.setToolTipText(Messages.ExterneDokumente_sendEmailTip);
        this.openFolderAction = new Action(){

            public void run() {
                List<File> directories = ListFiles.getDirectoriesForActPatient(ExterneDokumente.this.actPatient);
                if (directories.size() == 0) {
                    if (ExterneDokumente.this.actPatient != null) {
                        logger.info("No active directories for " + ExterneDokumente.this.actPatient.getPersonalia());
                    }
                    return;
                }
                for (File directory : directories) {
                    logger.info("will launch folder: " + directory.toString());
                    if (Program.launch((String)("file://" + directory.toString()))) continue;
                    logger.info("Could not open directory " + directory.toString());
                }
            }
        };
        this.openFolderAction.setText(Messages.ExterneDokumente_openFolder);
        this.openFolderAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.iatrix", (String)"rsc/folder.png"));
        this.openFolderAction.setToolTipText(Messages.ExterneDokumente_openFolderTip);
        this.openAction = new Action(){

            public void run() {
                Object element;
                StructuredSelection selection = (StructuredSelection)ExterneDokumente.this.viewer.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof File) {
                    File file = (File)element;
                    String path = file.getAbsolutePath();
                    Program.launch((String)path);
                }
            }
        };
        this.openAction.setText(Messages.ExterneDokumente_open);
        this.openAction.setToolTipText(Messages.ExterneDokumente_OpenFileTip);
        this.openAction.setImageDescriptor(Images.IMG_DOCUMENT_TEXT.getImageDescriptor());
        this.doubleClickAction = new Action(){

            public void run() {
                ExterneDokumente.this.openAction.run();
            }
        };
        this.editAction = new Action(){

            public void run() {
                Object element;
                StructuredSelection selection = (StructuredSelection)ExterneDokumente.this.viewer.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof File) {
                    ExterneDokumente.this.openFileEditorDialog((File)element);
                }
            }
        };
        this.editAction.setText(Messages.ExterneDokumente_propeties);
        this.editAction.setToolTipText(Messages.ExterneDokumente_rename_or_change_date);
        this.editAction.setActionDefinitionId("ch.elexis.extdoc.commands.edit_properties");
        this.editAction.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.editAction);
        this.deleteAction = new Action(){

            public void run() {
                File file;
                Object element;
                StructuredSelection selection = (StructuredSelection)ExterneDokumente.this.viewer.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof File && SWTHelper.askYesNo((String)Messages.ExterneDokumente_delete_doc, (String)(Messages.ExterneDokumente_shold_doc_be_delted + (file = (File)element).getName()))) {
                    logger.info("Datei L\u00f6schen: " + file.getAbsolutePath());
                    file.delete();
                    ExterneDokumente.this.refreshInternal();
                }
            }
        };
        this.deleteAction.setText(Messages.ExterneDokumente_delete);
        this.deleteAction.setToolTipText(Messages.ExterneDokumente_delete_files);
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.deleteAction);
        this.renameAction = new Action(){

            public void run() {
                Object element;
                StructuredSelection selection = (StructuredSelection)ExterneDokumente.this.viewer.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof File) {
                    ExterneDokumente.this.openFileEditorDialog((File)element);
                }
            }
        };
        this.renameAction.setText(Messages.ExterneDokumente_renaming_file);
        this.renameAction.setToolTipText(Messages.ExterneDokumente_renaming_file);
        this.renameAction.setActionDefinitionId("ch.elexis.extdoc.commands.rename");
        GlobalActions.registerActionHandler((ViewPart)this, (IAction)this.renameAction);
        this.verifyAction = new Action(){

            public void run() {
                new VerifierDialog(ExterneDokumente.this.getViewSite().getShell(), ExterneDokumente.this.actPatient).open();
                ExterneDokumente.this.refreshInternal();
            }
        };
        this.verifyAction.setText(Messages.ExterneDokumente_verify_files);
        this.verifyAction.setToolTipText(Messages.ExterneDokumente_verify_files_Belong_to_patient);
        this.moveIntoSubDirsActions = new MoveIntoSubDirsDialog();
        this.moveIntoSubDirsActions.setText(Messages.ExterneDokumente_move_into_subdir);
        this.moveIntoSubDirsActions.setToolTipText(Messages.ExterneDokumente_move_into_subdir_tooltip);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExterneDokumente.this.doubleClickAction.run();
            }
        });
    }

    private void refreshInternal() {
        PreferenceConstants.PathElement[] prefs = PreferenceConstants.getPrefenceElements();
        int j = 0;
        while (j < prefs.length) {
            if (this.pathCheckBoxes[j] != null && this.pathCheckBoxes[j].getSelection()) {
                this.activePaths[j] = prefs[j].baseDir;
                PreferenceConstants.pathSetSelected(j, true);
            } else {
                this.activePaths[j] = null;
                PreferenceConstants.pathSetSelected(j, false);
            }
            ++j;
        }
        PreferenceConstants.saveSelected();
        this.globalJob.invalidate();
        this.viewer.refresh(true);
    }

    private void openFileEditorDialog(File file) {
        FileEditDialog fed = new FileEditDialog(this.getViewSite().getShell(), file);
        fed.open();
        this.refreshInternal();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
    }

    public void selectionEvent(PersistentObject obj) {
        boolean cfr_ignored_0 = obj instanceof Patient;
    }

    public void refresh() {
        this.activePatient(ContextServiceHolder.get().getActivePatient().orElse(null));
    }

    class DataLoader
    extends BackgroundJob {
        public DataLoader(String jobName) {
            super(jobName);
        }

        public IStatus execute(IProgressMonitor monitor) {
            this.result = ExterneDokumente.this.actPatient != null ? MatchPatientToPath.getFilesForPatient(ExterneDokumente.this.actPatient, ExterneDokumente.this.activePaths) : Messages.ExterneDokumente_no_patient_found;
            return Status.OK_STATUS;
        }

        public int getSize() {
            return ExterneDokumente.this.lastSize;
        }
    }

    class FilenameComparator
    extends ViewerComparator {
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void changeSortOrder() {
            this.direction = -this.direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 == null) {
                return this.direction;
            }
            if (e2 == null) {
                return -this.direction;
            }
            File file1 = (File)e1;
            File file2 = (File)e2;
            return this.direction * file1.compareTo(file2);
        }
    }

    class TimestampComparator
    extends ViewerComparator {
        private static final int DESCENDING = 1;
        private int direction = 1;

        public void changeSortOrder() {
            this.direction = -this.direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            long modified2;
            if (e1 == null) {
                return this.direction;
            }
            if (e2 == null) {
                return -this.direction;
            }
            File file1 = (File)e1;
            File file2 = (File)e2;
            long modified1 = file1.lastModified();
            if (modified1 < (modified2 = file2.lastModified())) {
                return -this.direction;
            }
            if (modified1 > modified2) {
                return this.direction;
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    BackgroundJob.BackgroundJobListener {
        BackgroundJob job;

        public ViewContentProvider() {
            ExterneDokumente.this.globalJob = this.job = new DataLoader(Messages.ExterneDokumente_externe_dokumente);
            if (JobPool.getJobPool().getJob(this.job.getJobname()) == null) {
                JobPool.getJobPool().addJob(this.job);
            }
            this.job.addListener((BackgroundJob.BackgroundJobListener)this);
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            this.job.removeListener((BackgroundJob.BackgroundJobListener)this);
        }

        public Object[] getElements(Object parent) {
            Object result = this.job.getData();
            if (result == null) {
                JobPool.getJobPool().activate(this.job.getJobname(), 30);
                return new String[]{Messages.ExterneDokumente_loading};
            }
            if (result instanceof List) {
                return ((List)result).toArray();
            }
            if (result instanceof String) {
                return new Object[]{result};
            }
            return null;
        }

        public void jobFinished(BackgroundJob j) {
            ExterneDokumente.this.viewer.refresh(true);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final int DATE_COLUMN = 0;
        private static final int NAME_COLUMN = 1;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return this.getDate(obj);
                }
                case 1: {
                    return this.getText(obj);
                }
            }
            return "";
        }

        public String getText(Object obj) {
            if (obj instanceof File) {
                File file = (File)obj;
                return file.getName();
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            return "";
        }

        public String getDate(Object obj) {
            if (obj instanceof File) {
                File file = (File)obj;
                long modified = file.lastModified();
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(modified);
                TimeTool tl = new TimeTool(cal.getTimeInMillis());
                String modifiedTime = String.format(Messages.ExterneDokumente_modified_time, tl.toString(6), tl.toString(3));
                return modifiedTime;
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            switch (index) {
                case 1: {
                    return this.getImage(obj);
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (!(obj instanceof File)) {
                return null;
            }
            File file = (File)obj;
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }
}

