/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.extdoc.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.extdoc.Messages;
import ch.elexis.extdoc.omnivore.OmnivoreImporter;
import ch.elexis.extdoc.preferences.PreferenceConstants;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.slf4j.LoggerFactory;

public class ExterneDokumente
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public ExterneDokumente() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
        this.setDescription(Messages.ExterneDokumente_externe_dokumente);
    }

    protected void createFieldEditors() {
        StringFieldEditor sfe;
        PreferenceConstants.PathElement[] prefElems = PreferenceConstants.getPrefenceElements();
        int j = 0;
        while (j < prefElems.length) {
            sfe = new StringFieldEditor(prefElems[j].prefName, String.format(Messages.ExterneDokumente_shorthand_for_path, j), this.getFieldEditorParent());
            sfe.setTextLimit(8);
            this.addField((FieldEditor)sfe);
            DirectoryFieldEditor dfe = new DirectoryFieldEditor(prefElems[j].prefBaseDir, Messages.ExterneDokumente_path_name_preference, this.getFieldEditorParent());
            this.addField((FieldEditor)dfe);
            ++j;
        }
        sfe = new StringFieldEditor("ch.elexis.externe_dokumente/Concerns", Messages.ExterneDokumente_Concerns, this.getFieldEditorParent());
        sfe.setTextLimit(60);
        this.addField((FieldEditor)sfe);
        Composite composite = this.getFieldEditorParent();
        FileFieldEditor ffe = new FileFieldEditor("ch.elexis.externe_dokumente/Email_app", Messages.ExterneDokumente_email_app, this.getFieldEditorParent());
        ffe.getLabelControl(composite).setToolTipText("Programm das zum Verschicken von E-Mails verwendet werden soll, falls leer wird dir URL mailto: verwendet, welche keine Anh\u00e4nge unterst\u00fctzt");
        this.addField((FieldEditor)ffe);
        final OmnivoreImporter importer = new OmnivoreImporter();
        Button omnivoreBtn = new Button(this.getFieldEditorParent(), 8);
        omnivoreBtn.setText("Dateien in Omnivore importieren");
        omnivoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional<ICategory> importCategory = importer.getCategory();
                importCategory.ifPresent(category -> {
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                    try {
                        dialog.run(true, true, new IRunnableWithProgress((ICategory)category){
                            private final /* synthetic */ ICategory val$category;
                            {
                                this.val$category = iCategory;
                            }

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                importer.importAll(this.val$category, monitor);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException ex) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Beim Import ist ein Fehler aufgetreten.");
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Exception on external file import", (Throwable)ex);
                    }
                });
            }
        });
        omnivoreBtn.setEnabled(importer.isAvailable());
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }
}

