/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ebanking.parser;

import camt.AccountNotification12;
import camt.ActiveOrHistoricCurrencyAndAmount;
import camt.CreditorReferenceInformation2;
import camt.DateAndDateTimeChoice;
import camt.Document;
import camt.EntryDetails7;
import camt.EntryTransaction8;
import camt.ObjectFactory;
import camt.RemittanceInformation11;
import camt.ReportEntry8;
import camt.StructuredRemittanceInformation13;
import camt.TransactionDates2;
import ch.elexis.ebanking.parser.Camet054Exception;
import ch.elexis.ebanking.parser.Camt054Record;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class Camt054Parser {
    public Document parse(InputStream inputStream) throws Camet054Exception {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            XMLStreamReader xsr = XMLInputFactory.newFactory().createXMLStreamReader(inputStream);
            XMLReaderWithoutNamespace xr = new XMLReaderWithoutNamespace(xsr);
            Unmarshaller um = jc.createUnmarshaller();
            return (Document)((JAXBElement)um.unmarshal((XMLStreamReader)xr)).getValue();
        }
        catch (Exception e) {
            throw new Camet054Exception("parse error", e);
        }
    }

    public List<Camt054Record> parseRecords(InputStream inputStream) throws Camet054Exception {
        ArrayList<Camt054Record> records = new ArrayList<Camt054Record>();
        Document doc = this.parse(inputStream);
        List<AccountNotification12> notifications = doc.getBkToCstmrDbtCdtNtfctn().getNtfctn();
        for (AccountNotification12 accountNotification12 : notifications) {
            XMLGregorianCalendar credDate = accountNotification12.getCreDtTm();
            List<ReportEntry8> reportEntry8s = accountNotification12.getNtry();
            for (ReportEntry8 reportEntry8 : reportEntry8s) {
                ActiveOrHistoricCurrencyAndAmount entryAmt = reportEntry8.getAmt();
                DateAndDateTimeChoice bookingDate = reportEntry8.getBookgDt();
                DateAndDateTimeChoice valDate = reportEntry8.getValDt();
                boolean storno = Boolean.TRUE.equals(reportEntry8.isRvslInd());
                String esrTn = reportEntry8.getNtryRef();
                List<EntryDetails7> entryDetails7s = reportEntry8.getNtryDtls();
                for (EntryDetails7 entryDetails7 : entryDetails7s) {
                    List<EntryTransaction8> entryTransaction8s = entryDetails7.getTxDtls();
                    for (EntryTransaction8 entryTransaction8 : entryTransaction8s) {
                        ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = entryTransaction8.getAmt();
                        BigDecimal amount = activeOrHistoricCurrencyAndAmount.getValue();
                        RemittanceInformation11 remittanceInformation11 = entryTransaction8.getRmtInf();
                        if (remittanceInformation11 == null) continue;
                        List<StructuredRemittanceInformation13> structuredRemittanceInformation13s = remittanceInformation11.getStrd();
                        XMLGregorianCalendar readDate = null;
                        TransactionDates2 transactionDates2 = entryTransaction8.getRltdDts();
                        if (transactionDates2 != null) {
                            readDate = transactionDates2.getAccptncDtTm();
                        }
                        if (readDate == null) {
                            readDate = bookingDate != null ? bookingDate.getDt() : null;
                        }
                        for (StructuredRemittanceInformation13 structuredRemittanceInformation13 : structuredRemittanceInformation13s) {
                            CreditorReferenceInformation2 creditorReferenceInformation2 = structuredRemittanceInformation13.getCdtrRefInf();
                            String ref = creditorReferenceInformation2 != null ? creditorReferenceInformation2.getRef() : null;
                            records.add(new Camt054Record(storno ? "005" : "002", amount != null ? amount.movePointRight(2).toString().replaceAll("[\\.,]", "") : "", ref, esrTn, readDate != null ? readDate.toGregorianCalendar().getTime() : null, bookingDate != null ? bookingDate.getDt().toGregorianCalendar().getTime() : null, valDate != null ? valDate.getDt().toGregorianCalendar().getTime() : null));
                        }
                    }
                }
                records.add(new Camt054Record("999", entryAmt != null ? entryAmt.getValue().movePointRight(2).toString().replaceAll("[\\.,]", "") : null, null, esrTn, credDate.toGregorianCalendar().getTime(), credDate.toGregorianCalendar().getTime(), credDate.toGregorianCalendar().getTime()));
            }
        }
        return records;
    }

    class XMLReaderWithoutNamespace
    extends StreamReaderDelegate {
        public XMLReaderWithoutNamespace(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public String getAttributeNamespace(int arg0) {
            return "";
        }

        @Override
        public String getNamespaceURI() {
            return "urn:iso:std:iso:20022:tech:xsd:camt.054.001.06";
        }
    }
}

