/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ebanking.qr;

import ch.elexis.ebanking.qr.model.QRBillData;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.Hashtable;
import java.util.Optional;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.slf4j.LoggerFactory;

public class QRBillImage {
    private QRBillData data;
    private int[] emptyRow = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    private int[] fullRow;
    private int[] vertRow;
    private int[] horiRow;

    public QRBillImage(QRBillData data) {
        int[] nArray = new int[32];
        nArray[0] = 0xFFFFFF;
        nArray[31] = 0xFFFFFF;
        this.fullRow = nArray;
        int[] nArray2 = new int[32];
        nArray2[0] = 0xFFFFFF;
        nArray2[13] = 0xFFFFFF;
        nArray2[14] = 0xFFFFFF;
        nArray2[15] = 0xFFFFFF;
        nArray2[16] = 0xFFFFFF;
        nArray2[17] = 0xFFFFFF;
        nArray2[18] = 0xFFFFFF;
        nArray2[31] = 0xFFFFFF;
        this.vertRow = nArray2;
        int[] nArray3 = new int[32];
        nArray3[0] = 0xFFFFFF;
        nArray3[3] = 0xFFFFFF;
        nArray3[4] = 0xFFFFFF;
        nArray3[5] = 0xFFFFFF;
        nArray3[6] = 0xFFFFFF;
        nArray3[7] = 0xFFFFFF;
        nArray3[8] = 0xFFFFFF;
        nArray3[9] = 0xFFFFFF;
        nArray3[10] = 0xFFFFFF;
        nArray3[11] = 0xFFFFFF;
        nArray3[12] = 0xFFFFFF;
        nArray3[13] = 0xFFFFFF;
        nArray3[14] = 0xFFFFFF;
        nArray3[15] = 0xFFFFFF;
        nArray3[16] = 0xFFFFFF;
        nArray3[17] = 0xFFFFFF;
        nArray3[18] = 0xFFFFFF;
        nArray3[19] = 0xFFFFFF;
        nArray3[20] = 0xFFFFFF;
        nArray3[21] = 0xFFFFFF;
        nArray3[22] = 0xFFFFFF;
        nArray3[23] = 0xFFFFFF;
        nArray3[24] = 0xFFFFFF;
        nArray3[25] = 0xFFFFFF;
        nArray3[26] = 0xFFFFFF;
        nArray3[27] = 0xFFFFFF;
        nArray3[28] = 0xFFFFFF;
        nArray3[31] = 0xFFFFFF;
        this.horiRow = nArray3;
        this.data = data;
    }

    public Optional<Image> getImage() {
        Hashtable<EncodeHintType, Object> hintMap = new Hashtable<EncodeHintType, Object>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hintMap.put(EncodeHintType.QR_VERSION, 18);
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode(this.data.toString(), BarcodeFormat.QR_CODE, 200, 200, hintMap);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            ImageData data = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    data.setPixel(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
                    ++x;
                }
                ++y;
            }
            this.addCross(data);
            return Optional.of(new Image((Device)Display.getDefault(), data));
        }
        catch (WriterException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error creating QR", (Throwable)e);
            return Optional.empty();
        }
    }

    private void addCross(ImageData data) {
        int center = data.width / 2;
        int start = center - 16;
        int lineCount = 0;
        while (lineCount < 32) {
            if (lineCount == 0 || lineCount == 31) {
                data.setPixels(start, start + lineCount, 32, this.emptyRow, 0);
            } else if (lineCount < 3 || lineCount > 27) {
                data.setPixels(start, start + lineCount, 32, this.fullRow, 0);
            } else if (lineCount > 12 && lineCount < 18) {
                data.setPixels(start, start + lineCount, 32, this.horiRow, 0);
            } else {
                data.setPixels(start, start + lineCount, 32, this.vertRow, 0);
            }
            ++lineCount;
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<String> getEncodedImage() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

