/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.docbox.ws.client.WsClientUtil;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class WsClientConfig {
    public static String TESTLOGINIDPREFIX = "TEST_";
    public static final String USR_DEFDOCBXLOGINID = "docbox/loginid";
    public static final String USR_DEFDOCBOXPASSWORD = "docbox/password";
    public static final String USR_SECRETKEY = "docbox/secretkey";
    private static Properties basicAuthProperties;

    public static String getUsername() {
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return WsClientConfig.getDocboxLoginID(false);
        }
        return "";
    }

    public static String getPassword() {
        if (ContextServiceHolder.get().getActiveMandator().isPresent()) {
            return WsClientConfig.getSha1DocboxPassword();
        }
        return "";
    }

    public static String getDocboxServiceUrl() {
        String host = WsClientConfig.getHost();
        return "https://" + host + "/CDACHServicesV2";
    }

    private static String getHost() {
        String host = "";
        host = WsClientConfig.isDocboxTest() ? "soap.test.docbox.swiss" : "soap.docbox.swiss";
        return host;
    }

    private static boolean isDocboxTest() {
        return WsClientConfig.getDocboxLoginID(true) != null && WsClientConfig.getDocboxLoginID(true).startsWith("TEST_");
    }

    private static String getDocboxLoginID(boolean prefixed) {
        String loginId = ConfigServiceHolder.getMandator((String)USR_DEFDOCBXLOGINID, (String)"");
        if (!prefixed && loginId.startsWith(TESTLOGINIDPREFIX)) {
            loginId = loginId.substring(TESTLOGINIDPREFIX.length());
        }
        return loginId;
    }

    public static String getSha1DocboxPassword() {
        String sha1Password = ConfigServiceHolder.getMandator((String)USR_DEFDOCBOXPASSWORD, (String)"");
        return sha1Password;
    }

    public static String getDocboxBasicAuth() {
        return WsClientConfig.getBasicAuthProperties().getProperty("auth");
    }

    public static String getDocboxBasicUser() {
        return WsClientConfig.getBasicAuthProperties().getProperty("user");
    }

    private static synchronized Properties getBasicAuthProperties() {
        if (basicAuthProperties == null) {
            basicAuthProperties = new Properties();
            try {
                basicAuthProperties.load(WsClientUtil.getBasicAuthInputStream());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(WsClientConfig.class).error("Error loading basic auth properties");
            }
        }
        return basicAuthProperties;
    }
}

