/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import ch.docbox.ws.cdachservicesv2.CDACHServicesV2;
import ch.docbox.ws.cdachservicesv2.CDACHServicesV2_Service;
import ch.elexis.docbox.ws.client.CdaUtil;
import ch.elexis.docbox.ws.client.WsClientConfig;
import ch.elexis.docbox.ws.client.WsClientUtil;
import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.hl7.v3.ClinicalDocumentType;
import org.hl7.v3.POCDMT000040ClinicalDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendClinicalDocumentClient {
    private static Logger logger = LoggerFactory.getLogger(SendClinicalDocumentClient.class);
    private CDACHServicesV2_Service service;
    private CDACHServicesV2 port;
    private Holder<Boolean> success = new Holder();
    private Holder<String> message = new Holder();
    private Holder<String> documentId = new Holder();

    public SendClinicalDocumentClient() {
        this.service = new CDACHServicesV2_Service();
        WsClientUtil.addWsSecurityAndHttpConfigWithClientCert(this.service, WsClientConfig.getUsername(), WsClientConfig.getPassword());
    }

    public boolean hasAccess() {
        if (this.port == null) {
            this.initPort();
        }
        return WsClientUtil.checkAccess(this.port);
    }

    private synchronized void initPort() {
        if (this.port == null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(SOAPBinding.class.getClassLoader());
                this.port = this.service.getCDACHServicesV2();
                ((BindingProvider)this.port).getRequestContext().put("jakarta.xml.ws.service.endpoint.address", WsClientConfig.getDocboxServiceUrl());
                HashMap<String, List<CallSite>> headers = new HashMap<String, List<CallSite>>();
                headers.put("Authorization", Collections.singletonList("Basic " + WsClientConfig.getDocboxBasicAuth()));
                ((BindingProvider)this.port).getRequestContext().put("jakarta.xml.ws.http.request.headers", headers);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public boolean sendClinicalDocument(InputStream xmlFile, InputStream pdfFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException("XML input is null.");
        }
        if (this.port == null) {
            this.initPort();
        }
        POCDMT000040ClinicalDocument clinicalDocument = null;
        try {
            clinicalDocument = CdaUtil.unmarshall(xmlFile);
            ClinicalDocumentType clinicalDocumentType = new ClinicalDocumentType();
            clinicalDocumentType.setClinicalDocument(clinicalDocument);
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (pdfFile != null) {
                try {
                    int len;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipOutputStream out = new ZipOutputStream(byteArrayOutputStream);
                    out.putNextEntry(new ZipEntry("file.pdf"));
                    byte[] buffer = new byte[1024];
                    while ((len = pdfFile.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.closeEntry();
                    out.close();
                }
                catch (IOException e) {
                    logger.error("Could not attach pdf.", (Throwable)e);
                    byteArrayOutputStream = null;
                }
            }
            this.port.sendClinicalDocument(clinicalDocumentType, byteArrayOutputStream != null ? byteArrayOutputStream.toByteArray() : null, this.success, this.message, this.documentId);
        }
        catch (JAXBException e) {
            logger.error("XML input is not a valid clinical document.", (Throwable)e);
            return false;
        }
        if (!((Boolean)this.success.value).booleanValue()) {
            logger.error("Could not send clinical document. " + (String)this.message.value);
            if (clinicalDocument != null) {
                logger.debug(CdaUtil.marshallIntoString(clinicalDocument));
            }
        } else {
            logger.debug("Sent document " + (String)this.message.value);
        }
        return (Boolean)this.success.value;
    }

    public String getDocumentId() {
        return (String)this.documentId.value;
    }

    public String getMessage() {
        return (String)this.message.value;
    }
}

