/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.docbox.ws.client;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hl7.v3.POCDMT000040ClinicalDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdaUtil {
    private static Logger logger = LoggerFactory.getLogger(CdaUtil.class);
    private static Unmarshaller unmarshaller;
    private static Marshaller marshaller;

    public static synchronized Unmarshaller getCdaUnmarshaller() {
        if (unmarshaller == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(CdaUtil.class.getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
                unmarshaller = jaxbContext.createUnmarshaller();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(CdaUtil.class).error("Failure in JAXBContext.newInstance", (Throwable)e);
                e.printStackTrace(System.out);
                marshaller = null;
            }
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return unmarshaller;
    }

    public static synchronized Marshaller getMarshaller() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CdaUtil.class.getClassLoader());
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.hl7.v3");
            marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.schemaLocation", (Object)"urn:hl7-org:v3 CDA.xsd");
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(CdaUtil.class).error("Failure in JAXBContext.newInstance", (Throwable)e);
            e.printStackTrace(System.out);
            marshaller = null;
        }
        Thread.currentThread().setContextClassLoader(tccl);
        return marshaller;
    }

    public static POCDMT000040ClinicalDocument unmarshall(InputStream source) throws JAXBException {
        Unmarshaller unmarshaller = CdaUtil.getCdaUnmarshaller();
        JAXBElement doc = unmarshaller.unmarshal((Source)new StreamSource(source), POCDMT000040ClinicalDocument.class);
        return (POCDMT000040ClinicalDocument)doc.getValue();
    }

    public static String marshallIntoString(POCDMT000040ClinicalDocument clinicalDocumentType) {
        StringWriter writer = new StringWriter();
        try {
            Marshaller marshaller = CdaUtil.getMarshaller();
            marshaller.marshal((Object)new JAXBElement(new QName("urn:hl7-org:v3", "ClinicalDocument"), POCDMT000040ClinicalDocument.class, (Object)clinicalDocumentType), (Writer)writer);
        }
        catch (Exception e) {
            logger.error("Could not marshall to string.", (Throwable)e);
            return null;
        }
        return writer.toString();
    }
}

