/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.dbcheck;

import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.rcp.utils.OsgiServiceUtil;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.covid.cert.service.CertificateInfo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;

public class RemoveDuplicateTestCerts
extends ExternalMaintenance {
    private IDocumentStore omnivoreDocumentStore;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.omnivoreDocumentStore = (IDocumentStore)OsgiServiceUtil.getService(IDocumentStore.class, (String)"(storeid=ch.elexis.data.store.omnivore)").orElseThrow(() -> new IllegalStateException("No Omnivore Document Store available."));
        IQuery patientsQuery = CoreModelServiceHolder.get().getQuery(IPatient.class);
        int removeCount = 0;
        int totalCount = 0;
        Throwable throwable = null;
        Object var7_8 = null;
        try (IQueryCursor cursor = patientsQuery.executeAsCursor();){
            pm.beginTask("Bitte warten, COVID Test Zertifikat Duplikate werden entfernt ...", cursor.size());
            while (cursor.hasNext()) {
                IPatient patient = (IPatient)cursor.next();
                List<CertificateInfo> certificates = CertificateInfo.of(patient);
                if (!certificates.isEmpty()) {
                    List<CertificateInfo> testCertificates = certificates.stream().filter(c -> c.getType() == CertificateInfo.Type.TEST).collect(Collectors.toList());
                    totalCount += testCertificates.size();
                    Map<LocalDate, List<CertificateInfo>> certificatesDayMap = this.getCertificatesDayMap(testCertificates);
                    for (LocalDate date : certificatesDayMap.keySet()) {
                        List<CertificateInfo> list = certificatesDayMap.get(date);
                        if (list.size() <= 1) continue;
                        list.sort(new Comparator<CertificateInfo>(){

                            @Override
                            public int compare(CertificateInfo o1, CertificateInfo o2) {
                                return o2.getTimestamp().compareTo(o1.getTimestamp());
                            }
                        });
                        int i = 1;
                        while (i < list.size()) {
                            CertificateInfo info = list.get(i);
                            Optional document = this.omnivoreDocumentStore.loadDocument(info.getDocumentId());
                            if (document.isPresent()) {
                                this.omnivoreDocumentStore.removeDocument((IDocument)document.get());
                            }
                            CertificateInfo.remove(info, patient);
                            ++removeCount;
                            ++i;
                        }
                    }
                }
                pm.worked(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        OsgiServiceUtil.ungetService((Object)this.omnivoreDocumentStore);
        return "Es wurden " + removeCount + " Duplikate aus " + totalCount + " Zertifikaten entfernt.";
    }

    private Map<LocalDate, List<CertificateInfo>> getCertificatesDayMap(List<CertificateInfo> testCertificates) {
        HashMap<LocalDate, List<CertificateInfo>> ret = new HashMap<LocalDate, List<CertificateInfo>>();
        for (CertificateInfo certificateInfo : testCertificates) {
            LocalDate date = certificateInfo.getTimestamp().toLocalDate();
            ArrayList<CertificateInfo> list = (ArrayList<CertificateInfo>)ret.get(date);
            if (list == null) {
                list = new ArrayList<CertificateInfo>();
            }
            list.add(certificateInfo);
            ret.put(date, list);
        }
        return ret;
    }

    public String getMaintenanceDescription() {
        return "COVID Test Zertifikat Duplikate (am selben Tag) entfernen.";
    }
}

