/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.service.rest.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.covid.cert.service.rest.model.Name;
import ch.elexis.covid.cert.service.rest.model.TestInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class TestModel {
    private Name name;
    private String dateOfBirth;
    private String language;
    private String otp;
    private String appCode;
    private TestInfo[] testInfo;

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOtp() {
        return this.otp;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public TestInfo[] getTestInfo() {
        return this.testInfo;
    }

    public void setTestInfo(TestInfo[] testInfo) {
        this.testInfo = testInfo;
    }

    public TestModel initDefault(IPatient patient, String otp) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.setName(Name.of(patient));
        this.setDateOfBirth(formatter.format(patient.getDateOfBirth()));
        this.setLanguage(Locale.getDefault().getLanguage().toLowerCase());
        this.setOtp(otp);
        TestInfo testinfo = new TestInfo();
        ZonedDateTime zonedNow = LocalDateTime.now().minusMinutes(5L).atZone(ZoneId.systemDefault());
        ZonedDateTime utcDateTime = zonedNow.withZoneSameInstant(ZoneId.of("Z"));
        testinfo.setSampleDateTime(TestInfo.formatter.format(utcDateTime));
        testinfo.setMemberStateOfTest("CH");
        testinfo.setTestingCentreOrFacility(ConfigServiceHolder.get().get(CertificatesService.CFG_TESTCENTERNAME, ""));
        this.setTestInfo(new TestInfo[]{testinfo});
        return this;
    }
}

