/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.dbcheck;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.IQueryCursor;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.StickerServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.core.utils.CoreUtil;
import ch.elexis.covid.cert.service.CertificateInfo;
import ch.elexis.scripting.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class FixBillMissingTestCerts
extends ExternalMaintenance {
    private List<FixInfo> fixInfos;
    private SelectOptionsDialog dialog;
    private boolean dialogOk;
    private int invoiceStateChangeCount;
    private int encounterStickerCount;
    private int encounterDeleteCount;

    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        this.dialog = null;
        this.dialogOk = false;
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(() -> {
                this.dialog = new SelectOptionsDialog(display.getActiveShell());
                this.dialogOk = this.dialog.open() == 0;
            });
        }
        if (this.dialog != null) {
            this.invoiceStateChangeCount = 0;
            this.encounterStickerCount = 0;
            this.encounterDeleteCount = 0;
            IQuery patientsQuery = CoreModelServiceHolder.get().getQuery(IPatient.class);
            this.fixInfos = new ArrayList<FixInfo>();
            Throwable throwable = null;
            Iterator<FixInfo> iterator = null;
            try (IQueryCursor cursor = patientsQuery.executeAsCursor();){
                pm.beginTask("Bitte warten, falsch verrechnete COVID Test Zertifikate werden gesucht ...", cursor.size());
                while (cursor.hasNext()) {
                    IPatient patient = (IPatient)cursor.next();
                    List<CertificateInfo> certificates = CertificateInfo.of(patient);
                    if (!certificates.isEmpty()) {
                        List<CertificateInfo> testCertificates = certificates.stream().filter(c -> c.getType() == CertificateInfo.Type.TEST).collect(Collectors.toList());
                        testCertificates.forEach(cert -> {
                            List<IEncounter> encountersAt = this.getEncountersAt(patient, cert.getTimestamp().toLocalDate());
                            List<IEncounter> certificateBilledEncounters = encountersAt.stream().filter(encounter -> this.isCertificateBilled((IEncounter)encounter)).collect(Collectors.toList());
                            if (certificateBilledEncounters.size() > 1) {
                                this.fixInfos.add(new FixInfo(patient, cert.getTimestamp().toLocalDate(), certificateBilledEncounters));
                            }
                        });
                    }
                    pm.worked(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (this.fixInfos != null && !this.fixInfos.isEmpty()) {
                this.writeCsv();
                if (this.dialogOk) {
                    ISticker fixEncountersSticker;
                    if (this.dialog.isInvoiceStatus()) {
                        for (FixInfo fixInfo : this.fixInfos) {
                            List<IInvoice> invoices = fixInfo.getInvoicesToFix();
                            invoices.forEach(i -> {
                                if (i.getState() == InvoiceState.PAID) {
                                    i.setState(InvoiceState.TOTAL_LOSS);
                                    ++this.invoiceStateChangeCount;
                                } else if (i.getState() != InvoiceState.PARTIAL_LOSS) {
                                    i.setState(InvoiceState.PARTIAL_LOSS);
                                    ++this.invoiceStateChangeCount;
                                }
                            });
                            CoreModelServiceHolder.get().save(invoices);
                        }
                    }
                    if (this.dialog.isEncounterSticker()) {
                        fixEncountersSticker = this.getOrCreateSticker("fix_bill_test_certs");
                        for (FixInfo fixInfo : this.fixInfos) {
                            List<IEncounter> encounters = fixInfo.getEncountersToFix();
                            encounters.forEach(e -> {
                                if (!StickerServiceHolder.get().hasSticker((Identifiable)e, fixEncountersSticker)) {
                                    StickerServiceHolder.get().addSticker(fixEncountersSticker, (Identifiable)e);
                                    ++this.encounterStickerCount;
                                }
                            });
                        }
                    }
                    if (this.dialog.isDeleteEncounterWithSticker()) {
                        fixEncountersSticker = this.getOrCreateSticker("fix_bill_test_certs");
                        List markedEncounters = StickerServiceHolder.get().getObjectsWithSticker(fixEncountersSticker, IEncounter.class);
                        markedEncounters.forEach(e -> {
                            ArrayList encounterBilled = new ArrayList(e.getBilled());
                            for (IBilled billed : encounterBilled) {
                                e.removeBilled(billed);
                            }
                            CoreModelServiceHolder.get().delete((Deleteable)e);
                            ++this.encounterDeleteCount;
                        });
                    }
                }
            }
            return "Es wurden " + this.fixInfos.size() + " falsch verrechnete Zertifikate gefunden.\n(FixCovidBilled.csv Datei im user home elexis Verzeichnis)\nEs wurden " + this.invoiceStateChangeCount + " Rechngsstatus ge\u00e4ndert\nEs wurden " + this.encounterStickerCount + " Konsultationen mit Sticker markiert\nEs wurden " + this.encounterDeleteCount + " Konsultationen gel\u00f6scht\n";
        }
        return "Konnte Optionsdialog nicht \u00f6ffnen";
    }

    private ISticker getOrCreateSticker(String name) {
        IQuery query = CoreModelServiceHolder.get().getQuery(ISticker.class);
        query.and("name", IQuery.COMPARATOR.EQUALS, (Object)name);
        ISticker existing = query.executeSingleResult().orElse(null);
        if (existing == null) {
            existing = (ISticker)CoreModelServiceHolder.get().create(ISticker.class);
            existing.setName(name);
            existing.setForeground("000000");
            existing.setBackground("ffffff");
            CoreModelServiceHolder.get().save((Identifiable)existing);
            StickerServiceHolder.get().setStickerAddableToClass(IEncounter.class, existing);
        }
        return existing;
    }

    private void writeCsv() {
        File file = new File(CoreUtil.getWritableUserDir(), "FixCovidBilled.csv");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter fw = new FileWriter(file);){
                CSVWriter csv = new CSVWriter((Writer)fw);
                String[] header = new String[]{"PatNr", "Name", "Vorname", "GebDatum", "KonsDatum", "Krankenkasse", "RGNr", "RG-Status", "RG-Betrag"};
                csv.writeNext(header);
                for (FixInfo fixInfo : this.fixInfos) {
                    String[] line = new String[header.length];
                    line[0] = fixInfo.patient.getPatientNr();
                    line[1] = fixInfo.patient.getLastName();
                    line[2] = fixInfo.patient.getFirstName();
                    line[3] = fixInfo.patient.getDateOfBirth() != null ? fixInfo.patient.getDateOfBirth().toLocalDate().toString() : "";
                    line[4] = fixInfo.localDate.toString();
                    line[5] = fixInfo.getInsurance();
                    line[6] = fixInfo.getInvoiceNumber();
                    line[7] = fixInfo.getInvoiceStatus();
                    line[8] = fixInfo.getInvoiceAmount();
                    csv.writeNext(line);
                }
                csv.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error writing fix covid billed info", (Throwable)e);
        }
    }

    private List<IEncounter> getEncountersAt(IPatient patient, LocalDate localDate) {
        if (patient.getCoverages() != null) {
            List coverages = patient.getCoverages();
            coverages.sort(new Comparator<ICoverage>(){

                @Override
                public int compare(ICoverage o1, ICoverage o2) {
                    return o2.getDateFrom().compareTo(o1.getDateFrom());
                }
            });
            return coverages.stream().filter(coverage -> coverage.isOpen()).flatMap(coverage -> coverage.getEncounters().stream()).filter(encounter -> encounter.getDate().equals(localDate)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean isCertificateBilled(IEncounter encounter) {
        Optional<IBilled> found = encounter.getBilled().stream().filter(billed -> this.isCertificateBilled((IBilled)billed)).findFirst();
        return found.isPresent();
    }

    private boolean isCertificateBilled(IBilled billed) {
        IBillable billable = billed.getBillable();
        if (billable != null && "351".equals(billable.getCodeSystemCode())) {
            return "01.01.1300".equals(billable.getCode()) || "01.99.1300".equals(billable.getCode());
        }
        return false;
    }

    public String getMaintenanceDescription() {
        return "Falsch verrechnete COVID Test Zertifikate.";
    }

    private class FixInfo {
        private IPatient patient;
        private LocalDate localDate;
        private List<IEncounter> encounters;

        public FixInfo(IPatient patient, LocalDate localDate, List<IEncounter> encounters) {
            this.patient = patient;
            this.localDate = localDate;
            this.encounters = encounters;
        }

        public String getInsurance() {
            Optional<IContact> insurance = this.encounters.stream().map(e -> e.getCoverage().getCostBearer()).filter(c -> c != null && c.isOrganization()).findFirst();
            return insurance.isPresent() ? insurance.get().getLabel() : "";
        }

        public String getInvoiceNumber() {
            return this.encounters.stream().filter(e -> e.getInvoice() != null).map(e -> e.getInvoice().getNumber()).collect(Collectors.joining("/"));
        }

        public String getInvoiceStatus() {
            return this.encounters.stream().filter(e -> e.getInvoice() != null).map(e -> e.getInvoice().getState().toString()).collect(Collectors.joining("/"));
        }

        public String getInvoiceAmount() {
            return this.encounters.stream().filter(e -> e.getInvoice() != null).map(e -> Double.valueOf(e.getInvoice().getTotalAmount().doubleValue()).toString()).collect(Collectors.joining("/"));
        }

        public List<IInvoice> getInvoicesToFix() {
            return this.encounters.stream().filter(e -> e.getInvoice() != null).filter(e -> e.getCoverage().getBillingSystem().getLaw() == BillingLaw.KVG).map(e -> e.getInvoice()).collect(Collectors.toList());
        }

        public List<IEncounter> getEncountersToFix() {
            return this.encounters.stream().filter(e -> e.getCoverage().getBillingSystem().getLaw() == BillingLaw.KVG).collect(Collectors.toList());
        }
    }

    public class SelectOptionsDialog
    extends TitleAreaDialog {
        private Button setInvoiceStatusBtn;
        private boolean invoiceStatus;
        private Button setEncounterStickerBtn;
        private boolean encounterSticker;
        private Button deleteEncountersWithStickerBtn;
        private boolean deleteEncounterWithSticker;

        public SelectOptionsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle("Optionen f\u00fcr die falsch verrechneten COVID Test Zertifikate.");
            this.setMessage("Es sind verschiedene Optionen f\u00fcr die falsch verrechneten COVID Test Zertifikate verf\u00fcgbar, bitte w\u00e4hlen Sie eine oder mehrere aus.");
            Composite container = (Composite)super.createDialogArea(parent);
            Composite area = new Composite(container, 0);
            area.setLayoutData((Object)new GridData(1808));
            area.setLayout((Layout)new GridLayout(1, false));
            this.setInvoiceStatusBtn = new Button(area, 32);
            this.setInvoiceStatusBtn.setText("Falsch verrechnete Rechnungen Status \u00e4ndern");
            this.setInvoiceStatusBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectOptionsDialog.this.invoiceStatus = SelectOptionsDialog.this.setInvoiceStatusBtn.getSelection();
                }
            });
            Label lblDesc = new Label(area, 0);
            lblDesc.setText("F\u00fcr alle gefundenen Rechnungen mit falsch verrechneten COVID Test Zertifikaten.\nBei Rechnungsstaus Bezahlt -> Totalverlust, bei allen anderen Rechnungsstaus -> Teilverlust");
            this.setEncounterStickerBtn = new Button(area, 32);
            this.setEncounterStickerBtn.setText("Falsch verrechnete Konsultation mit Sticker markieren");
            this.setEncounterStickerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectOptionsDialog.this.encounterSticker = SelectOptionsDialog.this.setEncounterStickerBtn.getSelection();
                }
            });
            lblDesc = new Label(area, 0);
            lblDesc.setText("F\u00fcr alle (auch die ohne Rechnung) gefundenen Konsultationen mit falsch verrechneten COVID Test Zertifikaten.\nWird die Konsultation mit einem Sticker versehen. Damit kann diese unabh\u00e4ngig von der Rechnung gefunden werden.");
            this.deleteEncountersWithStickerBtn = new Button(area, 32);
            this.deleteEncountersWithStickerBtn.setText("Konsultation mit Sticker l\u00f6schen");
            this.deleteEncountersWithStickerBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectOptionsDialog.this.deleteEncounterWithSticker = SelectOptionsDialog.this.deleteEncountersWithStickerBtn.getSelection();
                }
            });
            lblDesc = new Label(area, 0);
            lblDesc.setText("F\u00fcr alle gefundenen Konsultationen die markiert wurden.\nAlle Konsultationen die zuvor mit dem Sticker versehen wurde, werden gel\u00f6scht.");
            return area;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "OK", false);
        }

        public boolean isInvoiceStatus() {
            return this.invoiceStatus;
        }

        public boolean isEncounterSticker() {
            return this.encounterSticker;
        }

        public boolean isDeleteEncounterWithSticker() {
            return this.deleteEncounterWithSticker;
        }
    }
}

