/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.parts;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.covid.cert.service.CertificateInfo;
import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.covid.cert.service.rest.model.RecoveryModel;
import ch.elexis.covid.cert.service.rest.model.RevokeModel;
import ch.elexis.covid.cert.service.rest.model.TestModel;
import ch.elexis.covid.cert.service.rest.model.VaccinationModel;
import ch.elexis.covid.cert.ui.dialogs.RecoveryModelDialog;
import ch.elexis.covid.cert.ui.dialogs.TestModelDialog;
import ch.elexis.covid.cert.ui.dialogs.VaccinationModelDialog;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import ch.rgw.tools.Result;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.slf4j.LoggerFactory;

public class PatientCertificates {
    private Composite composite;
    private Form patientLabel;
    private TableViewer certificatesViewer;
    @Inject
    private CertificatesService service;
    @Inject
    @Service(filterExpression="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore omnivoreStore;
    @Inject
    private ILocalDocumentService localDocumentService;
    @Inject
    private IConfigService configService;
    private IPatient patient;
    private Button btnOtp;

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void updatePatient(@UIEventTopic(value="info/elexis/model/update") IPatient patient) {
        if (this.composite != null && !this.composite.isDisposed() && patient != null && patient.equals(ContextServiceHolder.get().getActivePatient().orElse(null))) {
            this.setPatient(patient);
        }
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void activePatient(IPatient patient) {
        if (this.composite != null && !this.composite.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.setPatient(patient));
        }
    }

    @Inject
    void setMandator(@org.eclipse.e4.core.di.annotations.Optional IMandator mandator) {
        if (this.composite != null && !this.composite.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.updateOtp());
        }
    }

    private void updateOtp() {
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (activeMandator.isPresent()) {
            this.btnOtp.setText("OTP von " + ((IMandator)activeMandator.get()).getLabel());
            String otp = this.configService.getActiveMandator(CertificatesService.CFG_OTP, null);
            if (StringUtils.isNotBlank((CharSequence)otp)) {
                this.btnOtp.setImage(Images.IMG_TICK.getImage());
            } else {
                this.btnOtp.setImage(Images.IMG_ACHTUNG.getImage());
            }
        } else {
            this.btnOtp.setImage(Images.IMG_ACHTUNG.getImage());
            this.btnOtp.setText("kein Mandant");
        }
        this.composite.layout();
    }

    @Inject
    public PatientCertificates() {
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.patientLabel = UiDesk.getToolkit().createForm(composite);
        this.patientLabel.getBody().setLayout((Layout)new GridLayout(1, true));
        this.patientLabel.setText("");
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btnComposite.setLayout((Layout)new GridLayout(3, true));
        this.certificatesViewer = new TableViewer(composite, 512);
        this.certificatesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.certificatesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CertificateInfo) {
                    return ((CertificateInfo)element).getType().getLabel() + ", erstellt " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(((CertificateInfo)element).getTimestamp());
                }
                return super.getText(element);
            }
        });
        this.certificatesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PatientCertificates.this.certificatesViewer.getStructuredSelection() != null && !PatientCertificates.this.certificatesViewer.getStructuredSelection().isEmpty()) {
                    CertificateInfo info = (CertificateInfo)PatientCertificates.this.certificatesViewer.getStructuredSelection().getFirstElement();
                    PatientCertificates.this.openCertDocument(info);
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Zertifikat entfernen";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                RevokeModel model;
                CertificateInfo info = (CertificateInfo)PatientCertificates.this.certificatesViewer.getStructuredSelection().getFirstElement();
                Result<String> result = PatientCertificates.this.service.revokeCertificate(PatientCertificates.this.patient, info, model = new RevokeModel().initDefault(info, PatientCertificates.this.service.getOtp()));
                if (result.isOK()) {
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientCertificates.this.patient);
                } else {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                }
            }

            public boolean isEnabled() {
                return PatientCertificates.this.certificatesViewer.getSelection() != null && !PatientCertificates.this.certificatesViewer.getSelection().isEmpty();
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.certificatesViewer.getTable());
        this.certificatesViewer.getTable().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.update();
                    ++n2;
                }
            }
        });
        this.certificatesViewer.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText(CertificateInfo.Type.VACCINATION.getLabel());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VaccinationModel model = PatientCertificates.this.getVaccinationModel();
                if (model != null) {
                    try {
                        Result<String> result = PatientCertificates.this.service.createVaccinationCertificate(PatientCertificates.this.patient, model);
                        if (result.isOK()) {
                            CertificateInfo newCert = CertificateInfo.of(PatientCertificates.this.patient).stream().filter(c -> c.getUvci().equals(result.get())).findFirst().orElse(null);
                            if (newCert != null) {
                                PatientCertificates.this.openCertDocument(newCert);
                            }
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientCertificates.this.patient);
                            CovidHandlerUtil.showResultInfos(result);
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                        }
                    }
                    catch (Exception ex) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist ein Fehler beim Aufruf der API aufgetreten.");
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting vaccination certificate", (Throwable)ex);
                    }
                }
            }
        });
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText(CertificateInfo.Type.TEST.getLabel());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestModel model = PatientCertificates.this.getTestModel();
                if (model != null) {
                    try {
                        Result<String> result = PatientCertificates.this.service.createTestCertificate(PatientCertificates.this.patient, model);
                        if (result.isOK()) {
                            CertificateInfo newCert = CertificateInfo.of(PatientCertificates.this.patient).stream().filter(c -> c.getUvci().equals(result.get())).findFirst().orElse(null);
                            if (newCert != null) {
                                PatientCertificates.this.openCertDocument(newCert);
                                PatientCertificates.this.executeTestBilling();
                            }
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientCertificates.this.patient);
                            CovidHandlerUtil.showResultInfos(result);
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                        }
                    }
                    catch (Exception ex) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist ein Fehler beim Aufruf der API aufgetreten.");
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting test certificate", (Throwable)ex);
                    }
                }
            }
        });
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText(CertificateInfo.Type.RECOVERY.getLabel());
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecoveryModel model = PatientCertificates.this.getRecoveryModel();
                if (model != null) {
                    try {
                        Result<String> result = PatientCertificates.this.service.createRecoveryCertificate(PatientCertificates.this.patient, model);
                        if (result.isOK()) {
                            CertificateInfo newCert = CertificateInfo.of(PatientCertificates.this.patient).stream().filter(c -> c.getUvci().equals(result.get())).findFirst().orElse(null);
                            if (newCert != null) {
                                PatientCertificates.this.openCertDocument(newCert);
                            }
                            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientCertificates.this.patient);
                            CovidHandlerUtil.showResultInfos(result);
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                        }
                    }
                    catch (Exception ex) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Es ist ein Fehler beim Aufruf der API aufgetreten.");
                        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting recovery certificate", (Throwable)ex);
                    }
                }
            }
        });
        btn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label sep = new Label(composite, 258);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 5;
        sep.setLayoutData((Object)gd);
        this.btnOtp = new Button(composite, 8);
        this.btnOtp.setText("...");
        this.btnOtp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
                if (activeMandator.isPresent()) {
                    String otp = PatientCertificates.this.configService.getActiveMandator(CertificatesService.CFG_OTP, "");
                    InputDialog otpDialog = new InputDialog(Display.getDefault().getActiveShell(), "COVID Zert OTP", "Das one time password (OTP) von " + ((IMandator)activeMandator.get()).getLabel() + " setzen.", otp, null, 2626);
                    otpDialog.setWidthHint(400);
                    if (otpDialog.open() == 0) {
                        String newOtp = otpDialog.getValue();
                        PatientCertificates.this.configService.setActiveMandator(CertificatesService.CFG_OTP, newOtp);
                        ConfigServiceHolder.get().setActiveMandator(CertificatesService.CFG_OTP_TIMESTAMP, LocalDateTime.now().toString());
                    }
                    PatientCertificates.this.updateOtp();
                }
            }
        });
        Hyperlink otplink = new Hyperlink(composite, 0);
        otplink.setText("OTP Seite \u00f6ffnen");
        otplink.setForeground(CoreUiUtil.getColorForString((String)"0000ff"));
        otplink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)PatientCertificates.this.service.getOtpUrl());
            }
        });
        this.composite = composite;
        this.setPatient(ContextServiceHolder.get().getActivePatient().orElse(null));
        this.setMandator(ContextServiceHolder.get().getActiveMandator().orElse(null));
    }

    private void setButtonsEnabled(Composite composite, boolean value) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button) {
                child.setEnabled(value);
            } else if (child instanceof Composite) {
                this.setButtonsEnabled((Composite)child, value);
            }
            ++n2;
        }
    }

    private void setPatient(IPatient patient) {
        this.patient = patient;
        if (patient != null) {
            this.patientLabel.setText("Zertifikate von " + PersonFormatUtil.getFullName((IPerson)patient));
            this.patientLabel.layout();
            this.certificatesViewer.setInput(CertificateInfo.of(patient));
            this.setButtonsEnabled(this.composite, true);
        } else {
            this.patientLabel.setText("");
            this.patientLabel.layout();
            this.certificatesViewer.setInput(Collections.emptyList());
            this.setButtonsEnabled(this.composite, false);
        }
        this.certificatesViewer.refresh();
        Display.getDefault().asyncExec(() -> {
            if (this.composite != null && !this.composite.isDisposed()) {
                this.composite.getParent().layout(true, true);
            }
        });
    }

    private void openCertDocument(CertificateInfo newCert) {
        Optional document = this.omnivoreStore.loadDocument(newCert.getDocumentId());
        if (document.isPresent()) {
            Optional file = this.localDocumentService.getTempFile(document.get());
            if (file.isPresent()) {
                Program.launch((String)((File)file.get()).getAbsolutePath());
            } else {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.Core_Error, (String)Messages.Core_Document_Not_Opened_Locally);
            }
        }
    }

    private VaccinationModel getVaccinationModel() {
        VaccinationModel ret = new VaccinationModel().initDefault(this.patient, this.service.getOtp());
        VaccinationModelDialog dialog = new VaccinationModelDialog(ret, Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            return ret;
        }
        return null;
    }

    private TestModel getTestModel() {
        TestModel ret = new TestModel().initDefault(this.patient, this.service.getOtp());
        TestModelDialog dialog = new TestModelDialog(ret, Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            return ret;
        }
        return null;
    }

    private RecoveryModel getRecoveryModel() {
        RecoveryModel ret = new RecoveryModel().initDefault(this.patient, this.service.getOtp());
        RecoveryModelDialog dialog = new RecoveryModelDialog(ret, Display.getDefault().getActiveShell());
        if (dialog.open() == 0) {
            return ret;
        }
        return null;
    }

    private void executeTestBilling() {
        this.executeCommand("ch.elexis.covid.cert.command.covidtest.bill");
    }

    private Object executeCommand(String commandId) {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(commandId);
            ExecutionEvent ee = new ExecutionEvent(cmd, Collections.EMPTY_MAP, null, null);
            return cmd.executeWithChecks(ee);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PatientCertificates.class).error("cannot execute command with id: " + commandId, (Throwable)e);
            return null;
        }
    }
}

