/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.service.rest.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.covid.cert.service.rest.model.Name;
import ch.elexis.covid.cert.service.rest.model.RecoveryInfo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class RecoveryModel {
    private Name name;
    private String dateOfBirth;
    private String language;
    private String otp;
    private String appCode;
    private RecoveryInfo[] recoveryInfo;

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getOtp() {
        return this.otp;
    }

    public void setOtp(String otp) {
        this.otp = otp;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public RecoveryInfo[] getRecoveryInfo() {
        return this.recoveryInfo;
    }

    public void setRecoveryInfo(RecoveryInfo[] testInfo) {
        this.recoveryInfo = testInfo;
    }

    public RecoveryModel initDefault(IPatient patient, String otp) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        this.setName(Name.of(patient));
        this.setDateOfBirth(formatter.format(patient.getDateOfBirth()));
        this.setLanguage(Locale.getDefault().getLanguage().toLowerCase());
        this.setOtp(otp);
        RecoveryInfo recoveryinfo = new RecoveryInfo();
        recoveryinfo.setDateOfFirstPositiveTestResult(formatter.format(LocalDate.now()));
        recoveryinfo.setCountryOfTest("CH");
        this.setRecoveryInfo(new RecoveryInfo[]{recoveryinfo});
        return this;
    }
}

