/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.parts;

import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.covid.cert.service.CertificateInfo;
import ch.elexis.covid.cert.service.CertificatesService;
import ch.elexis.covid.cert.service.rest.model.RevokeModel;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import ch.rgw.tools.Result;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.slf4j.LoggerFactory;

public class PatientTests {
    private Composite composite;
    private Form patientLabel;
    private TableViewer testsViewer;
    @Inject
    private CertificatesService service;
    @Inject
    @Service(filterExpression="(storeid=ch.elexis.data.store.omnivore)")
    private IDocumentStore omnivoreStore;
    @Inject
    private ILocalDocumentService localDocumentService;
    @Inject
    private IConfigService configService;
    private IPatient patient;
    private Button btnOtp;

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void updatePatient(@UIEventTopic(value="info/elexis/model/update") IPatient patient) {
        if (this.composite != null && !this.composite.isDisposed() && patient != null && patient.equals(ContextServiceHolder.get().getActivePatient().orElse(null))) {
            this.setPatient(patient);
        }
    }

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void activePatient(IPatient patient) {
        if (this.composite != null && !this.composite.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.setPatient(patient));
        }
    }

    @Inject
    void setMandator(@org.eclipse.e4.core.di.annotations.Optional IMandator mandator) {
        if (this.composite != null && !this.composite.isDisposed()) {
            Display.getDefault().asyncExec(() -> this.updateOtp());
        }
    }

    private void updateOtp() {
        Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
        if (activeMandator.isPresent()) {
            this.btnOtp.setText("OTP von " + ((IMandator)activeMandator.get()).getLabel());
            String otp = this.configService.getActiveMandator(CertificatesService.CFG_OTP, null);
            if (StringUtils.isNotBlank((CharSequence)otp)) {
                this.btnOtp.setImage(Images.IMG_TICK.getImage());
            } else {
                this.btnOtp.setImage(Images.IMG_ACHTUNG.getImage());
            }
        } else {
            this.btnOtp.setImage(Images.IMG_ACHTUNG.getImage());
            this.btnOtp.setText("kein Mandant");
        }
        this.composite.layout();
    }

    @Inject
    public PatientTests() {
    }

    @PostConstruct
    public void postConstruct(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btnComposite.setLayout((Layout)new GridLayout(2, true));
        this.patientLabel = UiDesk.getToolkit().createForm(composite);
        this.patientLabel.getBody().setLayout((Layout)new GridLayout(1, true));
        this.patientLabel.setText("");
        this.testsViewer = new TableViewer(composite, 512);
        this.testsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.testsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof CertificateInfo) {
                    return ((CertificateInfo)element).getType().getLabel() + ", erstellt " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(((CertificateInfo)element).getTimestamp());
                }
                if (element instanceof IDocumentLetter) {
                    return "Bescheinigung " + ((IDocumentLetter)element).getTitle() + ", erstellt " + DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm").format(LocalDateTime.ofInstant(((IDocumentLetter)element).getCreated().toInstant(), ZoneId.systemDefault()));
                }
                return super.getText(element);
            }
        });
        this.testsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object l, Object r) {
                LocalDateTime lDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
                LocalDateTime rDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
                if (l instanceof CertificateInfo) {
                    lDateTime = ((CertificateInfo)l).getTimestamp();
                } else if (l instanceof IDocumentLetter) {
                    lDateTime = LocalDateTime.ofInstant(((IDocumentLetter)l).getCreated().toInstant(), ZoneId.systemDefault());
                }
                if (r instanceof CertificateInfo) {
                    rDateTime = ((CertificateInfo)r).getTimestamp();
                } else if (r instanceof IDocumentLetter) {
                    rDateTime = LocalDateTime.ofInstant(((IDocumentLetter)r).getCreated().toInstant(), ZoneId.systemDefault());
                }
                return rDateTime.compareTo(lDateTime);
            }
        });
        this.testsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PatientTests.this.testsViewer.getStructuredSelection() != null && !PatientTests.this.testsViewer.getStructuredSelection().isEmpty()) {
                    if (PatientTests.this.testsViewer.getStructuredSelection().getFirstElement() instanceof CertificateInfo) {
                        CertificateInfo info = (CertificateInfo)PatientTests.this.testsViewer.getStructuredSelection().getFirstElement();
                        CovidHandlerUtil.openCertDocument(info, PatientTests.this.omnivoreStore, PatientTests.this.localDocumentService);
                    } else if (PatientTests.this.testsViewer.getStructuredSelection().getFirstElement() instanceof IDocumentLetter) {
                        CovidHandlerUtil.openLetter((IDocumentLetter)PatientTests.this.testsViewer.getStructuredSelection().getFirstElement(), PatientTests.this.localDocumentService);
                    }
                }
            }
        });
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new Action(){

            public String getText() {
                return "Zertifikat entfernen";
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_DELETE.getImageDescriptor();
            }

            public void run() {
                if (PatientTests.this.testsViewer.getStructuredSelection().getFirstElement() instanceof CertificateInfo) {
                    RevokeModel model;
                    CertificateInfo info = (CertificateInfo)PatientTests.this.testsViewer.getStructuredSelection().getFirstElement();
                    Result<String> result = PatientTests.this.service.revokeCertificate(PatientTests.this.patient, info, model = new RevokeModel().initDefault(info, PatientTests.this.service.getOtp()));
                    if (result.isOK()) {
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientTests.this.patient);
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Es ist folgender Fehler aufgetreten.\n\n" + result.getMessages().stream().map(m -> m.getText()).collect(Collectors.joining(", "))));
                    }
                } else if (PatientTests.this.testsViewer.getStructuredSelection().getFirstElement() instanceof IDocumentLetter) {
                    IDocumentLetter letter = (IDocumentLetter)PatientTests.this.testsViewer.getStructuredSelection().getFirstElement();
                    CoreModelServiceHolder.get().delete((Deleteable)letter);
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)PatientTests.this.patient);
                }
            }

            public boolean isEnabled() {
                return PatientTests.this.testsViewer.getSelection() != null && !PatientTests.this.testsViewer.getSelection().isEmpty();
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.testsViewer.getTable());
        this.testsViewer.getTable().setMenu(contextMenu);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items;
                IContributionItem[] iContributionItemArray = items = manager.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    IContributionItem iContributionItem = iContributionItemArray[n2];
                    iContributionItem.update();
                    ++n2;
                }
            }
        });
        this.testsViewer.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("Antigen Kasse");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.antigen.kk");
            }
        });
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("Antigen Selbstzahler");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.antigen.sz");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("PCR Kasse");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.pcr.kk");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("PCR Selbstzahler");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.pcr.sz");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("Bescheinigung Kasse");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.letter.kk");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        btn = new Button(btnComposite, 8);
        btn.setImage(Images.IMG_NEW.getImage());
        btn.setText("Bescheinigung Selbstzahler");
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatientTests.this.executeCommand("ch.elexis.covid.cert.command.covidtest.letter.sz");
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        gd.heightHint = 75;
        btn.setLayoutData((Object)gd);
        Label sep = new Label(composite, 258);
        sep.setLayoutData((Object)gd);
        this.btnOtp = new Button(composite, 8);
        this.btnOtp.setText("...");
        this.btnOtp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Optional activeMandator = ContextServiceHolder.get().getActiveMandator();
                if (activeMandator.isPresent()) {
                    String otp = PatientTests.this.configService.getActiveMandator(CertificatesService.CFG_OTP, "");
                    InputDialog otpDialog = new InputDialog(Display.getDefault().getActiveShell(), "COVID Zert OTP", "Das one time password (OTP) von " + ((IMandator)activeMandator.get()).getLabel() + " setzen.", otp, null, 2626);
                    otpDialog.setWidthHint(400);
                    if (otpDialog.open() == 0) {
                        String newOtp = otpDialog.getValue();
                        PatientTests.this.configService.setActiveMandator(CertificatesService.CFG_OTP, newOtp);
                        ConfigServiceHolder.get().setActiveMandator(CertificatesService.CFG_OTP_TIMESTAMP, LocalDateTime.now().toString());
                    }
                    PatientTests.this.updateOtp();
                }
            }
        });
        Hyperlink otplink = new Hyperlink(composite, 0);
        otplink.setText("OTP Seite \u00f6ffnen");
        otplink.setForeground(CoreUiUtil.getColorForString((String)"0000ff"));
        otplink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)PatientTests.this.service.getOtpUrl());
            }
        });
        this.composite = composite;
        this.setPatient(ContextServiceHolder.get().getActivePatient().orElse(null));
        this.setMandator(ContextServiceHolder.get().getActiveMandator().orElse(null));
    }

    private void setButtonsEnabled(Composite composite, boolean value) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Button) {
                child.setEnabled(value);
            } else if (child instanceof Composite) {
                this.setButtonsEnabled((Composite)child, value);
            }
            ++n2;
        }
    }

    private void setPatient(IPatient patient) {
        this.patient = patient;
        if (patient != null) {
            this.patientLabel.setText("Tests von " + PersonFormatUtil.getFullName((IPerson)patient));
            this.patientLabel.layout();
            List certificates = CertificateInfo.of(patient).stream().filter(ci -> ci.getType() == CertificateInfo.Type.TEST).collect(Collectors.toList());
            List<IDocumentLetter> letters = CovidHandlerUtil.getLettersAt(patient, null, "COVID Antigen positiv", "COVID Antigen negativ");
            ArrayList<Object> input = new ArrayList<Object>();
            input.addAll(certificates);
            input.addAll(letters);
            this.testsViewer.setInput(input);
            this.setButtonsEnabled(this.composite, true);
        } else {
            this.patientLabel.setText("");
            this.patientLabel.layout();
            this.testsViewer.setInput(Collections.emptyList());
            this.setButtonsEnabled(this.composite, false);
        }
        this.testsViewer.refresh();
        if (this.testsViewer.getTable().computeSize((int)-1, (int)-1).y > 250) {
            ((GridData)this.testsViewer.getTable().getLayoutData()).heightHint = 250;
        }
        Display.getDefault().asyncExec(() -> {
            if (this.composite != null && !this.composite.isDisposed()) {
                this.composite.getParent().layout(true, true);
            }
        });
    }

    private Object executeCommand(String commandId) {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(commandId);
            ExecutionEvent ee = new ExecutionEvent(cmd, Collections.EMPTY_MAP, null, null);
            return cmd.executeWithChecks(ee);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PatientTests.class).error("cannot execute command with id: " + commandId, (Throwable)e);
            return null;
        }
    }
}

