/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.covid.cert.ui.handler;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.ICodeElementBlock;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IEncounterBuilder;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.covid.cert.ui.handler.CovidHandlerUtil;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CovidAttestSz {
    @Inject
    private ILocalDocumentService localDocumentService;
    @Inject
    private IContextService contextService;
    private TextContainer textContainer;

    @Execute
    public void execute() {
        if (this.textContainer == null) {
            this.textContainer = new TextContainer();
        }
        Optional activePatient = this.contextService.getActivePatient();
        activePatient.ifPresent(patient -> {
            Map<String, ICodeElementBlock> blocks = CovidHandlerUtil.getConfiguredBlocks();
            if (!blocks.isEmpty()) {
                Optional<ICoverage> szCoverage = CoverageServiceHolder.get().getCoverageWithLaw(patient, CovidHandlerUtil.SZ_LAWS);
                List<IDocumentLetter> existingLetters = CovidHandlerUtil.getLettersAt(patient, LocalDate.now(), "COVID Antigen positiv", "COVID Antigen negativ");
                if (existingLetters.isEmpty()) {
                    if (szCoverage.isEmpty()) {
                        szCoverage = CovidHandlerUtil.createSzCoverage(patient);
                    }
                    if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Test Resultat", (String)"Wurde der Patient positiv getestet?")) {
                        Optional<IEncounter> antigenEncounter;
                        if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"PCR Test", (String)"Wurde ein PCR Test gemacht?")) {
                            antigenEncounter = this.billAntigen(szCoverage.get());
                            if (antigenEncounter.isPresent()) {
                                Optional<IEncounter> pcrEncounter = this.billPcr(szCoverage.get());
                                pcrEncounter.ifPresent(encounter -> {
                                    if (CovidHandlerUtil.isBilled((IEncounter)antigenEncounter.get(), "01.99.1100")) {
                                        CovidHandlerUtil.removeBilled(encounter, "01.99.1100");
                                    }
                                });
                            }
                        } else {
                            antigenEncounter = this.billAntigen(szCoverage.get());
                        }
                        Konsultation letterKons = (Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)antigenEncounter.get()));
                        Brief letterPositiv = this.textContainer.createFromTemplateName(letterKons, "COVID Antigen positiv", "Allg.", null, null);
                        NoPoUtil.loadAsIdentifiable((PersistentObject)letterPositiv, IDocumentLetter.class).ifPresent(l -> CovidHandlerUtil.openLetter(l, this.localDocumentService));
                    } else {
                        Optional<IEncounter> antigenEncounter = this.billAntigen(szCoverage.get());
                        Konsultation letterKons = (Konsultation)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)antigenEncounter.get()));
                        Brief letterNegativ = this.textContainer.createFromTemplateName(letterKons, "COVID Antigen negativ", "Allg.", null, null);
                        NoPoUtil.loadAsIdentifiable((PersistentObject)letterNegativ, IDocumentLetter.class).ifPresent(l -> CovidHandlerUtil.openLetter(l, this.localDocumentService));
                    }
                    ContextServiceHolder.get().postEvent("info/elexis/model/update", patient);
                } else if (MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Vorhandene Test Bescheinigung", (String)"Es wurde heute bereits ein Test Bescheinigung ausgestellt.\nM\u00f6chten Sie diese anzeigen?")) {
                    CovidHandlerUtil.openLetter(existingLetters.get(0), this.localDocumentService);
                }
            }
        });
    }

    private Optional<IEncounter> billAntigen(ICoverage coverage) {
        ICodeElementBlock szBlock = CovidHandlerUtil.getConfiguredBlocks().get("ch.elexis.covid.cert.ui/sz_blockid");
        if (szBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
            CovidHandlerUtil.addBlockToEncounter(szBlock, encounter);
            this.contextService.getRootContext().setTyped((Object)encounter);
            return Optional.of(encounter);
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Selbstzahler PCR Block konfiguriert.");
        return Optional.empty();
    }

    private Optional<IEncounter> billPcr(ICoverage coverage) {
        ICodeElementBlock szBlock = CovidHandlerUtil.getConfiguredBlocks().get("ch.elexis.covid.cert.ui/sz_pcr_blockid");
        if (szBlock != null) {
            IEncounter encounter = (IEncounter)new IEncounterBuilder(CoreModelServiceHolder.get(), coverage, (IMandator)this.contextService.getActiveMandator().get()).buildAndSave();
            CovidHandlerUtil.addBlockToEncounter(szBlock, encounter);
            this.contextService.getRootContext().setTyped((Object)encounter);
            return Optional.of(encounter);
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Selbstzahler PCR Block konfiguriert.");
        return Optional.empty();
    }
}

