/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.sysmex.ui;

import ch.elexis.connect.sysmex.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String SYSMEX_BASE = "connectors/sysmex/";
    public static final String PORT = "connectors/sysmex/port";
    public static final String TIMEOUT = "connectors/sysmex/timeout";
    public static final String PARAMS = "connectors/sysmex/params";
    public static final String LOG = "connectors/sysmex/log";
    public static final String BACKGROUND = "connectors/sysmex/background";
    public static final String MODEL = "connectors/sysmex/model";
    public static final String RDW_TYP = "connectors/sysmex/rdwTyp";
    public static final String MODEL_KX21 = "KX-21";
    public static final String MODEL_KX21N = "KX-21N";
    public static final String MODEL_POCH = "pocH-100i";
    public static final String MODEL_UC1000 = "UC-1000";
    public static final String RDW_SD = "SD";
    public static final String RDW_CV = "CV";
    Label lblRdw;
    Combo ports;
    Text speed;
    Text data;
    Text stop;
    Text timeout;
    Text logFile;
    Button parity;
    Button log;
    Button background;
    Combo models;
    Combo rdw_types;

    public Preferences() {
        super(Messages.SysmexAction_ButtonName);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        Composite retComp = new Composite(parent, 0);
        retComp.setLayout((Layout)new GridLayout(1, false));
        retComp.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite mainComp = new Composite(retComp, 0);
        mainComp.setLayout((Layout)new GridLayout(4, false));
        mainComp.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        new Label(mainComp, 0).setText(Messages.Preferences_Modell);
        this.models = new Combo(mainComp, 4);
        this.models.setItems(new String[]{MODEL_KX21, MODEL_KX21N, MODEL_POCH, MODEL_UC1000});
        this.models.setText(CoreHub.localCfg.get(MODEL, MODEL_KX21));
        this.lblRdw = new Label(mainComp, 0);
        this.lblRdw.setText(Messages.Preferences_RDW);
        this.rdw_types = new Combo(mainComp, 4);
        this.rdw_types.setItems(new String[]{RDW_SD, RDW_CV});
        this.rdw_types.setText(CoreHub.localCfg.get(RDW_TYP, RDW_SD));
        new Label(mainComp, 0).setText(Messages.Preferences_Backgroundprocess);
        this.background = new Button(mainComp, 32);
        this.background.setSelection(CoreHub.localCfg.get(BACKGROUND, "n").equalsIgnoreCase("y"));
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.background);
        new Label(mainComp, 0).setText(Messages.Preferences_Log);
        this.log = new Button(mainComp, 32);
        this.log.setSelection(CoreHub.localCfg.get(LOG, "n").equalsIgnoreCase("y"));
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.log);
        Group connectGroup = new Group(retComp, 0);
        connectGroup.setText(Messages.Preferences_Verbindung);
        connectGroup.setLayout((Layout)new GridLayout(2, false));
        connectGroup.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Label lblPorts = new Label((Composite)connectGroup, 0);
        lblPorts.setText(Messages.Preferences_Port);
        lblPorts.setLayoutData((Object)new GridData(0));
        this.ports = new Combo((Composite)connectGroup, 4);
        this.ports.setItems(Connection.getComPorts());
        this.ports.setText(CoreHub.localCfg.get(PORT, Messages.SysmexAction_DefaultPort));
        String[] param = CoreHub.localCfg.get(PARAMS, "9600,8,n,1").split(",");
        Label lblSpeed = new Label((Composite)connectGroup, 0);
        lblSpeed.setText(Messages.Preferences_Baud);
        lblSpeed.setLayoutData((Object)new GridData(0));
        this.speed = new Text((Composite)connectGroup, 2048);
        this.speed.setLayoutData((Object)new GridData(768));
        this.speed.setText(param[0]);
        Label lblData = new Label((Composite)connectGroup, 0);
        lblData.setText(Messages.Preferences_Databits);
        lblData.setLayoutData((Object)new GridData(0));
        this.data = new Text((Composite)connectGroup, 2048);
        this.data.setText(param[1]);
        Label lblParity = new Label((Composite)connectGroup, 0);
        lblParity.setText(Messages.Preferences_Parity);
        lblParity.setLayoutData((Object)new GridData(0));
        this.parity = new Button((Composite)connectGroup, 32);
        this.parity.setLayoutData((Object)new GridData(768));
        this.parity.setSelection(!param[2].equalsIgnoreCase("n"));
        Label lblStop = new Label((Composite)connectGroup, 0);
        lblStop.setText(Messages.Preferences_Stopbits);
        lblStop.setLayoutData((Object)new GridData(0));
        this.stop = new Text((Composite)connectGroup, 2048);
        this.stop.setText(param[3]);
        Label lblTimeout = new Label((Composite)connectGroup, 0);
        lblTimeout.setText(Messages.Preferences_Timeout);
        lblTimeout.setLayoutData((Object)new GridData(0));
        String timeoutStr = CoreHub.localCfg.get(TIMEOUT, Messages.SysmexAction_DefaultTimeout);
        this.timeout = new Text((Composite)connectGroup, 2048);
        this.timeout.setText(timeoutStr);
        this.models.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Preferences.this.modelChanged();
            }
        });
        this.modelChanged();
        return retComp;
    }

    private void modelChanged() {
        boolean visible = this.models.getText().equals(MODEL_KX21);
        this.lblRdw.setVisible(visible);
        this.rdw_types.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",").append(this.data.getText()).append(",").append(this.parity.getSelection() ? "y" : "n").append(",").append(this.stop.getText());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.ports.getText());
        CoreHub.localCfg.set(TIMEOUT, this.timeout.getText());
        CoreHub.localCfg.set(LOG, this.log.getSelection() ? "y" : "n");
        CoreHub.localCfg.set(BACKGROUND, this.background.getSelection() ? "y" : "n");
        CoreHub.localCfg.set(MODEL, this.models.getText());
        CoreHub.localCfg.set(RDW_TYP, this.rdw_types.getText());
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

