/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.reflotron;

import ch.elexis.connect.reflotron.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.importer.div.rs232.Connection;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Preferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String REFLOTRON_BASE = "connectors/reflotron/";
    public static final String PORT = "connectors/reflotron/port";
    public static final String TIMEOUT = "connectors/reflotron/timeout";
    public static final String PARAMS = "connectors/reflotron/params";
    public static final String LOG = "connectors/reflotron/log";
    public static final String BACKGROUND = "connectors/reflotron/background";
    public static final String ENCODING = "connectors/reflotron/encoding";
    Combo ports;
    Combo encoding;
    Text speed;
    Text data;
    Text stop;
    Text timeout;
    Text logFile;
    Button parity;
    Button log;
    Button background;

    public Preferences() {
        super(Messages.ReflotronSprintAction_ButtonName);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.localCfg));
    }

    protected Control createContents(Composite parent) {
        String[] param = CoreHub.localCfg.get(PARAMS, "9600,8,n,1").split(",");
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Label lblPorts = new Label(ret, 0);
        lblPorts.setText(Messages.Preferences_Port);
        lblPorts.setLayoutData((Object)new GridData(0));
        this.ports = new Combo(ret, 4);
        this.ports.setItems(Connection.getComPorts());
        this.ports.setText(CoreHub.localCfg.get(PORT, Messages.ReflotronSprintAction_DefaultPort));
        Label lblEncoding = new Label(ret, 0);
        lblEncoding.setText("Daten-Encoding");
        lblEncoding.setLayoutData((Object)new GridData(0));
        this.encoding = new Combo(ret, 4);
        Set<String> availableCharsets = Charset.availableCharsets().keySet();
        String[] charsetArray = new String[availableCharsets.size()];
        int i = 0;
        Iterator<String> iterator = availableCharsets.iterator();
        while (iterator.hasNext()) {
            String charset;
            charsetArray[i] = charset = iterator.next();
            ++i;
        }
        this.encoding.setItems(charsetArray);
        this.encoding.setText(CoreHub.localCfg.get(ENCODING, Charset.defaultCharset().displayName()));
        Label lblSpeed = new Label(ret, 0);
        lblSpeed.setText(Messages.Preferences_Baud);
        lblSpeed.setLayoutData((Object)new GridData(0));
        this.speed = new Text(ret, 2048);
        this.speed.setLayoutData((Object)new GridData(768));
        this.speed.setText(param[0]);
        Label lblData = new Label(ret, 0);
        lblData.setText(Messages.Preferences_Databits);
        lblData.setLayoutData((Object)new GridData(0));
        this.data = new Text(ret, 2048);
        this.data.setText(param[1]);
        Label lblParity = new Label(ret, 0);
        lblParity.setText(Messages.Preferences_Parity);
        lblParity.setLayoutData((Object)new GridData(0));
        this.parity = new Button(ret, 32);
        this.parity.setLayoutData((Object)new GridData(768));
        this.parity.setSelection(!param[2].equalsIgnoreCase("n"));
        Label lblStop = new Label(ret, 0);
        lblStop.setText(Messages.Preferences_Stopbits);
        lblStop.setLayoutData((Object)new GridData(0));
        this.stop = new Text(ret, 2048);
        this.stop.setText(param[3]);
        Label lblTimeout = new Label(ret, 0);
        lblTimeout.setText(Messages.Preferences_Timeout);
        lblTimeout.setLayoutData((Object)new GridData(0));
        String timeoutStr = CoreHub.localCfg.get(TIMEOUT, Messages.ReflotronSprintAction_DefaultTimeout);
        this.timeout = new Text(ret, 2048);
        this.timeout.setText(timeoutStr);
        new Label(ret, 0).setText(Messages.Preferences_Backgroundprocess);
        this.background = new Button(ret, 32);
        this.background.setSelection(CoreHub.localCfg.get(BACKGROUND, "n").equalsIgnoreCase("y"));
        new Label(ret, 0).setText(Messages.Preferences_Log);
        this.log = new Button(ret, 32);
        this.log.setSelection(CoreHub.localCfg.get(LOG, "n").equalsIgnoreCase("y"));
        return ret;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.speed.getText()).append(",").append(this.data.getText()).append(",").append(this.parity.getSelection() ? "y" : "n").append(",").append(this.stop.getText());
        CoreHub.localCfg.set(PARAMS, sb.toString());
        CoreHub.localCfg.set(PORT, this.ports.getText());
        CoreHub.localCfg.set(ENCODING, this.encoding.getText());
        CoreHub.localCfg.set(TIMEOUT, this.timeout.getText());
        CoreHub.localCfg.set(LOG, this.log.getSelection() ? "y" : "n");
        CoreHub.localCfg.set(BACKGROUND, this.background.getSelection() ? "y" : "n");
        CoreHub.localCfg.flush();
        return super.performOk();
    }
}

