/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.fuji.drichem3500;

import ch.elexis.connect.fuji.drichem3500.ConnectAction;
import ch.elexis.core.events.MessageEvent;
import ch.elexis.core.importer.div.importers.ImportHandler;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.core.ui.importer.div.importers.DefaultLabImportUiHandler;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FujiMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(FujiMessageHandler.class);
    private ConnectAction action;

    public FujiMessageHandler(ConnectAction action) {
        this.action = action;
    }

    public boolean handle(String message) {
        logger.debug("Got message: " + message);
        if (this.isValidMessage(message)) {
            String prolog = message.substring(0, 51);
            String data = message.substring(51);
            String testmode = message.substring(1, 8);
            String date = message.substring(8, 18);
            String time = message.substring(18, 23);
            String sequence = message.substring(23, 36).trim();
            String sampleID = message.substring(36, 49).trim();
            String position = message.substring(49, 50);
            String patid = new Query(Patient.class).findSingle("PatientNr", "=", sampleID);
            Patient pat = Patient.load((String)patid);
            if (!pat.exists() && !(pat = Patient.load((String)(patid = new Query(Patient.class).findSingle("PatientNr", "=", sequence)))).exists()) {
                logger.warn("Eingabefehler, kein Patient mit Nummer " + sequence + " vorhanden!");
                MessageEvent.fireError((String)"Eingabefehler", (String)("Es ist kein Patient mit der Nummer " + sequence + " vorhanden."));
                return false;
            }
            logger.debug("Resultatzuordnung zu Patient: " + pat.getName() + " " + pat.getVorname());
            int dp = 51;
            TimeTool testDate = new TimeTool(date);
            testDate.set(time);
            ArrayList<TransientLabResult> results = new ArrayList<TransientLabResult>();
            while (message.length() > dp + 35) {
                String testname = message.substring(dp, dp + 7).trim();
                String sign = message.substring(dp + 7, dp + 8);
                String result = message.substring(dp + 8, dp + 17).trim();
                String unit = message.substring(dp + 17, dp + 23).trim();
                String dilution = message.substring(dp + 23, dp + 25);
                String warning = message.substring(dp + 25, dp + 35).trim();
                ILabItem li = LabImportUtilHolder.get().getLabItem(testname, this.action.getMyLab());
                if (li == null) {
                    li = LabImportUtilHolder.get().createLabItem(testname, testname, this.action.getMyLab(), "0", "0", unit, LabItemTyp.NUMERIC, "Dri-Chem", "20");
                    li.setUnit(unit);
                    logger.warn("Kein passendes Laboritem gefunden. Lege neues Laboritem mit Name " + testname + " an.");
                }
                results.add(new TransientLabResult.Builder(pat.toIPatient(), this.action.getMyLab(), li, result).date(testDate).observationTime(testDate).comment(warning).unit(unit).build(LabImportUtilHolder.get()));
                logger.debug("Laborresultat hinzugefuegt: " + result);
                dp += 36;
            }
            LabImportUtilHolder.get().importLabResults(results, (ImportHandler)new DefaultLabImportUiHandler());
            return true;
        }
        logger.debug("Received not valid fuji message of size [" + message.length() + "]");
        return false;
    }

    private boolean isValidMessage(String message) {
        return message != null && message.length() >= 52;
    }
}

