/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.fuji.drichem3500;

import ch.elexis.connect.fuji.drichem3500.EthernetListener;
import ch.elexis.connect.fuji.drichem3500.SerialListener;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectAction
extends Action {
    public static final String CONFIGURATION_SERIAL = "Seriell";
    public static final String CONFIGURATION_ETHERNET = "Ethernet";
    private SerialListener serialConnection;
    private EthernetListener ethernetConnection;
    private ILaboratory myLab;
    private static Logger logger = LoggerFactory.getLogger(ConnectAction.class);

    public ConnectAction() {
        super("Fuji DriChem", 2);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.connect.fuji.drichem3500", (String)"icons/fuji.png"));
        this.setToolTipText("Mit Fuji Dri-Chem 3500 verbinden");
        this.myLab = LabImportUtilHolder.get().getOrCreateLabor("Dri-Chem");
    }

    public void run() {
        if (this.isChecked()) {
            if (CoreHub.localCfg.get("connectors/fuji-drichem-3500/connection", CONFIGURATION_SERIAL).equals(CONFIGURATION_ETHERNET)) {
                if (this.ethernetConnection == null) {
                    this.ethernetConnection = new EthernetListener(Integer.parseInt(CoreHub.localCfg.get("connectors/fuji-drichem-3500/ethernetport", "5000")), this);
                }
                this.ethernetConnection.startThread();
            } else {
                if (this.serialConnection == null) {
                    this.serialConnection = new SerialListener(this);
                }
                if (this.serialConnection.connect()) {
                    logger.debug("Started serial connection for Fuji Drichem");
                } else {
                    this.setChecked(false);
                    SWTHelper.showError((String)"Fehler", (String)"Konnte seriellen Port nicht \u00f6ffnen.\nBitte Einstellungen zu Fuji Drichem \u00fcberpr\u00fcfen!");
                    logger.warn("Could not open serial connection");
                }
            }
        } else {
            if (this.ethernetConnection != null) {
                this.ethernetConnection.stopThread();
            }
            if (this.serialConnection != null) {
                this.serialConnection.disconnect();
                this.serialConnection = null;
            }
            this.setChecked(false);
        }
    }

    public ILaboratory getMyLab() {
        return this.myLab;
    }
}

