/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.connect.afinion.packages;

import ch.elexis.connect.afinion.Messages;
import ch.elexis.connect.afinion.packages.PackageException;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.importer.div.importers.TransientLabResult;
import ch.elexis.core.importer.div.service.holder.LabImportUtilHolder;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILaboratory;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.ResourceBundle;

public class Value {
    private static final String BUNDLE_NAME = "ch.elexis.connect.afinion.packages.valuetexts";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("ch.elexis.connect.afinion.packages.valuetexts");
    String _shortName;
    String _longName;
    String _unit;
    ILabItem _labItem;
    String _refMann;
    String _refFrau;
    ILaboratory _labor;

    private static String getString(String paramName, String key) {
        return RESOURCE_BUNDLE.getString(paramName + "." + key);
    }

    public static Value getValue(String paramName, String unit) throws PackageException {
        return new Value(paramName, unit);
    }

    public String get_shortName() {
        return this._shortName;
    }

    public String get_longName() {
        return this._longName;
    }

    Value(String paramName, String unit) throws PackageException {
        this._shortName = Value.getString(paramName, "kuerzel");
        this._longName = Value.getString(paramName, "text");
        this._unit = Value.getString(paramName, "unit");
        if (CoreHub.localCfg != null && CoreHub.localCfg.get("connectors/afinion/applysentunits", "n").equalsIgnoreCase("y")) {
            this._unit = unit;
        }
        this._refMann = Value.getString(paramName, "refM");
        this._refFrau = Value.getString(paramName, "refF");
    }

    private void initialize() {
        this._labor = LabImportUtilHolder.get().getOrCreateLabor(Messages.Afinion_Value_LabKuerzel);
        this._labItem = LabImportUtilHolder.get().getLabItem(this._shortName, this._labor);
        if (this._labItem == null) {
            this._labItem = LabImportUtilHolder.get().createLabItem(this._shortName, this._longName, this._labor, this._refMann, this._refFrau, this._unit, LabItemTyp.NUMERIC, Messages.Afinion_Value_LabName, "50");
        }
    }

    public TransientLabResult fetchValue(Patient patient, String value, String flags, TimeTool date) {
        if (this._labItem == null) {
            this.initialize();
        }
        IPatient iPatient = CoreModelServiceHolder.get().load(patient.getId(), IPatient.class).orElse(null);
        if (flags == null || flags.isEmpty()) {
            return new TransientLabResult.Builder(iPatient, this._labor, this._labItem, value).date(date).build(LabImportUtilHolder.get());
        }
        String comment = "";
        int resultFlags = 0;
        if (flags.equals("1")) {
            resultFlags |= 1;
        }
        if (flags.equals("2")) {
            resultFlags |= 1;
        }
        if (flags.equals("*") || flags.equals("E")) {
            comment = Messages.Afinion_Value_Error;
        }
        return new TransientLabResult.Builder(iPatient, this._labor, this._labItem, value).date(date).comment(comment).flags(Integer.valueOf(resultFlags)).build(LabImportUtilHolder.get());
    }
}

