/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.DateTool;
import ch.elexis.buchhaltung.util.PatientIdFormatter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.AccountTransaction;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractTimeSeries;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.LoggerFactory;

public class FakturaJournal
extends AbstractTimeSeries {
    private static final String NAME = Messages.FakturaJournal_FakturaJournal;
    private boolean bOnlyActiveMandator;

    public FakturaJournal() {
        super(NAME);
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX, index=1)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant", index=1)
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int total = 10000000;
        Query qbe = new Query(AccountTransaction.class);
        TimeTool ttStart = new TimeTool(this.getStartDate().getTimeInMillis());
        TimeTool ttEnd = new TimeTool(this.getEndDate().getTimeInMillis());
        qbe.add("Datum", ">=", ttStart.toString(9));
        qbe.add("Datum", "<=", ttEnd.toString(9));
        monitor.beginTask(NAME, total);
        monitor.subTask(Messages.FakturaJournal_DatabaseQuery);
        List transactions = qbe.execute();
        int sum = transactions.size();
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        if (sum == 0) {
            monitor.done();
            this.dataSet.setContent(result);
            return Status.OK_STATUS;
        }
        int step = total / sum;
        monitor.worked(20 * step);
        PatientIdFormatter pif = new PatientIdFormatter(8);
        String actMnId = ContextServiceHolder.getActiveMandatorOrThrow().getId();
        long time = System.currentTimeMillis();
        for (AccountTransaction at : transactions) {
            Patient pat = at.getPatient();
            if (pat != null) {
                Mandant mn;
                Rechnung rn;
                if (this.bOnlyActiveMandator && ((rn = at.getRechnung()) == null || (mn = rn.getMandant()) != null && !mn.getId().equals(actMnId))) continue;
                Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                row[0] = pif.format(pat.get("PatientNr"));
                row[1] = new DateTool(at.getDate());
                row[2] = at.getAmount();
                row[4] = at.getRemark();
                row[3] = ((Money)row[2]).isNegative() ? Messages.FakturaJournal_FA : (((String)((Object)row[4])).toLowerCase().contains("storno") ? Messages.FakturaJournal_ST : Messages.FakturaJournal_GU);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.add(row);
            }
            monitor.worked(step);
        }
        LoggerFactory.getLogger(FakturaJournal.class).debug("calculation of account transactions size: " + transactions.size() + " took " + String.valueOf((Object)((System.currentTimeMillis() - time) / 1000L)) + " seconds.");
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.FakturaJournal_PatientNr);
        ret.add(Messages.FakturaJournal_Date);
        ret.add(Messages.FakturaJournal_Amount);
        ret.add(Messages.FakturaJournal_Type);
        ret.add(Messages.FakturaJournal_Text);
        return ret;
    }

    public String getDescription() {
        return Messages.FakturaJournal_Faktura;
    }
}

