/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.model;

import ch.elexis.buchhaltung.model.Messages;
import ch.elexis.buchhaltung.util.DateTool;
import ch.elexis.buchhaltung.util.PatientIdFormatter;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.unibe.iam.scg.archie.annotations.GetProperty;
import ch.unibe.iam.scg.archie.annotations.SetProperty;
import ch.unibe.iam.scg.archie.model.AbstractDataProvider;
import ch.unibe.iam.scg.archie.model.SetDataException;
import ch.unibe.iam.scg.archie.ui.widgets.WidgetTypes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ListeNachFaelligkeit
extends AbstractDataProvider {
    private static final String ANALYSIERE_RECHNUNGEN = Messages.ListeNachFaelligkeit_AnalyzingBills;
    private static final String DATENBANKABFRAGE = Messages.ListeNachFaelligkeit_DatabaseQuery;
    private static final String NAME = Messages.ListeNachFaelligkeit_BillsAfterDaysDue;
    private static final String DUE_AFTER_TEXT = "F\u00e4llig nach Tagen";
    private static final String DUE_DATE_TEXT = "Stichtag";
    private static final String FIELD_ACTMANDATOR = "Nur aktueller Mandant";
    private int dueAfter;
    private DateTool stichTag = new DateTool();
    private boolean bOnlyActiveMandator;

    public ListeNachFaelligkeit() {
        super(NAME);
    }

    @SetProperty(name="Stichtag")
    public void setStichtag(String stichtag) throws SetDataException {
        this.stichTag = new DateTool(stichtag);
    }

    @GetProperty(name="Stichtag", widgetType=WidgetTypes.TEXT_DATE, index=-2)
    public String getStichtag() {
        return this.stichTag.toString(4);
    }

    @GetProperty(name="F\u00e4llig nach Tagen", widgetType=WidgetTypes.TEXT_NUMERIC)
    public int getDueAfter() {
        return this.dueAfter;
    }

    @SetProperty(name="F\u00e4llig nach Tagen")
    public void setDueAfter(int date) {
        this.dueAfter = date;
    }

    @GetProperty(name="Nur aktueller Mandant", widgetType=WidgetTypes.BUTTON_CHECKBOX, index=2)
    public boolean getOnlyActiveMandator() {
        return this.bOnlyActiveMandator;
    }

    @SetProperty(name="Nur aktueller Mandant", index=1)
    public void setOnlyActiveMandator(boolean val) {
        this.bOnlyActiveMandator = val;
    }

    protected IStatus createContent(IProgressMonitor monitor) {
        int totalwork = 1000000;
        monitor.beginTask(NAME, totalwork);
        monitor.subTask(DATENBANKABFRAGE);
        Query qbe = new Query(Rechnung.class);
        qbe.add("RnStatus", "<>", Integer.toString(16));
        List rnn = qbe.execute();
        monitor.worked(1000);
        int size = rnn.size();
        if (size == 0) {
            monitor.done();
            return Status.OK_STATUS;
        }
        int step = totalwork / rnn.size();
        monitor.subTask(ANALYSIERE_RECHNUNGEN);
        ArrayList<Comparable[]> result = new ArrayList<Comparable[]>();
        PatientIdFormatter pif = new PatientIdFormatter(8);
        String actMnId = ContextServiceHolder.getActiveMandatorOrThrow().getId();
        for (Rechnung rn : rnn) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.bOnlyActiveMandator && !actMnId.equals(rn.get("MandantID"))) continue;
            if (RnStatus.isActive((int)rn.getStatus()) && StringUtils.isNotBlank((CharSequence)rn.getNr())) {
                DateTool date = new DateTool(rn.getDatumRn());
                date.addDays(this.dueAfter);
                if (date.isBefore(this.stichTag)) {
                    Patient pat;
                    Comparable[] row = new Comparable[this.dataSet.getHeadings().size()];
                    Fall fall = rn.getFall();
                    if (fall != null && (pat = fall.getPatient()) != null) {
                        row[0] = pif.format(pat.get("PatientNr"));
                        row[1] = Integer.valueOf(Integer.parseInt(rn.getNr()));
                        row[2] = new DateTool(date);
                        row[3] = rn.getBetrag();
                        result.add(row);
                    }
                }
            }
            monitor.worked(step);
        }
        this.dataSet.setContent(result);
        monitor.done();
        return Status.OK_STATUS;
    }

    protected List<String> createHeadings() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Messages.ListeNachFaelligkeit_PatientNr);
        ret.add(Messages.ListeNachFaelligkeit_BillNr);
        ret.add(Messages.ListeNachFaelligkeit_Due);
        ret.add(Messages.ListeNachFaelligkeit_Amount);
        return ret;
    }

    public String getDescription() {
        return NAME;
    }
}

