/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.task;

import ch.elexis.base.solr.task.AbstractIDocumentIndexerIdentifiedRunnable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.IModelService;
import ch.elexis.omnivore.model.IDocumentHandle;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentIndexerIdentifiedRunnable
extends AbstractIDocumentIndexerIdentifiedRunnable {
    public static final String RUNNABLE_ID = "solrDocumentIndexer";
    public static final String DESCRIPTION = "Index omnivore documents into SOLR";
    private IModelService omnivoreModelService;
    private final String QUERY = "SELECT ID FROM CH_ELEXIS_OMNIVORE_DATA WHERE !(DOCUMENT_STATUS & 2) AND !(DOCUMENT_STATUS & 8) AND (DOCUMENT_STATUS & 1) AND PatID IS NOT NULL ORDER BY lastUpdate DESC LIMIT 1000";

    public DocumentIndexerIdentifiedRunnable(IModelService omnivoreModelService) {
        this.omnivoreModelService = omnivoreModelService;
    }

    public String getId() {
        return RUNNABLE_ID;
    }

    public String getLocalizedDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getSolrCore() {
        return "el-documents";
    }

    @Override
    protected IModelService getModelService() {
        return this.omnivoreModelService;
    }

    @Override
    protected IDocument loadDocument(String id) {
        return this.omnivoreModelService.load(id, IDocumentHandle.class, true, true).orElse(null);
    }

    @Override
    protected List<?> getDocuments() {
        return this.omnivoreModelService.getNativeQuery("SELECT ID FROM CH_ELEXIS_OMNIVORE_DATA WHERE !(DOCUMENT_STATUS & 2) AND !(DOCUMENT_STATUS & 8) AND (DOCUMENT_STATUS & 1) AND PatID IS NOT NULL ORDER BY lastUpdate DESC LIMIT 1000").executeWithParameters(Collections.emptyMap()).collect(Collectors.toList());
    }
}

