/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.solr.spotlight;

import ch.elexis.core.eenv.AccessToken;
import ch.elexis.core.eenv.IElexisEnvironmentService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.spotlight.ISpotlightResult;
import ch.elexis.core.spotlight.ISpotlightResultContributor;
import java.io.IOException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpotlightResultContributor
implements ISpotlightResultContributor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpSolrClient client;
    private IContextService contextService;
    private final String CORE;

    public AbstractSpotlightResultContributor(String core) {
        this.CORE = core;
    }

    public void activate(IElexisEnvironmentService elexisEnvironmentService, IContextService contextService) {
        this.client = new HttpSolrClient.Builder(elexisEnvironmentService.getSolrBaseUrl()).build();
        this.contextService = contextService;
    }

    public void deactivate() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing client", (Throwable)e);
            }
        }
    }

    public void computeResult(List<String> stringTerms, List<LocalDate> dateTerms, List<Number> numericTerms, ISpotlightResult spotlightResult, Map<String, String> contextParameters) {
        if (stringTerms.isEmpty()) {
            return;
        }
        try {
            String patientId;
            StringBuilder qString = new StringBuilder();
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            if (contextParameters != null && (patientId = contextParameters.get("patientId")) != null) {
                qString.append("patient_id:" + patientId + " AND ");
            }
            qString.append("text:" + (String)stringTerms.stream().reduce((u, t) -> u + " AND text:" + t).get());
            queryParamMap.put("q", qString.toString());
            queryParamMap.put("sort", "cr_date desc");
            queryParamMap.put("rows", "5");
            MapSolrParams queryParams = new MapSolrParams(queryParamMap);
            QueryRequest queryRequest = new QueryRequest((SolrParams)queryParams);
            this.contextService.getTyped(AccessToken.class).ifPresent(accessToken -> queryRequest.addHeader("Authorization", "Bearer " + accessToken.getToken()));
            QueryResponse response = (QueryResponse)queryRequest.process((SolrClient)this.client, this.CORE);
            this.handleResponse(spotlightResult, response);
        }
        catch (IOException | SolrServerException e) {
            this.logger.warn("Error in client.query", e);
        }
    }

    protected abstract void handleResponse(ISpotlightResult var1, QueryResponse var2);
}

