/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.images;

import ch.elexis.base.konsextension.bildanzeige.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class Bild
extends PersistentObject {
    public static final String DBVERSION = "1.2.0";
    public static final String TABLENAME = "BILDANZEIGE";
    public static final String createDB = "CREATE TABLE BILDANZEIGE (ID\t\t\t\tVARCHAR(25) primary key,lastupdate\t\tBIGINT,deleted\t\tCHAR(1) default '0',PatID\t\t\tVARCHAR(25),Datum\t\t\tCHAR(8),Title \t\t\tVARCHAR(30),Info\t\t\tTEXT,Keywords\t\tVARCHAR(80),isRef\t\t\tchar(2),Bild\t\t\tBLOB);CREATE INDEX BANZ1 ON BILDANZEIGE (PatID);CREATE INDEX BANZ2 ON BILDANZEIGE (Keywords);INSERT INTO BILDANZEIGE (ID, TITLE) VALUES ('1','1.2.0');";

    static {
        Bild.addMapping((String)TABLENAME, (String[])new String[]{"PatID", "Datum=S:D:Datum", "Titel=Title", "Keywords", "Bild", "Info"});
        Bild start = Bild.load("1");
        if (start == null) {
            Bild.init();
        } else {
            VersionInfo vi = new VersionInfo(start.get("Titel"));
            if (vi.isOlder(DBVERSION)) {
                if (vi.isOlder(DBVERSION)) {
                    Bild.getConnection().exec("ALTER TABLE BILDANZEIGE ADD lastupdate BIGINT;");
                    start.set("Titel", DBVERSION);
                }
                if (vi.isOlder("1.1.0")) {
                    Bild.getConnection().exec("ALTER TABLE BILDANZEIGE ADD deleted CHAR(1) default '0';");
                    start.set("Titel", DBVERSION);
                } else {
                    SWTHelper.showError((String)Messages.Bild_VersionConflict, (String)Messages.Bild_BadVersionNUmber);
                }
            }
        }
    }

    public static void init() {
        Bild.createOrModifyTable((String)createDB);
    }

    public Bild(Patient patient, String Titel, byte[] data) {
        if (patient == null) {
            SWTHelper.showError((String)Messages.Bild_NoPatientSelected, (String)Messages.Bild_YouShouldSelectAPatient);
            return;
        }
        this.create(null);
        this.set(new String[]{"PatID", "Titel", "Datum"}, new String[]{patient.getId(), Titel, new TimeTool().toString(9)});
        this.setBinary("Bild", data);
    }

    public Patient getPatient() {
        return Patient.load((String)this.get("PatID"));
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(Bild.checkNull((Object)this.get("Titel"))).append(" (").append(this.get("Datum")).append(")");
        return sb.toString();
    }

    public String getDate() {
        return this.get("Datum");
    }

    public String getTitle() {
        return this.get("Titel");
    }

    public String getInfo() {
        return this.get("Info");
    }

    public Image createImage() {
        byte[] data = this.getBinary("Bild");
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Image ret = new Image((Device)UiDesk.getDisplay(), (InputStream)bais);
        return ret;
    }

    public static Bild load(String ID) {
        Bild ret = new Bild(ID);
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    public byte[] getData() {
        return this.getBinary("Bild");
    }

    protected String getTableName() {
        return TABLENAME;
    }

    protected Bild(String id) {
        super(id);
    }

    protected Bild() {
    }
}

