/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.konsextension.bildanzeige;

import ch.elexis.base.konsextension.bildanzeige.BildImportDialog;
import ch.elexis.base.konsextension.bildanzeige.BildanzeigeFenster;
import ch.elexis.base.konsextension.bildanzeige.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.images.Bild;
import ch.rgw.tools.ExHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        return "bildanzeige";
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColor((String)"gruen");
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        Bild bild = Bild.load(refID);
        new BildanzeigeFenster(UiDesk.getTopShell(), bild).open();
        return true;
    }

    public IAction[] getActions() {
        IAction[] ret = new IAction[]{new Action(Messages.KonsExtension_InsertImage){

            public void run() {
                FileDialog fd = new FileDialog(UiDesk.getTopShell());
                String iName = fd.open();
                if (iName != null) {
                    try {
                        ImageLoader iml = new ImageLoader();
                        iml.load(iName);
                        BildImportDialog bid = new BildImportDialog(UiDesk.getTopShell(), iml);
                        if (bid.open() == 0) {
                            Bild bild = bid.result;
                            KonsExtension.this.mine.insertXRef(-1, Messages.KonsExtension_Image + bild.get("Titel"), "bildanzeige", bild.getId());
                        }
                    }
                    catch (Throwable t) {
                        ExHandler.handle((Throwable)t);
                        SWTHelper.showError((String)Messages.KonsExtension_ErrorLoading, (String)(Messages.KonsExtension_ImageCouldnotBeLoaded + t.getMessage()));
                    }
                }
            }
        }};
        return ret;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void removeXRef(String refProvider, String refID) {
        Bild bild = Bild.load(refID);
        bild.delete();
    }

    public void insert(Object o, int pos) {
    }
}

