/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.migel;

import ch.elexis.base.ch.migel.MigelCsvDataImporter;
import ch.elexis.base.ch.migel.ui.MiGelImporter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IArticleBuilder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=migel_xlsx"})
public class MigelXlsxDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static final String REFERENCEDATA_MIGEL_VERSION = "referencedata/migel/version";
    private static Logger log = LoggerFactory.getLogger(MiGelImporter.class);

    private void readExcelLines(ExcelWrapper xl, IProgressMonitor monitor) {
        int lastRow = xl.getLastRow();
        int firstRow = xl.getFirstRow() + 1;
        monitor.beginTask("MiGeL Import", lastRow);
        int invalidAmounts = 0;
        int nrItems = 0;
        String category = "unknown";
        int i = firstRow;
        while (i <= lastRow) {
            List row = xl.getRow(i);
            if (row == null) break;
            String code = ((String)row.get(7)).trim();
            String name = (String)row.get(9);
            if (code.isBlank()) {
                int howMany = name.indexOf("\n");
                category = howMany > 0 ? name.substring(0, howMany) : name;
            } else {
                ++nrItems;
                String position = (String)row.get(0);
                String amount = ((String)row.get(12)).replace("\u2019", "");
                StringBuilder text = new StringBuilder();
                if (!category.isEmpty()) {
                    text.append(StringTool.getFirstLine((String)category, (int)80, (String)"[\\n\\r]")).append(" - ");
                }
                text.append(name);
                String unit_size = (String)row.get(11);
                String size = null;
                String unit = null;
                Pattern p1 = Pattern.compile("(\\d+) (.+)");
                Matcher m1 = p1.matcher(unit_size);
                if (m1.find()) {
                    size = m1.group(1);
                    unit = m1.group(2);
                } else {
                    Pattern p2 = Pattern.compile("(\\d+)");
                    Matcher m2 = p2.matcher(unit_size);
                    if (m1.find()) {
                        size = m2.group(1);
                    } else {
                        unit = unit_size;
                    }
                }
                String shortname = MigelCsvDataImporter.getShortname(text.toString());
                log.trace("xlsx: row {} /{} id {} pos {} code {} shortname {} unit {} size {} price {} text length {}", new Object[]{nrItems, i, "MiGeL" + code, position, code, shortname, unit, size, amount, text.length()});
                IArticle migelArticle = (IArticle)new IArticleBuilder(CoreModelServiceHolder.get(), shortname, code, ArticleTyp.MIGEL).build();
                CoreModelServiceHolder.get().setEntityProperty("id", (Object)("MiGeL" + code), (Identifiable)migelArticle);
                if (unit != null) {
                    migelArticle.setPackageUnit(unit);
                }
                if (size != null) {
                    migelArticle.setPackageSize((int)Double.parseDouble(size));
                }
                try {
                    migelArticle.setSellingPrice(new Money(amount));
                }
                catch (ParseException e1) {
                    ++invalidAmounts;
                    log.warn("Amount not a money {} for code {}. Raw value was {}", new Object[]{amount, code, row.get(12)});
                }
                migelArticle.setExtInfo((Object)"FullText", (Object)text.toString());
                CoreModelServiceHolder.get().save((Identifiable)migelArticle);
                monitor.worked(1);
            }
            ++i;
        }
        log.info("Finished reading {} xlsx lines. Read {} items with {} invalidAmounts", new Object[]{lastRow, nrItems, invalidAmounts});
    }

    public IStatus performImport(@Nullable IProgressMonitor monitor, InputStream input, @Nullable Integer newVersion) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ExcelWrapper xl = new ExcelWrapper();
        int worksheet_id = 0;
        String lang = CoreHub.localCfg.get("ablauf/sprache", "d");
        if (lang.equalsIgnoreCase("d")) {
            worksheet_id = 0;
        } else if (lang.equalsIgnoreCase("f")) {
            worksheet_id = 1;
        } else if (lang.equalsIgnoreCase("i")) {
            worksheet_id = 2;
        } else {
            String msg = String.format("Preferences: System/general language selection for %s was %s", "ablauf/sprache", lang);
            log.error(msg);
            SWTHelper.showError((String)"Bevorzugte Sprache falsch definiert", (String)msg);
            return Status.CANCEL_STATUS;
        }
        log.info("Using worksheet with id {} for lang {}", (Object)worksheet_id, (Object)lang);
        if (xl.load(input, worksheet_id)) {
            xl.setFieldTypes(new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
            this.readExcelLines(xl, monitor);
        }
        if (newVersion != null) {
            ConfigServiceHolder.get().set(REFERENCEDATA_MIGEL_VERSION, newVersion.intValue());
        }
        return Status.OK_STATUS;
    }

    public int getCurrentVersion() {
        return ConfigServiceHolder.get().get(REFERENCEDATA_MIGEL_VERSION, 0);
    }
}

