/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.labortarif;

import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.rgw.tools.StringTool;

public class Fachspec {
    public int code;
    public int from;
    public int until;
    public String name;

    public static Fachspec[] loadFachspecs(int langdef) {
        ExcelWrapper excelWrapper = new ExcelWrapper();
        excelWrapper.setFieldTypes(new Class[]{Integer.class, String.class, Integer.class, Integer.class});
        if (excelWrapper.load(Fachspec.class.getResourceAsStream("/rsc/arztpraxen.xls"), langdef)) {
            int first = excelWrapper.getFirstRow();
            int last = excelWrapper.getLastRow();
            Fachspec[] fspecs = new Fachspec[last - first + 1];
            int i = first;
            while (i <= last) {
                fspecs[i] = new Fachspec(excelWrapper.getRow(i).toArray(new String[0]));
                ++i;
            }
            return fspecs;
        }
        return null;
    }

    Fachspec(String[] line) {
        this(Integer.parseInt(StringTool.getSafe((String[])line, (int)0)), StringTool.getSafe((String[])line, (int)1), Integer.parseInt(StringTool.getSafe((String[])line, (int)2)), Integer.parseInt(StringTool.getSafe((String[])line, (int)3)));
    }

    Fachspec(int code, String name, int from, int until) {
        this.code = code;
        this.from = from;
        this.until = until;
        this.name = name;
    }

    public static int getFachspec(Fachspec[] specs, int row) {
        Fachspec[] fachspecArray = specs;
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            Fachspec spec = fachspecArray[n2];
            if (spec.from <= row && spec.until >= row) {
                return spec.code;
            }
            ++n2;
        }
        return -1;
    }
}

