/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.icd10;

import ch.elexis.base.ch.icd10.ModelUtil;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.entities.ICD10;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.WithExtInfo;
import ch.elexis.core.services.holder.XidServiceHolder;
import java.util.List;
import java.util.Map;

public class Icd10Diagnosis
extends AbstractIdDeleteModelAdapter<ICD10>
implements IDiagnosisTree,
WithExtInfo,
Identifiable {
    public static final String CODESYSTEM_NAME = "ICD-10";

    public Icd10Diagnosis(ICD10 entity) {
        super((EntityWithId)entity);
    }

    public String getDescription() {
        return ((ICD10)this.getEntity()).getText();
    }

    public void setDescription(String value) {
        ((ICD10)this.getEntity()).setText(value);
    }

    public String getCodeSystemName() {
        return CODESYSTEM_NAME;
    }

    public String getCode() {
        return ((ICD10)this.getEntity()).getCode();
    }

    public void setCode(String value) {
        ((ICD10)this.getEntity()).setCode(value);
    }

    public String getText() {
        return ((ICD10)this.getEntity()).getText();
    }

    public void setText(String value) {
        ((ICD10)this.getEntity()).setText(value);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public IDiagnosisTree getParent() {
        String parentCode = ((ICD10)this.getEntity()).getParent();
        if (parentCode != null && "NIL".equals(parentCode)) {
            return ModelUtil.loadDiagnosisWithCode(parentCode).orElse(null);
        }
        return null;
    }

    public void setParent(IDiagnosisTree value) {
        ((ICD10)this.getEntity()).setParent(value.getId());
    }

    public List<IDiagnosisTree> getChildren() {
        return ModelUtil.loadDiagnosisWithParent(this.getId());
    }

    public String getLabel() {
        return this.getCode() + " " + this.getText();
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }
}

