/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.icd10;

import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.INamedQuery;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ModelUtil {
    private static IModelService icd10ModelService;

    @Reference(target="(service.model.name=ch.elexis.base.ch.icd10)")
    public void setModelService(IModelService modelService) {
        icd10ModelService = modelService;
    }

    public static Optional<IDiagnosisTree> loadDiagnosisWithId(String id) {
        return icd10ModelService.load(id, IDiagnosisTree.class);
    }

    public static Optional<IDiagnosisTree> loadDiagnosisWithCode(String code) {
        INamedQuery query = icd10ModelService.getNamedQuery(IDiagnosisTree.class, new String[]{"code"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"code", code}));
        if (!found.isEmpty()) {
            return Optional.of((IDiagnosisTree)found.get(0));
        }
        return Optional.empty();
    }

    public static List<IDiagnosisTree> loadDiagnosisWithParent(String parentId) {
        INamedQuery query = icd10ModelService.getNamedQuery(IDiagnosisTree.class, new String[]{"parent"});
        return query.executeWithParameters(query.getParameterMap(new Object[]{"parent", parentId}));
    }

    public static List<IDiagnosisTree> loadAllDiagnosis() {
        return icd10ModelService.getQuery(IDiagnosisTree.class).execute();
    }
}

