/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.icd10.importer;

import ch.elexis.base.ch.icd10.importer.EntityUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.jpa.entities.ICD10;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeSystem;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component(property={"referenceDataId=icd10_fhir"})
public class Icd10FhirReferenceDataImporter
extends AbstractReferenceDataImporter
implements IReferenceDataImporter {
    private static final String REFERENCEDATA_ICD10FHIR_VERSION = "referencedata/icd10_fhir/version";

    public IStatus performImport(IProgressMonitor monitor, InputStream input, Integer newVersion) {
        if (input != null) {
            try {
                CodeSystem codeSystem;
                monitor.beginTask("ICD-10 loading CodeSystem", -1);
                String jsonString = IOUtils.toString((InputStream)input, (String)"UTF-8");
                IBaseResource resource = ModelUtil.getAsResource((String)jsonString);
                if (resource instanceof CodeSystem && (codeSystem = (CodeSystem)resource).hasConcept()) {
                    List<ICD10> existing = EntityUtil.loadAll(ICD10.class);
                    if (existing.size() > 1) {
                        EntityUtil.removeAll(existing);
                    }
                    monitor.beginTask("ICD-10 Import", codeSystem.getCount());
                    for (CodeSystem.ConceptDefinitionComponent concept : codeSystem.getConcept()) {
                        Optional<CodeSystem.ConceptPropertyComponent> classKind = concept.getProperty().stream().filter(p -> p.getCode() != null && p.getCode().equals("classKind")).findFirst();
                        Optional<CodeSystem.ConceptPropertyComponent> parent = concept.getProperty().stream().filter(p -> p.getCode() != null && p.getCode().equals("parent")).findFirst();
                        ICD10 parentIcd10 = null;
                        if (parent.isPresent()) {
                            parentIcd10 = this.loadIcd10((String)parent.get().getValueStringType().getValue()).orElseThrow(() -> new IllegalStateException("Could not find parent [" + (String)((CodeSystem.ConceptPropertyComponent)parent.get()).getValueStringType().getValue() + "]"));
                        }
                        if (classKind.isPresent()) {
                            if (((String)classKind.get().getValueStringType().getValue()).equals("chapter") || ((String)classKind.get().getValueStringType().getValue()).equals("block")) {
                                ICD10 chapter = new ICD10();
                                if (parentIcd10 != null) {
                                    chapter.setParent(parentIcd10.getId());
                                }
                                chapter.setCode(concept.getCode());
                                chapter.setText(concept.getDisplay());
                                EntityUtil.save(Collections.singletonList(chapter));
                            } else {
                                ICD10 code = new ICD10();
                                if (parentIcd10 != null) {
                                    code.setParent(parentIcd10.getId());
                                }
                                code.setCode(concept.getCode());
                                code.setText(concept.getDisplay());
                                EntityUtil.save(Collections.singletonList(code));
                            }
                        }
                        monitor.worked(1);
                    }
                }
                if (newVersion != null) {
                    ConfigServiceHolder.get().set(REFERENCEDATA_ICD10FHIR_VERSION, newVersion.intValue());
                }
                return Status.OK_STATUS;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error importing ICD10 FHIR resource", (Throwable)e);
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("No input to import");
        }
        return Status.CANCEL_STATUS;
    }

    private Optional<ICD10> loadIcd10(String code) {
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        propertyMap.put("code", code);
        List<ICD10> found = EntityUtil.loadByNamedQuery(propertyMap, ICD10.class);
        if (found.size() == 1) {
            return Optional.of(found.get(0));
        }
        return Optional.empty();
    }

    public int getCurrentVersion() {
        return ConfigServiceHolder.get().get(REFERENCEDATA_ICD10FHIR_VERSION, 0);
    }
}

