/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.ebanking;

import ch.elexis.base.ch.ebanking.model.IEsrRecord;
import ch.elexis.core.model.IInvoice;
import ch.rgw.tools.Money;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FilterSearchField
extends ViewerFilter {
    private static FilterSearchField instance;
    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private String searchString;

    private FilterSearchField() {
    }

    public static FilterSearchField getInstance() {
        if (instance == null) {
            instance = new FilterSearchField();
        }
        return instance;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchString == null || this.searchString.length() < 2) {
            return true;
        }
        IEsrRecord e = (IEsrRecord)element;
        char c = this.searchString.charAt(0);
        String useSearchString = this.searchString.substring(1);
        if (useSearchString.length() < 1) {
            return false;
        }
        switch (c) {
            case '#': {
                String rgNr;
                IInvoice rn = e.getInvoice();
                return rn != null && (rgNr = rn.getNumber()).matches(".*" + useSearchString + ".*");
            }
            case '$': {
                Money betrag = e.getAmount();
                char d = useSearchString.charAt(0);
                switch (d) {
                    case '>': {
                        try {
                            Money moreThan = new Money(useSearchString.substring(1));
                            if (betrag.getCents() < moreThan.getCents()) break;
                            return true;
                        }
                        catch (ParseException e1) {
                            return false;
                        }
                    }
                    case '<': {
                        try {
                            Money moreThan = new Money(useSearchString.substring(1));
                            if (betrag.getCents() > moreThan.getCents()) break;
                            return true;
                        }
                        catch (ParseException e1) {
                            return false;
                        }
                    }
                    default: {
                        if (!betrag.getAmountAsString().matches(".*" + useSearchString + ".*")) break;
                        return true;
                    }
                }
                return false;
            }
        }
        String patLabel = (e.getPatient() != null ? e.getPatient().getLabel() : "").toLowerCase();
        if (patLabel.matches(".*" + useSearchString + ".*")) {
            return true;
        }
        if (this.formatter.format(e.getImportDate()).matches(".*" + useSearchString + ".*")) {
            return true;
        }
        return this.formatter.format(e.getProcessingDate()).matches(".*" + useSearchString + ".*");
    }

    public void setSearchText(String s) {
        this.searchString = s == null || s.length() == 0 ? null : s.toLowerCase();
        if (this.searchString != null) {
            this.searchString = this.searchString.replaceAll("[^#<>\\.$, a-zA-Z0-9]", "");
        }
    }
}

