/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.coding;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.codes.ICodingContribution;
import ch.elexis.core.findings.codes.TransientCoding;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component
public class DatabaseICD10CodingContribution
implements ICodingContribution {
    private HashMap<String, ICoding> codesMap;

    public String getCodeSystem() {
        return CodingSystem.ICD_DE_CODESYSTEM.getSystem();
    }

    public Optional<ICoding> getCode(String code) {
        if (this.codesMap == null && this.isPresent()) {
            this.initialize();
        }
        return Optional.ofNullable(this.codesMap.get(code));
    }

    public synchronized List<ICoding> getCodes() {
        if (this.isPresent()) {
            if (this.codesMap == null) {
                this.initialize();
            }
            return new ArrayList<ICoding>(this.codesMap.values());
        }
        return Collections.emptyList();
    }

    private boolean isPresent() {
        if (PersistentObject.getDefaultConnection() != null) {
            return PersistentObject.tableExists((String)"ICD10");
        }
        return true;
    }

    private void initialize() {
        this.codesMap = new HashMap();
        JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
        try {
            try {
                ResultSet result = statement.query("SELECT ICDCode, ICDTxt FROM ICD10 WHERE ID <> 1 AND ICDTxt NOT LIKE '%Kapitel%' AND ICDCode NOT LIKE '%-%'");
                while (result.next()) {
                    String code = result.getString(1);
                    String text = result.getString(2);
                    this.codesMap.put(code, (ICoding)new TransientCoding(CodingSystem.ICD_DE_CODESYSTEM.getSystem(), code, text));
                }
                result.close();
            }
            catch (SQLException sQLException) {
                PersistentObject.getDefaultConnection().releaseStatement(statement);
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(statement);
        }
    }
}

