/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.diagnosecodes.views;

import ch.elexis.base.ch.diagnosecodes.service.ICD10ModelServiceHolder;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;

public class ICDCodeSelectorFactory
extends CodeSelectorFactory {
    private CommonViewer commonViewer;

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.commonViewer = cv;
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new ICD10ContentProvider(this.commonViewer), new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDiagnosisTree) {
                    return ((IDiagnosisTree)element).getLabel();
                }
                return super.getText(element);
            }
        }, (ViewerConfigurer.ControlFieldProvider)new DefaultControlFieldProvider(cv, new String[]{"Code", "Text"}), (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        this.commonViewer.setNamedSelection("ch.elexis.base.ch.diagnosecodes.icd10.selection");
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        return vc;
    }

    public Class getElementClass() {
        return IDiagnosisTree.class;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "ICD-10";
    }

    private class ICD10ContentProvider
    extends CommonViewerContentProvider
    implements ITreeContentProvider {
        public ICD10ContentProvider(CommonViewer commonViewer) {
            super(commonViewer);
            this.fieldOrderBy = "code";
            this.fieldOrder = IQuery.ORDER.ASC;
        }

        protected IQuery<?> getBaseQuery() {
            return ICD10ModelServiceHolder.get().getQuery(IDiagnosisTree.class);
        }

        public Object[] getElements(Object inputElement) {
            List roots = Collections.emptyList();
            IQuery<?> query = this.getBaseQuery();
            query.and("id", IQuery.COMPARATOR.NOT_EQUALS, (Object)"1");
            if (this.hasActiveFilter(this.fieldFilterValues)) {
                query.startGroup();
                for (String key : this.fieldFilterValues.keySet()) {
                    query.and(key, IQuery.COMPARATOR.LIKE, (Object)("%" + (String)this.fieldFilterValues.get(key) + "%"));
                }
                query.andJoinGroups();
                if (this.fieldOrderBy != null) {
                    query.orderBy(this.fieldOrderBy, this.fieldOrder);
                }
                List found = query.execute();
                ArrayList foundCopy = new ArrayList(found);
                roots = found.parallelStream().filter(d -> this.shouldBeVisible((IDiagnosisTree)d, foundCopy)).collect(Collectors.toList());
            } else {
                query.startGroup();
                query.or((EStructuralFeature)ModelPackage.Literals.IDIAGNOSIS_TREE__PARENT, IQuery.COMPARATOR.EQUALS, null);
                query.or((EStructuralFeature)ModelPackage.Literals.IDIAGNOSIS_TREE__PARENT, IQuery.COMPARATOR.EQUALS, (Object)"NIL");
                query.andJoinGroups();
                if (this.fieldOrderBy != null) {
                    query.orderBy(this.fieldOrderBy, this.fieldOrder);
                }
                roots = query.execute();
            }
            return roots.toArray();
        }

        private boolean hasActiveFilter(Map<String, String> fieldFilterValues) {
            if (fieldFilterValues != null && !fieldFilterValues.isEmpty()) {
                for (String key : fieldFilterValues.keySet()) {
                    String value = fieldFilterValues.get(key);
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean shouldBeVisible(IDiagnosisTree diagnosis, List<IDiagnosisTree> foundCopy) {
            List children = diagnosis.getChildren();
            if (children.isEmpty()) {
                return true;
            }
            for (IDiagnosisTree child : children) {
                if (!foundCopy.contains(child)) continue;
                return true;
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)parentElement).getChildren().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IDiagnosisTree) {
                return ((IDiagnosisTree)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IDiagnosisTree) {
                return !((IDiagnosisTree)element).getChildren().isEmpty();
            }
            return false;
        }
    }
}

