/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.views.TardocCodeSelectorContentProvider;
import ch.elexis.views.TardocSelectorPanelProvider;
import ch.elexis.views.TarmedDetailDisplay;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TardocCodeSelectorFactory
extends CodeSelectorFactory {
    TardocSelectorPanelProvider slp;
    CommonViewer cv;
    int eventType = 1;
    private ShowDetailsAction showDetailsAction = new ShowDetailsAction();
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            TardocCodeSelectorFactory.this.tvfa.updateSelection(ss.isEmpty() ? null : ss.getFirstElement());
            if (!ss.isEmpty()) {
                ITardocLeistung selected = (ITardocLeistung)ss.getFirstElement();
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.tardoc.selection", (Object)selected);
            } else {
                ContextServiceHolder.get().getRootContext().setNamed("ch.elexis.views.codeselector.tardoc.selection", null);
            }
        }
    };

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        this.cv = cv;
        cv.setSelectionChangedListener(this.selChangeListener);
        Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == TardocCodeSelectorFactory.this.eventType && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    TardocCodeSelectorFactory.this.slp.fireChangedEvent();
                }
            }
        };
        this.slp = new TardocSelectorPanelProvider(cv);
        this.slp.addActions(new IAction[]{new ToggleFiltersAction()});
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.tvfa);
        menu.add((IAction)this.showDetailsAction);
        cv.setContextMenu(menu);
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)new TardocCodeSelectorContentProvider(cv), (LabelProvider)new DefaultLabelProvider(), (ViewerConfigurer.ControlFieldProvider)this.slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)new SimpleWidgetProvider(0, 0, null));
        return vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
    }

    public Class getElementClass() {
        return ITardocLeistung.class;
    }

    public void dispose() {
        this.cv.dispose();
    }

    public String getCodeSystemName() {
        return "TARDOC";
    }

    private class ShowDetailsAction
    extends Action {
        private ShowDetailsAction() {
        }

        public String getText() {
            return Messages.TarmedCodeSelectorFactoryDetailsButton;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_CLIPBOARD.getImageDescriptor();
        }

        public void run() {
            Object[] selection = TardocCodeSelectorFactory.this.cv.getSelection();
            if (selection != null && selection.length > 0 && selection[0] instanceof ITarmedLeistung) {
                this.showDetailsFor((ITarmedLeistung)selection[0]);
            }
        }

        private void showDetailsFor(ITarmedLeistung selectedObject) {
            Shell detailShell = new Shell(Display.getCurrent().getActiveShell(), 1264);
            detailShell.setLayout((Layout)new FillLayout());
            TarmedDetailDisplay detailDisplay = new TarmedDetailDisplay();
            detailDisplay.createDisplayFromDeteils((Composite)detailShell, null);
            detailDisplay.display(selectedObject);
            detailShell.setSize(400, 400);
            detailShell.setText(Messages.TarmedCodeSelectorFactoryDetailsTitel);
            detailShell.open();
        }
    }

    private class ToggleFiltersAction
    extends Action {
        public ToggleFiltersAction() {
            super("", 2);
            this.setChecked(true);
        }

        public String getToolTipText() {
            return "Kontext (Konsultation, Fall, etc.) Filter (de)aktivieren";
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_FILTER.getImageDescriptor();
        }

        public void run() {
            TardocCodeSelectorFactory.this.slp.toggleFilters();
        }
    }
}

