/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.xml.exporter;

import at.medevit.elexis.tarmed.model.TarmedJaxbUtil;
import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterProcessing;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.arzttarife.rfe.IReasonForEncounter;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.base.ch.arzttarife.xml.exporter.ServicesFinancialInfo;
import ch.elexis.base.ch.arzttarife.xml.exporter.VatRateSum;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.model.FallConstants;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.IDiagnosisReference;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.model.format.PersonFormatUtil;
import ch.elexis.core.model.format.PostalAddress;
import ch.elexis.core.services.ICoverageService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.services.holder.InvoiceServiceHolder;
import ch.elexis.core.types.ArticleSubTyp;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.Country;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.fd.invoice450.request.BalanceTGType;
import ch.fd.invoice450.request.BalanceTPType;
import ch.fd.invoice450.request.BillerAddressType;
import ch.fd.invoice450.request.BodyType;
import ch.fd.invoice450.request.CompanyType;
import ch.fd.invoice450.request.DebitorAddressType;
import ch.fd.invoice450.request.DiagnosisType;
import ch.fd.invoice450.request.DocumentType;
import ch.fd.invoice450.request.DocumentsType;
import ch.fd.invoice450.request.Esr9Type;
import ch.fd.invoice450.request.EsrAddressType;
import ch.fd.invoice450.request.EsrQRType;
import ch.fd.invoice450.request.GarantType;
import ch.fd.invoice450.request.GuarantorAddressType;
import ch.fd.invoice450.request.InsuranceAddressType;
import ch.fd.invoice450.request.InvoiceType;
import ch.fd.invoice450.request.IvgLawType;
import ch.fd.invoice450.request.KvgLawType;
import ch.fd.invoice450.request.MvgLawType;
import ch.fd.invoice450.request.OnlineAddressType;
import ch.fd.invoice450.request.OrgLawType;
import ch.fd.invoice450.request.PatientAddressType;
import ch.fd.invoice450.request.PayantType;
import ch.fd.invoice450.request.PayloadType;
import ch.fd.invoice450.request.PersonType;
import ch.fd.invoice450.request.PostalAddressType;
import ch.fd.invoice450.request.ProcessingType;
import ch.fd.invoice450.request.PrologType;
import ch.fd.invoice450.request.ProviderAddressType;
import ch.fd.invoice450.request.ReferrerAddressType;
import ch.fd.invoice450.request.ReminderType;
import ch.fd.invoice450.request.RequestType;
import ch.fd.invoice450.request.ServiceExType;
import ch.fd.invoice450.request.ServiceType;
import ch.fd.invoice450.request.ServicesType;
import ch.fd.invoice450.request.SoftwareType;
import ch.fd.invoice450.request.TelecomAddressType;
import ch.fd.invoice450.request.TransportType;
import ch.fd.invoice450.request.TreatmentType;
import ch.fd.invoice450.request.UvgLawType;
import ch.fd.invoice450.request.VatRateType;
import ch.fd.invoice450.request.VatType;
import ch.fd.invoice450.request.VvgLawType;
import ch.fd.invoice450.request.XtraDrugType;
import ch.fd.invoice450.request.ZipType;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import ch.rgw.tools.XMLTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tarmed45Exporter {
    private static Logger logger = LoggerFactory.getLogger(Tarmed45Exporter.class);
    protected boolean printAtIntermediate;
    private ESR besr;
    private EsrType esrType = EsrType.esrQR;
    private boolean updateElectronicDelivery = false;

    public boolean doExport(IInvoice invoice, OutputStream dest, IRnOutputter.TYPE type) {
        try {
            this.besr = null;
            RequestType requestType = new RequestType();
            requestType.setModus(this.getModus(invoice.getCoverage()));
            requestType.setLanguage(Locale.getDefault().getLanguage());
            requestType.setProcessing(this.getProcessing(invoice));
            requestType.setPayload(this.getPayload(invoice, type));
            if (this.updateElectronicDelivery) {
                this.updateElectronicDelivery(invoice, requestType);
            }
            if (this.getBalanceAmount(requestType) != null) {
                if (!invoice.adjustAmount(this.getBalanceAmount(requestType).roundTo5())) {
                    invoice.reject(InvoiceState.REJECTCODE.SUM_MISMATCH, Messages.XMLExporter_SumMismatch);
                }
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            }
            return TarmedJaxbUtil.marshallInvoiceRequest((RequestType)requestType, (OutputStream)dest);
        }
        catch (DatatypeConfigurationException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error generating tarmed xml model", (Throwable)e);
            return false;
        }
    }

    public Money getBalanceAmount(RequestType requestType) {
        if (requestType.getPayload() != null && requestType.getPayload().getBody() != null) {
            if (requestType.getPayload().getBody().getTiersGarant() != null) {
                return new Money(requestType.getPayload().getBody().getTiersGarant().getBalance().getAmount());
            }
            if (requestType.getPayload().getBody().getTiersPayant() != null) {
                return new Money(requestType.getPayload().getBody().getTiersPayant().getBalance().getAmount());
            }
        }
        return null;
    }

    public EsrType getEsrType() {
        return this.esrType;
    }

    public void setEsrType(EsrType esrType) {
        this.esrType = esrType == null ? EsrType.esrQR : esrType;
    }

    public boolean isPrintAtIntermediate() {
        return this.printAtIntermediate;
    }

    public void setPrintAtIntermediate(boolean value) {
        this.printAtIntermediate = value;
    }

    protected String getModus(ICoverage coverage) {
        return "production";
    }

    protected Object getBalance(IInvoice invoice) {
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        ServicesFinancialInfo financialInfo = ServicesFinancialInfo.of(this.getServices(invoice), invoice.getDateFrom());
        if (tiersType == ICoverageService.Tiers.GARANT) {
            BalanceTGType balanceTGType = new BalanceTGType();
            balanceTGType.setCurrency(this.getCurrency(invoice));
            balanceTGType.setAmountPrepaid(Double.valueOf(invoice.getPayedAmount().doubleValue()));
            if (!invoice.getDemandAmount().isZero()) {
                balanceTGType.setAmountReminder(Double.valueOf(invoice.getDemandAmount().doubleValue()));
            }
            balanceTGType.setAmount(financialInfo.getTotalSum().doubleValue());
            balanceTGType.setAmountDue(invoice.getOpenAmount().roundTo5().doubleValue());
            balanceTGType.setAmountObligations(Double.valueOf(financialInfo.getObligationSum().doubleValue()));
            balanceTGType.setVat(this.getVat(invoice, financialInfo));
            return balanceTGType;
        }
        if (tiersType == ICoverageService.Tiers.PAYANT) {
            BalanceTPType balanceTPType = new BalanceTPType();
            balanceTPType.setCurrency(this.getCurrency(invoice));
            if (!invoice.getDemandAmount().isZero()) {
                balanceTPType.setAmountReminder(Double.valueOf(invoice.getDemandAmount().doubleValue()));
            }
            balanceTPType.setAmount(financialInfo.getTotalSum().doubleValue());
            balanceTPType.setAmountDue(invoice.getOpenAmount().roundTo5().doubleValue());
            balanceTPType.setAmountObligations(Double.valueOf(financialInfo.getObligationSum().doubleValue()));
            balanceTPType.setVat(this.getVat(invoice, financialInfo));
            return balanceTPType;
        }
        return null;
    }

    protected VatType getVat(IInvoice invoice, ServicesFinancialInfo financialInfo) {
        VatType vatType = new VatType();
        String vatNumber = (String)invoice.getMandator().getBiller().getExtInfo((Object)"at.medevit.medelexis.vat_ch/MandantVatNumber");
        if (StringUtils.isNotBlank((CharSequence)vatNumber)) {
            vatType.setVatNumber(vatNumber);
        }
        VatRateSum vatSum = financialInfo.getVatRateSum();
        vatType.setVat(vatSum.getSumVat().doubleValue());
        Object[] vatValues = vatSum.getRates().values().toArray(new VatRateSum.VatRateElement[0]);
        Arrays.sort(vatValues);
        Object[] objectArray = vatValues;
        int n = vatValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object rate = objectArray[n2];
            VatRateType vatRateType = new VatRateType();
            vatRateType.setVatRate(((VatRateSum.VatRateElement)rate).getScale());
            vatRateType.setAmount(((VatRateSum.VatRateElement)rate).getAmount().doubleValue());
            vatRateType.setVat(((VatRateSum.VatRateElement)rate).getVat().doubleValue());
            vatType.getVatRate().add(vatRateType);
            ++n2;
        }
        return vatType;
    }

    protected String getCurrency(IInvoice invoice) {
        String curr = (String)invoice.getMandator().getBiller().getExtInfo((Object)Messages.XMLExporter_Currency);
        if (StringUtils.isNotBlank((CharSequence)curr)) {
            return curr;
        }
        return "CHF";
    }

    protected Object getTiers(IInvoice invoice) throws DatatypeConfigurationException {
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        if (tiersType == ICoverageService.Tiers.GARANT) {
            GarantType garantType = new GarantType();
            String paymentPeriode = (String)invoice.getMandator().getBiller().getExtInfo((Object)"rnfrist");
            if (StringTool.isNothing((Object)paymentPeriode)) {
                paymentPeriode = "30";
            }
            garantType.setPaymentPeriod(DatatypeFactory.newInstance().newDuration("P" + paymentPeriode + "D"));
            garantType.setBiller(this.getBiller(invoice));
            garantType.setDebitor(this.getDebitor(invoice));
            garantType.setProvider(this.getProvider(invoice));
            garantType.setInsurance(this.getInsurance(invoice));
            garantType.setPatient(this.getPatient(invoice));
            garantType.setGuarantor(this.getGuarantor(invoice));
            garantType.setReferrer(this.getReferrer(invoice));
            garantType.setBalance((BalanceTGType)this.getBalance(invoice));
            return garantType;
        }
        if (tiersType == ICoverageService.Tiers.PAYANT) {
            PayantType payantTyp = new PayantType();
            payantTyp.setBiller(this.getBiller(invoice));
            payantTyp.setDebitor(this.getDebitor(invoice));
            payantTyp.setProvider(this.getProvider(invoice));
            payantTyp.setInsurance(this.getInsurance(invoice));
            payantTyp.setPatient(this.getPatient(invoice));
            payantTyp.setGuarantor(this.getGuarantor(invoice));
            payantTyp.setReferrer(this.getReferrer(invoice));
            payantTyp.setBalance((BalanceTPType)this.getBalance(invoice));
            return payantTyp;
        }
        throw new IllegalStateException("Unknown tiers [" + String.valueOf(tiersType) + "]");
    }

    protected DebitorAddressType getDebitor(IInvoice invoice) {
        DebitorAddressType debitorAddressType = new DebitorAddressType();
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        IContact debitor = null;
        debitor = tiersType == ICoverageService.Tiers.GARANT ? XMLExporterUtil.getGuarantor(tiersType.getShortName(), invoice.getCoverage().getPatient(), invoice.getCoverage()) : invoice.getCoverage().getCostBearer();
        debitorAddressType.setEanParty(TarmedRequirements.getEAN(debitor));
        Object companyOrPerson = this.getCompanyOrPerson(debitor, false);
        if (companyOrPerson instanceof CompanyType) {
            debitorAddressType.setCompany((CompanyType)companyOrPerson);
        } else if (companyOrPerson instanceof PersonType) {
            debitorAddressType.setPerson((PersonType)companyOrPerson);
        }
        return debitorAddressType;
    }

    protected ReferrerAddressType getReferrer(IInvoice invoice) {
        IContact auftraggeber = CoverageServiceHolder.get().getRequiredContact(invoice.getCoverage(), "Zuweiser");
        if (auftraggeber != null) {
            Object companyOrPerson;
            String zsr;
            ReferrerAddressType referrerAddressType = new ReferrerAddressType();
            String ean = TarmedRequirements.getEAN(auftraggeber);
            if (StringUtils.isNotBlank((CharSequence)ean)) {
                referrerAddressType.setEanParty(ean);
            }
            if (StringUtils.isNotBlank((CharSequence)(zsr = TarmedRequirements.getKSK(auftraggeber)))) {
                referrerAddressType.setZsr(zsr);
            }
            if ((companyOrPerson = this.getCompanyOrPerson(auftraggeber, false)) instanceof CompanyType) {
                referrerAddressType.setCompany((CompanyType)companyOrPerson);
            } else if (companyOrPerson instanceof PersonType) {
                referrerAddressType.setPerson((PersonType)companyOrPerson);
            }
            return referrerAddressType;
        }
        return null;
    }

    protected GuarantorAddressType getGuarantor(IInvoice invoice) {
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        IContact guarantor = XMLExporterUtil.getGuarantor(tiersType.getShortName(), invoice.getCoverage().getPatient(), invoice.getCoverage());
        if (guarantor != null) {
            GuarantorAddressType guarantorAddressType = new GuarantorAddressType();
            Object companyOrPerson = this.getCompanyOrPerson(guarantor, false);
            if (companyOrPerson instanceof CompanyType) {
                guarantorAddressType.setCompany((CompanyType)companyOrPerson);
            } else if (companyOrPerson instanceof PersonType) {
                guarantorAddressType.setPerson((PersonType)companyOrPerson);
            }
            return guarantorAddressType;
        }
        return null;
    }

    protected PatientAddressType getPatient(IInvoice invoice) throws DatatypeConfigurationException {
        IPatient patient = invoice.getCoverage().getPatient();
        PatientAddressType patientAddressType = new PatientAddressType();
        if (patient == null) {
            throw new IllegalStateException("Invoice without patient");
        }
        patientAddressType.setGender(patient.getGender().toString().toLowerCase());
        LocalDateTime dateOfBirth = patient.getDateOfBirth();
        if (dateOfBirth == null) {
            patientAddressType.setBirthdate(XMLExporterUtil.makeXMLDateTime(LocalDateTime.of(1, 1, 1, 0, 0)));
        } else {
            patientAddressType.setBirthdate(XMLExporterUtil.makeXMLDateTime(dateOfBirth));
        }
        patientAddressType.setPerson(this.getPerson((IContact)patient, false));
        if (StringUtils.isNotBlank((CharSequence)((String)invoice.getCoverage().getExtInfo((Object)"VEKANr")))) {
            PatientAddressType.Card card = new PatientAddressType.Card();
            card.setCardId((String)invoice.getCoverage().getExtInfo((Object)"VEKANr"));
            if (StringUtils.isNotBlank((CharSequence)((String)invoice.getCoverage().getExtInfo((Object)"VEKAValid")))) {
                card.setExpiryDate(XMLExporterUtil.makeTarmedDate((String)invoice.getCoverage().getExtInfo((Object)"VEKAValid")));
            }
            patientAddressType.setCard(card);
        }
        patientAddressType.setSsn(this.getSSN(invoice));
        return patientAddressType;
    }

    protected InsuranceAddressType getInsurance(IInvoice invoice) {
        ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
        IContact costBearer = invoice.getCoverage().getCostBearer();
        if (costBearer == null) {
            costBearer = invoice.getCoverage().getPatient();
        }
        String kEAN = TarmedRequirements.getEAN(costBearer);
        InsuranceAddressType insuranceAddressType = new InsuranceAddressType();
        if (tiersType == ICoverageService.Tiers.GARANT) {
            if (costBearer.isOrganization() && kEAN.matches("[0-9]{13,13}")) {
                insuranceAddressType.setEanParty(kEAN);
                insuranceAddressType.setCompany(this.getCompany(costBearer, false));
            }
        } else if (tiersType == ICoverageService.Tiers.PAYANT) {
            insuranceAddressType.setEanParty(kEAN);
            insuranceAddressType.setCompany(this.getCompany(costBearer, false));
        }
        return insuranceAddressType.getEanParty() == null ? null : insuranceAddressType;
    }

    protected CompanyType getCompany(IContact contact, boolean useContactPostalAddress) {
        if (contact.isOrganization()) {
            return (CompanyType)this.getCompanyOrPerson(contact, useContactPostalAddress);
        }
        CompanyType companyType = new CompanyType();
        companyType.setCompanyname(StringUtils.abbreviate((String)contact.getDescription1(), (int)35));
        companyType.setPostal(this.getPostalAddress(contact));
        companyType.setTelecom(this.getTelecom(contact));
        companyType.setOnline(this.getOnline(contact));
        return companyType;
    }

    protected PersonType getPerson(IContact contact, boolean useContactPostalAddress) {
        if (contact.isPerson()) {
            return (PersonType)this.getCompanyOrPerson(contact, useContactPostalAddress);
        }
        throw new IllegalStateException("Contact is not a person");
    }

    protected ProviderAddressType getProvider(IInvoice invoice) {
        Object companyOrPerson;
        String spec;
        Optional fixProvider;
        ProviderAddressType providerAddressType = new ProviderAddressType();
        IMandator provider = invoice.getMandator();
        if (StringUtils.isNotBlank((CharSequence)ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null)) && (fixProvider = CoreModelServiceHolder.get().load(ConfigServiceHolder.getGlobal((String)"TarmedBillFixProvider", null), IContact.class)).isPresent()) {
            logger.info("Fixed provider [" + ((IContact)fixProvider.get()).getLabel() + "] ean [" + TarmedRequirements.getEAN((IContact)fixProvider.get()) + "]");
            provider = (IContact)fixProvider.get();
        }
        providerAddressType.setEanParty(TarmedRequirements.getEAN((IContact)provider));
        String zsr = TarmedRequirements.getKSK((IContact)provider);
        if (StringUtils.isNotBlank((CharSequence)zsr)) {
            providerAddressType.setZsr(zsr);
        }
        if (StringUtils.isNotBlank((CharSequence)(spec = (String)provider.getExtInfo((Object)TarmedACL.getInstance().SPEC)))) {
            providerAddressType.setSpecialty(spec);
        }
        if ((companyOrPerson = this.getCompanyOrPerson((IContact)provider, false)) instanceof CompanyType) {
            providerAddressType.setCompany((CompanyType)companyOrPerson);
        } else if (companyOrPerson instanceof PersonType) {
            providerAddressType.setPerson((PersonType)companyOrPerson);
        }
        return providerAddressType;
    }

    protected BillerAddressType getBiller(IInvoice invoice) {
        Object companyOrPerson;
        String spec;
        IContact biller = invoice.getMandator().getBiller();
        BillerAddressType billerAddressType = new BillerAddressType();
        billerAddressType.setEanParty(TarmedRequirements.getEAN(biller));
        String zsr = TarmedRequirements.getKSK(biller);
        if (StringUtils.isNotBlank((CharSequence)zsr)) {
            billerAddressType.setZsr(zsr);
        }
        if (StringUtils.isNotBlank((CharSequence)(spec = (String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().SPEC)))) {
            billerAddressType.setSpecialty(spec);
        }
        if ((companyOrPerson = this.getCompanyOrPerson(biller, false)) instanceof CompanyType) {
            billerAddressType.setCompany((CompanyType)companyOrPerson);
        } else if (companyOrPerson instanceof PersonType) {
            billerAddressType.setPerson((PersonType)companyOrPerson);
        }
        return billerAddressType;
    }

    protected Object getCompanyOrPerson(IContact contact, boolean useContactPostalAddress) {
        if (contact.isOrganization()) {
            CompanyType companyType = new CompanyType();
            companyType.setCompanyname(StringUtils.abbreviate((String)contact.getDescription1(), (int)35));
            companyType.setPostal(this.getPostalAddress(contact));
            companyType.setTelecom(this.getTelecom(contact));
            companyType.setOnline(this.getOnline(contact));
            return companyType;
        }
        if (contact.isPerson()) {
            PersonType personType = new PersonType();
            if (useContactPostalAddress) {
                PostalAddress postAnschrift = PostalAddress.ofText((String)contact.getPostalAddress());
                personType.setFamilyname(StringUtils.abbreviate((String)postAnschrift.getLastName(), (int)35));
                personType.setGivenname(StringUtils.abbreviate((String)postAnschrift.getFirstName(), (int)35));
                if (StringUtils.isNotBlank((CharSequence)postAnschrift.getSalutation())) {
                    personType.setSalutation(StringUtils.abbreviate((String)postAnschrift.getSalutation(), (int)35));
                }
            } else {
                String salutation = (String)contact.getExtInfo((Object)"Anrede");
                if (StringUtils.isNotBlank((CharSequence)salutation)) {
                    personType.setSalutation(StringUtils.abbreviate((String)salutation, (int)35));
                }
                if (contact.isPerson()) {
                    IPerson person = (IPerson)CoreModelServiceHolder.get().load(contact.getId(), IPerson.class).get();
                    if (StringUtils.isNotBlank((CharSequence)person.getTitel())) {
                        personType.setTitle(StringUtils.abbreviate((String)person.getTitel(), (int)35));
                    }
                    if (StringUtils.isBlank((CharSequence)salutation) && StringUtils.isNotBlank((CharSequence)PersonFormatUtil.getSalutation((IPerson)person))) {
                        personType.setSalutation(StringUtils.abbreviate((String)PersonFormatUtil.getSalutation((IPerson)person), (int)35));
                    }
                }
                personType.setFamilyname(StringUtils.abbreviate((String)contact.getDescription1(), (int)35));
                personType.setGivenname(StringUtils.abbreviate((String)contact.getDescription2(), (int)35));
                if (StringUtils.isEmpty((CharSequence)contact.getDescription2())) {
                    personType.setGivenname("Unbekannt");
                }
            }
            personType.setPostal(this.getPostalAddress(contact));
            personType.setTelecom(this.getTelecom(contact));
            personType.setOnline(this.getOnline(contact));
            return personType;
        }
        throw new IllegalStateException("Contact [" + contact.getLabel() + "] is no organization and no person");
    }

    protected OnlineAddressType getOnline(IContact contact) {
        OnlineAddressType onlineAddressType = new OnlineAddressType();
        if (StringUtils.isNotBlank((CharSequence)contact.getEmail())) {
            String email = XMLExporterUtil.getValidXMLString(StringUtils.left((String)contact.getEmail(), (int)70));
            if (!email.matches(".+@.+")) {
                email = "mail@invalid.invalid";
            }
            onlineAddressType.getEmail().add(email);
        }
        if (StringUtils.isNotBlank((CharSequence)contact.getWebsite())) {
            String website = XMLExporterUtil.getValidXMLString(StringUtils.left((String)contact.getWebsite(), (int)100));
            onlineAddressType.getUrl().add(website);
        }
        return onlineAddressType.getEmail().isEmpty() ? null : onlineAddressType;
    }

    protected TelecomAddressType getTelecom(IContact contact) {
        TelecomAddressType telecomAddressType = new TelecomAddressType();
        if (!contact.isMandator() && StringUtils.isNotBlank((CharSequence)contact.getMobile())) {
            telecomAddressType.getPhone().add(StringUtils.abbreviate((String)contact.getMobile(), (int)25));
        }
        if (StringUtils.isNotBlank((CharSequence)contact.getPhone1())) {
            telecomAddressType.getPhone().add(StringUtils.abbreviate((String)contact.getPhone1(), (int)25));
        }
        if (!telecomAddressType.getPhone().isEmpty() && StringUtils.isNotBlank((CharSequence)contact.getFax())) {
            telecomAddressType.getFax().add(StringUtils.abbreviate((String)contact.getFax(), (int)25));
        }
        return telecomAddressType.getPhone().isEmpty() ? null : telecomAddressType;
    }

    protected PostalAddressType getPostalAddress(IContact contact) {
        PostalAddressType postalAddressType = new PostalAddressType();
        String pobox = (String)contact.getExtInfo((Object)"Postfach");
        if (StringUtils.isNotBlank((CharSequence)pobox)) {
            postalAddressType.setPobox(StringUtils.abbreviate((String)pobox, (int)35));
        }
        if (StringUtils.isNotBlank((CharSequence)contact.getStreet())) {
            postalAddressType.setStreet(StringUtils.abbreviate((String)contact.getStreet(), (int)35));
        }
        postalAddressType.setCity(StringUtils.abbreviate((String)((String)StringUtils.defaultIfBlank((CharSequence)contact.getCity(), (CharSequence)Messages.XMLExporter_Unknown)), (int)35));
        String zip = (String)StringUtils.defaultIfBlank((CharSequence)contact.getZip(), (CharSequence)"0000");
        ZipType zipType = new ZipType();
        zipType.setValue(StringUtils.left((String)zip, (int)9));
        Country country = contact.getCountry();
        if (Country.NDF == country) {
            logger.info("IContact [] Country not set, defaulting to CH", (Object)contact.getId());
            country = Country.CH;
        }
        if (StringUtils.isNotBlank((CharSequence)country.toString())) {
            zipType.setCountrycode(StringUtils.left((String)country.toString(), (int)3));
        }
        postalAddressType.setZip(zipType);
        return postalAddressType;
    }

    protected ServicesType getServices(IInvoice invoice) {
        ServicesType servicesType = new ServicesType();
        List encounters = invoice.getEncounters();
        LocalDate lastEncounterDate = null;
        int session = 1;
        for (IEncounter encounter : encounters) {
            List encounterBilled = encounter.getBilled();
            LocalDate encounterDate = encounter.getDate();
            if (encounterDate.equals(lastEncounterDate)) {
                ++session;
            } else {
                lastEncounterDate = encounterDate;
                session = 1;
            }
            boolean bRFE = false;
            try {
                for (IBilled billed : encounterBilled) {
                    IBillable billable = billed.getBillable();
                    if (billable == null) {
                        logger.error(Messages.XMLExporter_ErroneusBill + invoice.getNumber() + " Null-Verrechenbar bei Kons " + encounter.getLabel());
                        continue;
                    }
                    if ("001".equals(billable.getCodeSystemCode())) {
                        ServiceExType serviceExType = new ServiceExType();
                        serviceExType.setTreatment("ambulatory");
                        String bezug = (String)((ITarmedLeistung)billable).getExtension().getExtInfo((Object)"Bezug");
                        if (StringTool.isNothing((Object)bezug)) {
                            bezug = (String)billed.getExtInfo((Object)"Bezug");
                        }
                        if (!StringTool.isNothing((Object)bezug)) {
                            serviceExType.setRefCode(bezug);
                        }
                        serviceExType.setBillingRole("both");
                        serviceExType.setMedicalRole("self_employed");
                        serviceExType.setBodyLocation(ArzttarifeUtil.getSide((IBilled)billed));
                        double primaryScale = billed.getPrimaryScaleFactor();
                        double secondaryScale = 1.0;
                        if (!billed.isNonIntegerAmount()) {
                            secondaryScale = billed.getSecondaryScaleFactor();
                        }
                        double mult = billed.getFactor();
                        double tlAL = ArzttarifeUtil.getAL((IBilled)billed);
                        double tlTL = ArzttarifeUtil.getTL((IBilled)billed);
                        Money mAL = ArzttarifeUtil.getALMoney((IBilled)billed);
                        Money mTL = ArzttarifeUtil.getTLMoney((IBilled)billed);
                        Money mAmountLocal = billed.getTotal();
                        serviceExType.setUnitMt(tlAL / 100.0);
                        XMLExporterUtil.getALNotScaled(billed).ifPresent(d -> serviceExType.setUnitMt(d / 100.0));
                        serviceExType.setUnitFactorMt(mult);
                        serviceExType.setScaleFactorMt(Double.valueOf(primaryScale));
                        XMLExporterUtil.getALScalingFactor(billed).ifPresent(f -> {
                            f = f * primaryScale;
                            serviceExType.setScaleFactorMt(f);
                        });
                        serviceExType.setExternalFactorMt(Double.valueOf(secondaryScale));
                        serviceExType.setAmountMt(Double.valueOf(mAL.doubleValue()));
                        serviceExType.setUnitTt(tlTL / 100.0);
                        serviceExType.setUnitFactorTt(mult);
                        serviceExType.setScaleFactorTt(Double.valueOf(primaryScale));
                        serviceExType.setExternalFactorTt(Double.valueOf(secondaryScale));
                        serviceExType.setAmountTt(Double.valueOf(mTL.doubleValue()));
                        serviceExType.setAmount(mAmountLocal.doubleValue());
                        serviceExType.setVatRate(this.getVatRate(billed));
                        if (!bRFE) {
                            List<IReasonForEncounter> rfes = XMLExporterUtil.getReasonsForEncounter(encounter);
                            if (rfes.size() > 0) {
                                StringBuilder sb = new StringBuilder();
                                for (IReasonForEncounter rfe : rfes) {
                                    sb.append("551_").append(rfe.getCode()).append(" ");
                                }
                                serviceExType.setRemark(sb.toString());
                            }
                            bRFE = true;
                        }
                        serviceExType.setTariffType(billable.getCodeSystemCode());
                        serviceExType.setCode(billable.getCode());
                        serviceExType.setQuantity(billed.getAmount());
                        serviceExType.setSession(Integer.valueOf(session));
                        serviceExType.setName(billed.getText());
                        serviceExType.setDateBegin(XMLExporterUtil.makeXMLDate(encounterDate));
                        serviceExType.setProviderId(TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                        serviceExType.setResponsibleId(XMLExporterUtil.getResponsibleEAN(encounter));
                        serviceExType.setObligation(this.getObligation(billed, billable));
                        servicesType.getServiceExOrService().add(serviceExType);
                        continue;
                    }
                    ServiceType serviceType = new ServiceType();
                    serviceType.setAmount(billed.getTotal().doubleValue());
                    serviceType.setVatRate(this.getVatRate(billed));
                    serviceType.setUnit(billed.getPrice().doubleValue());
                    if ("581".equals(billable.getCodeSystemCode())) {
                        serviceType.setUnit((double)billed.getPoints() / 100.0);
                    }
                    serviceType.setUnitFactor(Double.valueOf(billed.getFactor()));
                    serviceType.setTariffType(billable.getCodeSystemCode());
                    if ("311".equals(billable.getCodeSystemCode())) {
                        if (encounter.getCoverage().getBillingSystem().getLaw() == BillingLaw.KVG) {
                            serviceType.setTariffType("312");
                        }
                        serviceType.setUnit((double)(billed.getPoints() / 100));
                    }
                    serviceType.setCode(billable.getCode());
                    serviceType.setQuantity(billed.getAmount());
                    serviceType.setSession(Integer.valueOf(session));
                    serviceType.setName(billed.getText());
                    if (billable instanceof IArticle) {
                        XtraDrugType drugType = new XtraDrugType();
                        drugType.setIndicated(Boolean.valueOf(false));
                        if ("true".equals(billed.getExtInfo((Object)"indicated"))) {
                            serviceType.setName(serviceType.getName() + " (medizinisch indiziert: 207)");
                            drugType.setIndicated(Boolean.valueOf(true));
                        }
                        if ("true".equals(billed.getExtInfo((Object)"originalnosubstitute"))) {
                            serviceType.setName(serviceType.getName() + " (Substitution nicht m\u00f6glich)");
                        }
                        serviceType.setXtraDrug(drugType);
                    }
                    serviceType.setDateBegin(XMLExporterUtil.makeXMLDate(encounterDate));
                    serviceType.setProviderId(TarmedRequirements.getEAN((IContact)encounter.getMandator()));
                    serviceType.setResponsibleId(XMLExporterUtil.getResponsibleEAN(encounter));
                    serviceType.setObligation(this.getObligation(billed, billable));
                    if ("406".equals(billable.getCodeSystemCode()) && !this.isCovid(billable)) {
                        serviceType.setCode("2000");
                        if (billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL && StringUtils.isBlank((CharSequence)this.getServiceCode(billed)) && StringUtils.isNotBlank((CharSequence)((IArticle)billable).getGtin())) {
                            serviceType.setName(serviceType.getName() + " [" + ((IArticle)billable).getGtin() + "]");
                        } else {
                            serviceType.setName(serviceType.getName() + " [" + this.getServiceCode(billed) + "]");
                        }
                    }
                    if ("590".equals(billable.getCodeSystemCode()) && billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL) {
                        serviceType.setCode("1310");
                    }
                    if ("410".equals(billable.getCodeSystemCode()) && billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL) {
                        serviceType.setCode("1000");
                    }
                    servicesType.getServiceExOrService().add(serviceType);
                }
            }
            catch (DatatypeConfigurationException e) {
                logger.error("Error creating tarmed services for invoice nr [" + invoice.getNumber() + "]", (Throwable)e);
                return null;
            }
        }
        if (servicesType.getServiceExOrService() != null) {
            servicesType.getServiceExOrService().sort((l, r) -> {
                Integer rTariff;
                Integer lTariff;
                LocalDate rDate;
                LocalDate lDate = this.getServiceExOrServiceDate(l);
                int ret = lDate.compareTo(rDate = this.getServiceExOrServiceDate(r));
                if (ret == 0 && (ret = (lTariff = this.getServiceExOrServiceTariffType(l)).compareTo(rTariff = this.getServiceExOrServiceTariffType(r))) == 0) {
                    String lCode = this.getServiceExOrServiceCode(l);
                    String rCode = this.getServiceExOrServiceCode(r);
                    ret = lCode.compareTo(rCode);
                }
                return ret;
            });
        }
        List list = servicesType.getServiceExOrService();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ServiceExType) {
                ((ServiceExType)list.get(i)).setRecordId(i + 1);
            } else if (list.get(i) instanceof ServiceType) {
                ((ServiceType)list.get(i)).setRecordId(i + 1);
            }
            ++i;
        }
        return servicesType;
    }

    private String getServiceCode(IBilled billed) {
        String ret = billed.getCode();
        IBillable billable = billed.getBillable();
        if ((billable instanceof ICustomService || billable instanceof IArticle && ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL) && billable.getId().equals(ret)) {
            ret = "";
        }
        return ret;
    }

    private boolean isCovid(IBillable billable) {
        if (billable instanceof IArticle) {
            return ((IArticle)billable).getTyp() == ArticleTyp.EIGENARTIKEL && ((IArticle)billable).getSubTyp() == ArticleSubTyp.COVID;
        }
        return false;
    }

    private String getServiceExOrServiceCode(Object obj) {
        if (obj instanceof ServiceType) {
            return ((ServiceType)obj).getCode();
        }
        if (obj instanceof ServiceExType) {
            return ((ServiceExType)obj).getCode();
        }
        throw new IllegalArgumentException("Unknown type [" + obj.getClass().getName() + "]");
    }

    private Integer getServiceExOrServiceTariffType(Object obj) {
        if (obj instanceof ServiceType) {
            return Integer.parseInt(((ServiceType)obj).getTariffType());
        }
        if (obj instanceof ServiceExType) {
            return Integer.parseInt(((ServiceExType)obj).getTariffType());
        }
        throw new IllegalArgumentException("Unknown type [" + obj.getClass().getName() + "]");
    }

    private LocalDate getServiceExOrServiceDate(Object obj) {
        if (obj instanceof ServiceType) {
            return XMLExporterUtil.getAsLocalDate(((ServiceType)obj).getDateBegin());
        }
        if (obj instanceof ServiceExType) {
            return XMLExporterUtil.getAsLocalDate(((ServiceExType)obj).getDateBegin());
        }
        throw new IllegalArgumentException("Unknown type [" + obj.getClass().getName() + "]");
    }

    protected Boolean getObligation(IBilled billed, IBillable billable) {
        String tariffTyp = billable.getCodeSystemCode();
        if (billable instanceof ITarmedLeistung) {
            return ArzttarifeUtil.isObligation((IBilled)billed);
        }
        if (billable instanceof IArticle) {
            if ("452".equals(tariffTyp)) {
                return true;
            }
            return ((IArticle)billable).isObligation();
        }
        if ("311".equals(tariffTyp)) {
            return true;
        }
        if ("312".equals(tariffTyp)) {
            return true;
        }
        if ("317".equals(tariffTyp)) {
            return true;
        }
        if ("351".equals(tariffTyp)) {
            return true;
        }
        if ("581".equals(tariffTyp)) {
            return true;
        }
        return false;
    }

    protected Double getVatRate(IBilled billed) {
        Double ret = 0.0;
        String vatScale = (String)billed.getExtInfo((Object)"vat_scale");
        if (vatScale != null && vatScale.length() > 0) {
            ret = Double.parseDouble(vatScale);
        }
        return ret;
    }

    protected PayloadType getPayload(IInvoice invoice, IRnOutputter.TYPE type) throws DatatypeConfigurationException {
        PayloadType payloadType = new PayloadType();
        payloadType.setType("invoice");
        payloadType.setInvoice(this.getInvoice(invoice));
        payloadType.setBody(this.getBody(invoice));
        payloadType.setCopy(Boolean.valueOf(type == IRnOutputter.TYPE.COPY));
        payloadType.setStorno(Boolean.valueOf(type == IRnOutputter.TYPE.STORNO));
        return payloadType;
    }

    protected InvoiceType getInvoice(IInvoice invoice) throws DatatypeConfigurationException {
        InvoiceType invoiceType = new InvoiceType();
        invoiceType.setRequestTimestamp((int)(new Date().getTime() / 1000L));
        invoiceType.setRequestDate(XMLExporterUtil.makeXMLDate(invoice.getDate()));
        invoiceType.setRequestId(InvoiceServiceHolder.get().getCombinedId(invoice));
        return invoiceType;
    }

    protected BodyType getBody(IInvoice invoice) throws DatatypeConfigurationException {
        BodyType bodyType = new BodyType();
        bodyType.setRole("physician");
        bodyType.setPlace("practice");
        bodyType.setProlog(this.getProlog(invoice));
        Object tiers = this.getTiers(invoice);
        if (tiers instanceof GarantType) {
            bodyType.setTiersGarant((GarantType)tiers);
        } else if (tiers instanceof PayantType) {
            bodyType.setTiersPayant((PayantType)tiers);
        }
        if (this.esrType == EsrType.esr9) {
            bodyType.setEsr9(this.getEsr9(invoice));
        } else if (this.esrType == EsrType.esrQR) {
            bodyType.setEsrQR(this.getEsrQR(invoice));
        }
        Object lawType = this.getLawType(invoice);
        if (lawType instanceof KvgLawType) {
            bodyType.setKvg((KvgLawType)lawType);
        } else if (lawType instanceof UvgLawType) {
            bodyType.setUvg((UvgLawType)lawType);
        } else if (lawType instanceof IvgLawType) {
            bodyType.setIvg((IvgLawType)lawType);
        } else if (lawType instanceof MvgLawType) {
            bodyType.setMvg((MvgLawType)lawType);
        } else if (lawType instanceof VvgLawType) {
            bodyType.setVvg((VvgLawType)lawType);
        } else if (lawType instanceof OrgLawType) {
            bodyType.setOrg((OrgLawType)lawType);
        }
        bodyType.setTreatment(this.getTreatment(invoice));
        bodyType.setServices(this.getServices(invoice));
        if (invoice.getAttachments() != null && !invoice.getAttachments().isEmpty()) {
            bodyType.setDocuments(this.getDocuments(invoice));
        }
        if (StringUtils.isNotBlank((CharSequence)invoice.getRemark())) {
            bodyType.setRemark(invoice.getRemark());
        }
        return bodyType;
    }

    private DocumentsType getDocuments(IInvoice invoice) {
        DocumentsType documentsType = new DocumentsType();
        for (IDocument attachment : invoice.getAttachments()) {
            String mimeType = attachment.getMimeType();
            if (mimeType == null || !mimeType.endsWith("pdf")) {
                logger.warn("Cannot add attachment [{}], mimeType is null or not pdf", (Object)attachment.getId());
                continue;
            }
            try {
                InputStream content = attachment.getContent();
                if (content != null) {
                    byte[] byteArray = IOUtils.toByteArray((InputStream)attachment.getContent());
                    DocumentType document = new DocumentType();
                    Object title = attachment.getTitle();
                    if (((String)title).length() > 35) {
                        title = ((String)title).substring(0, 31) + "." + FilenameUtils.getExtension((String)attachment.getTitle());
                    }
                    document.setTitle((String)title);
                    document.setFilename(attachment.getTitle());
                    document.setMimeType("application/pdf");
                    document.setBase64(byteArray);
                    documentsType.getDocument().add(document);
                    continue;
                }
                logger.warn("Cannot add attachment [{}], content is null", (Object)attachment.getId());
            }
            catch (IOException e) {
                logger.warn("Cannot add attachment [{}], cannot read content", (Object)attachment.getId(), (Object)e);
            }
        }
        documentsType.setNumber(new BigInteger(Integer.toString(documentsType.getDocument().size())));
        return documentsType.getDocument().isEmpty() ? null : documentsType;
    }

    protected TreatmentType getTreatment(IInvoice invoice) throws DatatypeConfigurationException {
        String gestationWeekString;
        TreatmentType treatmentType = new TreatmentType();
        treatmentType.setDateBegin(XMLExporterUtil.makeXMLDate(invoice.getDateFrom()));
        treatmentType.setDateEnd(XMLExporterUtil.makeXMLDate(invoice.getDateTo()));
        treatmentType.setCanton((String)invoice.getMandator().getExtInfo((Object)TarmedACL.getInstance().KANTON));
        treatmentType.setReason(this.getTreatmentReason(invoice.getCoverage()));
        if (FallConstants.TYPE_MATERNITY.equals(invoice.getCoverage().getReason()) && StringUtils.isNotBlank((CharSequence)(gestationWeekString = (String)invoice.getCoverage().getExtInfo((Object)"gestation_week13")))) {
            treatmentType.setGestationWeek13(XMLExporterUtil.makeXMLDate(new TimeTool(gestationWeekString)));
        }
        for (IDiagnosisReference invoiceDiagnosis : this.getInvoiceDiagnosis(invoice)) {
            DiagnosisType diagnosisType = new DiagnosisType();
            String type = this.getTreatmentDiagnosisType(invoiceDiagnosis);
            diagnosisType.setType(type);
            String code = invoiceDiagnosis.getCode();
            if (type.equalsIgnoreCase("freetext")) {
                diagnosisType.setValue(invoiceDiagnosis.getText());
            } else {
                diagnosisType.setCode(StringUtils.left((String)code, (int)12));
            }
            treatmentType.getDiagnosis().add(diagnosisType);
        }
        return treatmentType;
    }

    private String getTreatmentDiagnosisType(IDiagnosisReference invoiceDiagnosis) {
        String name = invoiceDiagnosis.getCodeSystemName();
        if (name != null) {
            if (name.equalsIgnoreCase("freetext")) {
                return "freetext";
            }
            if (name.equalsIgnoreCase("ICD-10")) {
                return "ICD";
            }
            if (name.equalsIgnoreCase("by contract")) {
                return "by_contract";
            }
            if (name.equalsIgnoreCase("ICPC")) {
                return "ICPC";
            }
            if (name.equalsIgnoreCase("birthdefect")) {
                return "birthdefect";
            }
        }
        return "by_contract";
    }

    protected List<IDiagnosisReference> getInvoiceDiagnosis(IInvoice invoice) {
        HashSet<CallSite> seen = new HashSet<CallSite>();
        ArrayList<IDiagnosisReference> ret = new ArrayList<IDiagnosisReference>();
        List encounters = invoice.getEncounters();
        for (IEncounter encounter : encounters) {
            List encounterDiagnosis = encounter.getDiagnoses();
            for (IDiagnosisReference encounterDiagnose : encounterDiagnosis) {
                String dgc = encounterDiagnose.getCode();
                if (dgc == null || !seen.add((CallSite)((Object)(encounterDiagnose.getCode() + encounterDiagnose.getCodeSystemName())))) continue;
                ret.add(encounterDiagnose);
            }
        }
        return ret;
    }

    private String getTreatmentReason(ICoverage coverage) {
        String type = coverage.getReason();
        if (type == null) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_DISEASE)) {
            return "disease";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_ACCIDENT)) {
            return "accident";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_MATERNITY)) {
            return "maternity";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_PREVENTION)) {
            return "prevention";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_BIRTHDEFECT)) {
            return "birthdefect";
        }
        if (type.equalsIgnoreCase(FallConstants.TYPE_OTHER)) {
            return "unknown";
        }
        return "disease";
    }

    protected Object getLawType(IInvoice invoice) throws DatatypeConfigurationException {
        BillingLaw law = invoice.getCoverage().getBillingSystem().getLaw();
        TimeTool caseDate = null;
        if (StringUtils.isNotBlank((CharSequence)((String)invoice.getCoverage().getExtInfo((Object)"Unfalldatum")))) {
            caseDate = new TimeTool((String)invoice.getCoverage().getExtInfo((Object)"Unfalldatum"));
        } else if (invoice.getDateFrom() != null) {
            caseDate = new TimeTool(invoice.getDateFrom());
        }
        if (law == BillingLaw.KVG) {
            KvgLawType kvgLawType = new KvgLawType();
            kvgLawType.setInsuredId(this.getInsuredId(invoice));
            kvgLawType.setCaseId(this.getCaseNumber(invoice));
            kvgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return kvgLawType;
        }
        if (law == BillingLaw.UVG) {
            UvgLawType uvgLawType = new UvgLawType();
            String casenumber = this.getCaseNumber(invoice);
            if (StringTool.isNothing((Object)casenumber)) {
                casenumber = CoverageServiceHolder.get().getRequiredString(invoice.getCoverage(), TarmedRequirements.ACCIDENT_NUMBER);
            }
            if (StringUtils.isNotBlank((CharSequence)casenumber)) {
                uvgLawType.setCaseId(casenumber);
            }
            uvgLawType.setSsn(this.getSSN(invoice));
            uvgLawType.setInsuredId(this.getInsuredId(invoice));
            uvgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return uvgLawType;
        }
        if (law == BillingLaw.IV) {
            IvgLawType ivgLawType = new IvgLawType();
            ivgLawType.setCaseId(this.getCaseNumber(invoice));
            ivgLawType.setSsn(this.getSSN(invoice));
            String nif = TarmedRequirements.getNIF(invoice.getMandator().getBiller()).replaceAll("[^0-9]", "");
            ivgLawType.setNif(nif);
            ivgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return ivgLawType;
        }
        if (law == BillingLaw.MV) {
            MvgLawType mvgLawType = new MvgLawType();
            mvgLawType.setSsn(this.getSSN(invoice));
            mvgLawType.setInsuredId(this.getInsuredId(invoice));
            mvgLawType.setCaseId(this.getCaseNumber(invoice));
            mvgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return mvgLawType;
        }
        if (law == BillingLaw.VVG) {
            VvgLawType vvgLawType = new VvgLawType();
            vvgLawType.setInsuredId(this.getInsuredId(invoice));
            vvgLawType.setCaseId(this.getCaseNumber(invoice));
            vvgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return vvgLawType;
        }
        if (law == BillingLaw.ORG) {
            OrgLawType orgLawType = new OrgLawType();
            orgLawType.setInsuredId(this.getInsuredId(invoice));
            orgLawType.setCaseId(this.getCaseNumber(invoice));
            orgLawType.setCaseDate(XMLExporterUtil.makeXMLDate(caseDate));
            return orgLawType;
        }
        throw new UnsupportedOperationException("Billing law [" + String.valueOf(law) + "] not implemented");
    }

    protected String getCaseNumber(IInvoice invoice) {
        String caseNumber = CoverageServiceHolder.get().getRequiredString(invoice.getCoverage(), TarmedRequirements.CASE_NUMBER);
        return StringUtils.isNotBlank((CharSequence)(caseNumber = caseNumber.replaceAll("[^0-9]", ""))) ? caseNumber : null;
    }

    protected String getInsuredId(IInvoice invoice) {
        String vnummer = CoverageServiceHolder.get().getRequiredString(invoice.getCoverage(), TarmedRequirements.INSURANCE_NUMBER);
        if (StringTool.isNothing((Object)vnummer)) {
            vnummer = CoverageServiceHolder.get().getRequiredString(invoice.getCoverage(), TarmedRequirements.CASE_NUMBER);
        }
        return StringUtils.isNotBlank((CharSequence)vnummer) ? vnummer : null;
    }

    protected String getSSN(IInvoice invoice) {
        String ahv = TarmedRequirements.getAHV((IPerson)invoice.getCoverage().getPatient()).replaceAll("[^0-9]", "");
        if (ahv.length() == 0) {
            ahv = CoverageServiceHolder.get().getRequiredString(invoice.getCoverage(), TarmedRequirements.SSN).replaceAll("[^0-9]", "");
        }
        return StringUtils.isNotBlank((CharSequence)ahv) ? ahv : null;
    }

    protected EsrQRType getEsrQR(IInvoice invoice) {
        EsrQRType esrQRType = new EsrQRType();
        String iban = (String)invoice.getMandator().getBiller().getExtInfo((Object)"IBAN");
        if (StringUtils.isEmpty((CharSequence)iban)) {
            Display.getDefault().syncExec(() -> MessageDialog.openError(null, (String)Messages.XMLExporter_MandatorErrorCaption, (String)(Messages.XMLExporter_MandatorErrorEsr + " [" + invoice.getMandator().getLabel() + "]")));
            return null;
        }
        esrQRType.setIban(iban);
        esrQRType.setReferenceNumber(this.getBesr(invoice).makeRefNr(false));
        String additionalInformation = (String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().RNINFORMATION);
        if (StringUtils.isNotBlank((CharSequence)additionalInformation)) {
            ArrayList<String> lines = new ArrayList<String>(Arrays.asList(additionalInformation.split("\\r?\\n|\\r")));
            int i = 0;
            while (i < lines.size()) {
                String line = (String)lines.get(i);
                if (line.length() > 35) {
                    List<String> parts = XMLExporterUtil.splitStringEqually(line, 35);
                    lines.remove(i);
                    lines.addAll(i, parts);
                }
                ++i;
            }
            i = 0;
            while (i < lines.size() && i < 4) {
                esrQRType.getPaymentReason().add((String)lines.get(i));
                ++i;
            }
        }
        EsrAddressType esrAddressType = this.getEsrCreditor(invoice);
        esrQRType.setCreditor(esrAddressType);
        String bankid = (String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().RNBANK);
        if (StringUtils.isNotBlank((CharSequence)bankid)) {
            Optional bank = CoreModelServiceHolder.get().load(bankid, IOrganization.class);
            bank.ifPresent(b -> {
                EsrAddressType bankEsrAddressType = new EsrAddressType();
                CompanyType bankCompany = this.getCompany((IContact)b, false);
                bankEsrAddressType.setCompany(bankCompany);
                esrQRType.setBank(bankEsrAddressType);
            });
        } else {
            EsrAddressType bankEsrAddressType = new EsrAddressType();
            CompanyType bankCompany = new CompanyType();
            bankCompany.setCompanyname(StringUtils.abbreviate((String)"PostFinance AG", (int)35));
            PostalAddressType postalAddressType = new PostalAddressType();
            postalAddressType.setStreet(StringUtils.abbreviate((String)"Mingerstrasse 20", (int)35));
            postalAddressType.setCity(StringUtils.abbreviate((String)((String)StringUtils.defaultIfBlank((CharSequence)"Bern", (CharSequence)Messages.XMLExporter_Unknown)), (int)35));
            ZipType zipType = new ZipType();
            zipType.setValue(StringUtils.left((String)"3030", (int)9));
            Country country = Country.CH;
            zipType.setCountrycode(StringUtils.left((String)country.toString(), (int)3));
            postalAddressType.setZip(zipType);
            bankCompany.setPostal(postalAddressType);
            bankEsrAddressType.setCompany(bankCompany);
            esrQRType.setBank(bankEsrAddressType);
        }
        return esrQRType;
    }

    private EsrAddressType getEsrCreditor(IInvoice invoice) {
        Optional loadedCreditor;
        IContact creditor = invoice.getMandator().getBiller();
        if (StringUtils.isNotBlank((CharSequence)((String)creditor.getExtInfo((Object)TarmedACL.getInstance().RNACCOUNTOWNER))) && (loadedCreditor = CoreModelServiceHolder.get().load((String)creditor.getExtInfo((Object)TarmedACL.getInstance().RNACCOUNTOWNER), IContact.class)).isPresent()) {
            creditor = (IContact)loadedCreditor.get();
        }
        EsrAddressType esrAddressType = new EsrAddressType();
        Object creditorCompanyOrPerson = this.getCompanyOrPerson(creditor, false);
        if (creditorCompanyOrPerson instanceof CompanyType) {
            esrAddressType.setCompany((CompanyType)creditorCompanyOrPerson);
        } else if (creditorCompanyOrPerson instanceof PersonType) {
            esrAddressType.setPerson((PersonType)creditorCompanyOrPerson);
        }
        return esrAddressType;
    }

    private ESR getBesr(IInvoice invoice) {
        if (this.besr == null) {
            this.besr = new ESR((String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().ESRNUMBER), (String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().ESRSUB), InvoiceServiceHolder.get().getCombinedId(invoice), 27);
        }
        return this.besr;
    }

    protected Esr9Type getEsr9(IInvoice invoice) {
        Esr9Type esr9Type = new Esr9Type();
        String participantNumber = this.getBesr(invoice).makeParticipantNumber(true);
        if (StringUtils.isEmpty((CharSequence)participantNumber)) {
            Display.getDefault().syncExec(() -> MessageDialog.openError(null, (String)Messages.XMLExporter_MandatorErrorCaption, (String)(Messages.XMLExporter_MandatorErrorEsr + " [" + invoice.getMandator().getLabel() + "]")));
            return null;
        }
        esr9Type.setParticipantNumber(participantNumber);
        esr9Type.setType("16or27");
        esr9Type.setReferenceNumber(this.getBesr(invoice).makeRefNr(true));
        String codingline = this.getBesr(invoice).createCodeline(XMLTool.moneyToXmlDouble((Money)invoice.getOpenAmount()).replaceFirst("[.,]", ""), null);
        esr9Type.setCodingLine(codingline);
        EsrAddressType esrAddressType = this.getEsrCreditor(invoice);
        esr9Type.setCreditor(esrAddressType);
        String bankid = (String)invoice.getMandator().getBiller().getExtInfo((Object)TarmedACL.getInstance().RNBANK);
        if (StringUtils.isNotBlank((CharSequence)bankid)) {
            Optional bank = CoreModelServiceHolder.get().load(bankid, IOrganization.class);
            bank.ifPresent(b -> {
                EsrAddressType bankEsrAddressType = new EsrAddressType();
                CompanyType bankCompany = this.getCompany((IContact)b, false);
                bankEsrAddressType.setCompany(bankCompany);
                esr9Type.setBank(bankEsrAddressType);
            });
        }
        return esr9Type;
    }

    protected PrologType getProlog(IInvoice invoice) {
        PrologType prologType = new PrologType();
        SoftwareType softwareType = new SoftwareType();
        softwareType.setName("Elexis");
        VersionInfo vi = new VersionInfo(CoreHub.Version);
        softwareType.setVersion(Long.valueOf(vi.getMaior() + vi.getMinor() + vi.getRevision()));
        prologType.setPackage(softwareType);
        softwareType = new SoftwareType();
        softwareType.setName("JAXB");
        softwareType.setVersion(Long.valueOf(this.getJavaVersion()));
        prologType.setGenerator(softwareType);
        return prologType;
    }

    private int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    protected ProcessingType getProcessing(IInvoice invoice) throws DatatypeConfigurationException {
        ProcessingType processingType = new ProcessingType();
        processingType.setPrintAtIntermediate(Boolean.valueOf(this.printAtIntermediate));
        processingType.setPrintCopyToGuarantor(Boolean.valueOf(CoverageServiceHolder.get().getCopyForPatient(invoice.getCoverage())));
        TransportType transportType = new TransportType();
        if (invoice.getMandator().getBiller() != null) {
            transportType.setFrom(TarmedRequirements.getEAN(invoice.getMandator().getBiller()));
        } else {
            transportType.setFrom(TarmedRequirements.getEAN((IContact)invoice.getMandator()));
        }
        transportType.setTo(XMLExporterUtil.getRecipientEAN(invoice));
        logger.info("Using intermediate EAN [" + XMLExporterUtil.getIntermediateEAN(invoice) + "]");
        TransportType.Via via = new TransportType.Via();
        via.setVia(XMLExporterUtil.getIntermediateEAN(invoice));
        via.setSequenceId(1);
        transportType.getVia().add(via);
        if (TarmedRequirements.hasTCContract((IContact)invoice.getMandator())) {
            processingType.setPrintAtIntermediate(Boolean.valueOf(true));
            ICoverageService.Tiers tiersType = CoverageServiceHolder.get().getTiersType(invoice.getCoverage());
            if (ICoverageService.Tiers.GARANT == tiersType) {
                String tcCode = TarmedRequirements.getTCCode((IContact)invoice.getMandator());
                ProcessingType.Demand demand = new ProcessingType.Demand();
                demand.setTcDemandId(0L);
                String tcToken = this.getBesr(invoice).createCodeline(XMLTool.moneyToXmlDouble((Money)invoice.getOpenAmount()).replaceFirst("[.,]", ""), tcCode);
                demand.setTcToken(tcToken);
                demand.setInsuranceDemandDate(XMLExporterUtil.makeXMLDate(invoice.getDate()));
                processingType.setDemand(demand);
            }
        }
        processingType.setTransport(transportType);
        return processingType;
    }

    public void updateExistingXml(RequestType request, IRnOutputter.TYPE type, IInvoice invoice, XMLExporter xmlExporter) {
        try {
            this.besr = null;
            if (request.getProcessing() != null) {
                if (request.getProcessing().isPrintAtIntermediate() != this.isPrintAtIntermediate()) {
                    request.getProcessing().setPrintAtIntermediate(Boolean.valueOf(this.isPrintAtIntermediate()));
                }
                if (request.getProcessing().getTransport() != null) {
                    String iEAN = XMLExporterProcessing.getIntermediateEAN(invoice, xmlExporter);
                    List via = request.getProcessing().getTransport().getVia();
                    if (via != null && !via.isEmpty()) {
                        ((TransportType.Via)via.get(0)).setVia(iEAN);
                    }
                }
                if (TarmedRequirements.hasTCContract((IContact)invoice.getMandator())) {
                    request.getProcessing().setPrintAtIntermediate(Boolean.valueOf(true));
                }
                if (request.getPayload().getReminder() != null) {
                    request.getProcessing().setPrintCopyToGuarantor(Boolean.valueOf(false));
                } else {
                    request.getProcessing().setPrintCopyToGuarantor(Boolean.valueOf(CoverageServiceHolder.get().getCopyForPatient(invoice.getCoverage())));
                }
            }
            if (request.getPayload() != null && request.getPayload().getBody() != null) {
                if (type != IRnOutputter.TYPE.STORNO) {
                    TreatmentType updateTreatment = this.getTreatment(invoice);
                    if (updateTreatment != null) {
                        request.getPayload().getBody().setTreatment(updateTreatment);
                    }
                    if (this.esrType == EsrType.esr9 && request.getPayload().getBody().getEsrQR() != null) {
                        request.getPayload().getBody().setEsrQR(null);
                        request.getPayload().getBody().setEsr9(this.getEsr9(invoice));
                    } else if (this.esrType == EsrType.esrQR && request.getPayload().getBody().getEsr9() != null) {
                        request.getPayload().getBody().setEsrQR(this.getEsrQR(invoice));
                        request.getPayload().getBody().setEsr9(null);
                    }
                    if (request.getPayload().getBody().getTiersGarant() != null && invoice.getCoverage().getPatient() != null) {
                        EsrAddressType creditor;
                        BillerAddressType updateBiller;
                        ProviderAddressType updateProvider;
                        InsuranceAddressType updateInsurance;
                        DebitorAddressType updateDebitor;
                        updatePatient = this.getPatient(invoice);
                        if (updatePatient != null) {
                            request.getPayload().getBody().getTiersGarant().setPatient(updatePatient);
                        }
                        if ((updateGuarantor = this.getGuarantor(invoice)) != null) {
                            request.getPayload().getBody().getTiersGarant().setGuarantor(updateGuarantor);
                        }
                        if ((updateDebitor = this.getDebitor(invoice)) != null) {
                            request.getPayload().getBody().getTiersGarant().setDebitor(updateDebitor);
                        }
                        if ((updateInsurance = this.getInsurance(invoice)) != null) {
                            request.getPayload().getBody().getTiersGarant().setInsurance(updateInsurance);
                        }
                        if ((updateProvider = this.getProvider(invoice)) != null) {
                            request.getPayload().getBody().getTiersGarant().setProvider(updateProvider);
                        }
                        if ((updateBiller = this.getBiller(invoice)) != null) {
                            request.getPayload().getBody().getTiersGarant().setBiller(updateBiller);
                        }
                        if ((creditor = this.getEsrCreditor(invoice)) != null) {
                            if (request.getPayload().getBody().getEsrQR() != null) {
                                request.getPayload().getBody().getEsrQR().setCreditor(creditor);
                            } else if (request.getPayload().getBody().getEsr9() != null) {
                                request.getPayload().getBody().getEsr9().setCreditor(creditor);
                            }
                        }
                    } else if (request.getPayload().getBody().getTiersPayant() != null && invoice.getCoverage().getPatient() != null) {
                        EsrAddressType creditor;
                        BillerAddressType updateBiller;
                        ProviderAddressType updateProvider;
                        InsuranceAddressType updateInsurance;
                        DebitorAddressType updateDebitor;
                        updatePatient = this.getPatient(invoice);
                        if (updatePatient != null) {
                            request.getPayload().getBody().getTiersPayant().setPatient(updatePatient);
                        }
                        if ((updateGuarantor = this.getGuarantor(invoice)) != null) {
                            request.getPayload().getBody().getTiersPayant().setGuarantor(updateGuarantor);
                        }
                        if ((updateDebitor = this.getDebitor(invoice)) != null) {
                            request.getPayload().getBody().getTiersPayant().setDebitor(updateDebitor);
                        }
                        if ((updateInsurance = this.getInsurance(invoice)) != null) {
                            request.getPayload().getBody().getTiersPayant().setInsurance(updateInsurance);
                        }
                        if ((updateProvider = this.getProvider(invoice)) != null) {
                            request.getPayload().getBody().getTiersPayant().setProvider(updateProvider);
                        }
                        if ((updateBiller = this.getBiller(invoice)) != null) {
                            request.getPayload().getBody().getTiersPayant().setBiller(updateBiller);
                        }
                        if ((creditor = this.getEsrCreditor(invoice)) != null) {
                            if (request.getPayload().getBody().getEsrQR() != null) {
                                request.getPayload().getBody().getEsrQR().setCreditor(creditor);
                            } else if (request.getPayload().getBody().getEsr9() != null) {
                                request.getPayload().getBody().getEsr9().setCreditor(creditor);
                            }
                        }
                    }
                    Object updateBalance = this.getBalance(invoice);
                    if (request.getPayload().getBody().getTiersGarant() != null && updateBalance instanceof BalanceTGType) {
                        balance = request.getPayload().getBody().getTiersGarant().getBalance();
                        if (((BalanceTGType)updateBalance).getAmountPrepaid() != balance.getAmountPrepaid()) {
                            request.getPayload().getBody().getTiersGarant().setBalance((BalanceTGType)updateBalance);
                        } else if (((BalanceTGType)updateBalance).getAmountObligations() != balance.getAmountObligations()) {
                            balance.setAmountObligations(Double.valueOf(((BalanceTGType)updateBalance).getAmountObligations()));
                        }
                    } else if (request.getPayload().getBody().getTiersPayant() != null && updateBalance instanceof BalanceTPType) {
                        balance = request.getPayload().getBody().getTiersPayant().getBalance();
                        if (((BalanceTPType)updateBalance).getAmountDue() != balance.getAmountDue()) {
                            request.getPayload().getBody().getTiersPayant().setBalance((BalanceTPType)updateBalance);
                        } else if (((BalanceTPType)updateBalance).getAmountObligations() != balance.getAmountObligations()) {
                            balance.setAmountObligations(Double.valueOf(((BalanceTPType)updateBalance).getAmountObligations()));
                        }
                    }
                }
                request.getPayload().setCopy(Boolean.valueOf(type.equals((Object)IRnOutputter.TYPE.COPY)));
                if (StringUtils.isNotBlank((CharSequence)invoice.getRemark())) {
                    request.getPayload().getBody().setRemark(invoice.getRemark());
                } else {
                    request.getPayload().getBody().setRemark(null);
                }
                if (type.equals((Object)IRnOutputter.TYPE.STORNO)) {
                    request.getPayload().setStorno(Boolean.valueOf(true));
                    request.getProcessing().setPrintCopyToGuarantor(Boolean.valueOf(false));
                    this.negate(request.getPayload().getBody().getServices());
                    if (request.getPayload().getBody().getTiersGarant() != null) {
                        balance = request.getPayload().getBody().getTiersGarant().getBalance();
                        balance.setAmount(-Math.abs(balance.getAmount()));
                        balance.setAmountObligations(Double.valueOf(-Math.abs(balance.getAmountObligations())));
                        balance.setAmountDue(0.0);
                        balance.setAmountPrepaid(Double.valueOf(0.0));
                        balance.getVat().setVat(0.0);
                        balance.getVat().getVatRate().forEach(vr -> {
                            vr.setAmount(-Math.abs(vr.getAmount()));
                            vr.setVat(-Math.abs(vr.getVat()));
                        });
                    } else if (request.getPayload().getBody().getTiersPayant() != null) {
                        balance = request.getPayload().getBody().getTiersPayant().getBalance();
                        balance.setAmount(-Math.abs(balance.getAmount()));
                        balance.setAmountObligations(Double.valueOf(-Math.abs(balance.getAmountObligations())));
                        balance.setAmountDue(0.0);
                        balance.getVat().setVat(0.0);
                        balance.getVat().getVatRate().forEach(vr -> {
                            vr.setAmount(-Math.abs(vr.getAmount()));
                            vr.setVat(-Math.abs(vr.getVat()));
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error updating tarmed xml model", (Throwable)e);
        }
    }

    public void addReminderEntry(RequestType request, IInvoice invoice, String reminderLevel) {
        if (request.getPayload() != null) {
            try {
                if (request.getProcessing() != null) {
                    request.getProcessing().setPrintCopyToGuarantor(Boolean.valueOf(false));
                }
                GregorianCalendar now = new GregorianCalendar();
                ReminderType reminderType = request.getPayload().getReminder();
                if (reminderType == null) {
                    reminderType = new ReminderType();
                    request.getPayload().setReminder(reminderType);
                    request.getPayload().setType("reminder");
                }
                reminderType.setRequestId(InvoiceServiceHolder.get().getCombinedId(invoice));
                reminderType.setReminderLevel(reminderLevel);
                reminderType.setRequestDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(now));
                reminderType.setRequestTimestamp((int)(now.getTimeInMillis() / 1000L));
                if (request.getPayload().getBody() != null) {
                    Money mReminder = invoice.getDemandAmount();
                    Money mDue = new Money(invoice.getTotalAmount());
                    mDue.addMoney(mReminder);
                    mDue.subtractMoney(invoice.getPayedAmount());
                    if (request.getPayload().getBody().getTiersGarant() != null) {
                        BalanceTGType balance = request.getPayload().getBody().getTiersGarant().getBalance();
                        balance.setAmountReminder(Double.valueOf(mReminder.doubleValue()));
                        balance.setAmountDue(mDue.doubleValue());
                    } else if (request.getPayload().getBody().getTiersPayant() != null) {
                        BalanceTPType balance = request.getPayload().getBody().getTiersPayant().getBalance();
                        balance.setAmountReminder(Double.valueOf(mReminder.doubleValue()));
                        balance.setAmountDue(mDue.doubleValue());
                    }
                }
            }
            catch (DatatypeConfigurationException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error adding reminder to xml model", (Throwable)e);
            }
        }
    }

    public void removeReminderEntry(RequestType request, IInvoice invoice) {
        if (request.getPayload() != null && request.getPayload().getReminder() != null) {
            request.getPayload().setReminder(null);
            request.getPayload().setType("invoice");
            request.getProcessing().setPrintCopyToGuarantor(Boolean.valueOf(CoverageServiceHolder.get().getCopyForPatient(invoice.getCoverage())));
        }
    }

    public boolean isReminder(RequestType request) {
        return request.getPayload() != null && (request.getPayload().getReminder() != null || "reminder".equalsIgnoreCase(request.getPayload().getType()));
    }

    private void negate(ServicesType services) {
        if (services != null) {
            services.getServiceExOrService().forEach(s -> {
                if (s instanceof ServiceType) {
                    ((ServiceType)s).setQuantity(-Math.abs(((ServiceType)s).getQuantity()));
                    ((ServiceType)s).setAmount(-Math.abs(((ServiceType)s).getAmount()));
                } else if (s instanceof ServiceExType) {
                    ((ServiceExType)s).setQuantity(-Math.abs(((ServiceExType)s).getQuantity()));
                    ((ServiceExType)s).setAmount(-Math.abs(((ServiceExType)s).getAmount()));
                    ((ServiceExType)s).setAmountMt(Double.valueOf(-Math.abs(((ServiceExType)s).getAmountMt())));
                    ((ServiceExType)s).setAmountTt(Double.valueOf(-Math.abs(((ServiceExType)s).getAmountTt())));
                }
            });
        }
    }

    public void setUpdateElectronicDelivery(boolean value) {
        this.updateElectronicDelivery = value;
    }

    private void updateElectronicDelivery(IInvoice invoice, RequestType invoiceRequest) {
        BillingLaw law = invoice.getCoverage().getBillingSystem().getLaw();
        if (law == BillingLaw.KVG && this.isCopyToPatient(invoiceRequest) && this.isNoElectronicDelivery(invoice)) {
            if (invoiceRequest.getPayload().getBody().getTiersGarant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor() != null) {
                    DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersGarant().getDebitor();
                    this.setTelcomNull(debitor);
                    this.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getPatient() != null) {
                    PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersGarant().getPatient();
                    this.setTelcomNull(patient);
                    this.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor() != null) {
                    GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersGarant().getGuarantor();
                    this.setTelcomNull(guarantor);
                    this.setOnlineNull(guarantor);
                }
            } else if (invoiceRequest.getPayload().getBody().getTiersPayant() != null) {
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor() != null) {
                    DebitorAddressType debitor = invoiceRequest.getPayload().getBody().getTiersPayant().getDebitor();
                    this.setTelcomNull(debitor);
                    this.setOnlineNull(debitor);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getPatient() != null) {
                    PatientAddressType patient = invoiceRequest.getPayload().getBody().getTiersPayant().getPatient();
                    this.setTelcomNull(patient);
                    this.setOnlineNull(patient);
                }
                if (invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor() != null) {
                    GuarantorAddressType guarantor = invoiceRequest.getPayload().getBody().getTiersPayant().getGuarantor();
                    this.setTelcomNull(guarantor);
                    this.setOnlineNull(guarantor);
                }
            }
        }
    }

    private void setOnlineNull(GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setOnline(null);
        }
    }

    private void setTelcomNull(GuarantorAddressType guarantor) {
        if (guarantor.getPerson() != null) {
            guarantor.getPerson().setTelecom(null);
        }
    }

    private void setOnlineNull(DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setOnline(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setOnline(null);
        }
    }

    private void setTelcomNull(DebitorAddressType debitor) {
        if (debitor.getCompany() != null) {
            debitor.getCompany().setTelecom(null);
        } else if (debitor.getPerson() != null) {
            debitor.getPerson().setTelecom(null);
        }
    }

    private void setOnlineNull(PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setOnline(null);
        }
    }

    private void setTelcomNull(PatientAddressType patient) {
        if (patient.getPerson() != null) {
            patient.getPerson().setTelecom(null);
        }
    }

    private boolean isCopyToPatient(RequestType invoiceRequest) {
        if (invoiceRequest.getProcessing() != null) {
            return invoiceRequest.getProcessing().isPrintCopyToGuarantor();
        }
        return false;
    }

    private boolean isNoElectronicDelivery(IInvoice invoice) {
        if (invoice.getCoverage() != null) {
            return "1".equals(invoice.getCoverage().getExtInfo((Object)"NoElectronicDelivery"));
        }
        return false;
    }

    public static enum EsrType {
        esr9,
        esrQR;

    }
}

