/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.dialog.GenericSelectionDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.tarmedprefs.Messages;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SectionCodeComposite
extends Composite {
    private IMandator mandator;
    private Label label;
    @Inject
    private ICodingService codingService;

    public SectionCodeComposite(Composite parent, int style) {
        super(parent, style);
        CoreUiUtil.injectServices((Object)((Object)this));
        this.setLayout((Layout)new GridLayout(1, false));
        Composite listComposite = new Composite((Composite)this, 0);
        GridData gdList = new GridData(4, 128, true, false);
        listComposite.setLayoutData((Object)gdList);
        GridLayout listLayout = new GridLayout(2, false);
        listLayout.marginWidth = 0;
        listLayout.horizontalSpacing = 10;
        listComposite.setLayout((Layout)listLayout);
        GridData gdLeft = new GridData(4, 128, false, false);
        this.label = new Label(listComposite, 64);
        this.label.setLayoutData((Object)gdLeft);
    }

    public void openSelectionDialog() {
        if (this.mandator == null || this.codingService == null) {
            return;
        }
        List codes = this.codingService.getAvailableCodes("forumdatenaustausch_sectioncode");
        GenericSelectionDialog gsd = new GenericSelectionDialog(this.getShell(), codes, Messages.SectionCodeComposite_selectSectionCodeTitle, "");
        gsd.setLabelProvider(new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getCode() + " - " + ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        ArzttarifeUtil.getMandantSectionCode((IMandator)this.mandator).ifPresent(c -> gsd.setSelection(Collections.singletonList(c)));
        if (gsd.open() == 0) {
            IStructuredSelection selection = gsd.getSelection();
            ArzttarifeUtil.setMandantSectionCode((IMandator)this.mandator, (ICoding)((ICoding)selection.getFirstElement()));
            CoreModelServiceHolder.get().save((Identifiable)this.mandator);
            this.updateUi();
        }
    }

    public void dispose() {
        CoreUiUtil.uninjectServices((Object)((Object)this));
        super.dispose();
    }

    public void setMandator(IMandator mandator) {
        this.mandator = mandator;
        this.updateUi();
    }

    private void updateUi() {
        Optional sectionCode = ArzttarifeUtil.getMandantSectionCode((IMandator)this.mandator);
        if (sectionCode.isPresent()) {
            this.label.setText(((ICoding)sectionCode.get()).getCode() + " - " + ((ICoding)sectionCode.get()).getDisplay());
        } else {
            this.label.setText("");
        }
        this.layout(true, true);
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.relayoutScrolledParent();
                }
            });
        }
    }

    private void relayoutScrolledParent() {
        SectionCodeComposite p = this;
        while (p != null && !p.isDisposed()) {
            if (p instanceof ScrolledComposite) {
                ScrolledComposite sc = (ScrolledComposite)p;
                Control ctrl = sc.getContent();
                if (ctrl == null || ctrl.isDisposed() || !(ctrl instanceof Composite)) break;
                Composite content = (Composite)ctrl;
                content.layout(true, true);
                sc.setMinSize(content.computeSize(-1, -1));
                break;
            }
            p = p.getParent();
        }
    }
}

