/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.tools.StringTool;
import org.jdom2.Element;

public class XMLExporterInsurance {
    private static final String ATTR_CASE_ID = "case_id";
    private Element insuranceElement;

    private XMLExporterInsurance(Element insuranceElement) {
        this.insuranceElement = insuranceElement;
    }

    public Element getElement() {
        return this.insuranceElement;
    }

    public static XMLExporterInsurance buildInsurance(IInvoice invoice, XMLExporter xmlExporter) {
        ICoverage coverage = invoice.getCoverage();
        IPatient patient = coverage.getPatient();
        IMandator mandator = invoice.getMandator();
        String gesetz = TarmedRequirements.getGesetz(coverage);
        Element element = new Element(gesetz.toLowerCase(), XMLExporter.nsinvoice);
        if (gesetz.equalsIgnoreCase("ivg")) {
            String caseNumber = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.CASE_NUMBER);
            if (!((caseNumber = caseNumber.replaceAll("[^0-9]", "")).matches("[0-9]{14}") || caseNumber.matches("[0-9]{10}") || caseNumber.matches("[0-9]{9}") || caseNumber.matches("[0-9]{6}"))) {
                if (ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true)) {
                    invoice.reject(InvoiceState.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_IVCaseNumberInvalid);
                    CoreModelServiceHolder.get().save((Identifiable)invoice);
                } else {
                    caseNumber = "123456";
                }
            }
            element.setAttribute(ATTR_CASE_ID, caseNumber);
            XMLExporterUtil.addSSNAttribute(element, patient, coverage, invoice, false);
            String nif = TarmedRequirements.getNIF(mandator.getBiller()).replaceAll("[^0-9]", "");
            if (ConfigServiceHolder.getUser((String)"billing/strict", (boolean)true) && !nif.matches("[0-9]{1,7}")) {
                invoice.reject(InvoiceState.REJECTCODE.VALIDATION_ERROR, Messages.XMLExporter_NIFInvalid);
                CoreModelServiceHolder.get().save((Identifiable)invoice);
            } else {
                element.setAttribute("nif", nif);
            }
        } else if (gesetz.equalsIgnoreCase("mvg")) {
            XMLExporterUtil.addSSNAttribute(element, patient, coverage, invoice, false);
            XMLExporterInsurance.addInsuredId(element, patient, coverage);
        } else if (gesetz.equalsIgnoreCase("uvg")) {
            String casenumber = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.CASE_NUMBER);
            if (StringTool.isNothing((Object)casenumber)) {
                casenumber = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.ACCIDENT_NUMBER);
            }
            if (!StringTool.isNothing((Object)casenumber)) {
                element.setAttribute(ATTR_CASE_ID, casenumber);
            }
            XMLExporterUtil.addSSNAttribute(element, patient, coverage, invoice, true);
            XMLExporterInsurance.addInsuredId(element, patient, coverage);
        } else {
            XMLExporterInsurance.addInsuredId(element, patient, coverage);
        }
        String casedate = (String)coverage.getExtInfo((Object)"Unfalldatum");
        if (StringTool.isNothing((Object)casedate)) {
            element.setAttribute("case_date", XMLExporterUtil.makeTarmedDatum(invoice.getDateFrom()));
        } else {
            element.setAttribute("case_date", XMLExporterUtil.makeTarmedDatum(casedate));
        }
        XMLExporterUtil.setAttributeIfNotEmpty(element, "contract_number", (String)coverage.getExtInfo((Object)"Vertragsnummer"));
        return new XMLExporterInsurance(element);
    }

    private static void addInsuredId(Element element, IPatient patient, ICoverage coverage) {
        String vnummer = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.INSURANCE_NUMBER);
        if (StringTool.isNothing((Object)vnummer)) {
            vnummer = CoverageServiceHolder.get().getRequiredString(coverage, TarmedRequirements.CASE_NUMBER);
        }
        if (StringTool.isNothing((Object)vnummer)) {
            vnummer = patient.getId();
        }
        element.setAttribute("insured_id", vnummer);
    }
}

