/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.ICodingService;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.e4.dialog.GenericSelectionDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.tarmedprefs.Messages;
import jakarta.inject.Inject;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TardocSpecialistComposite
extends Composite {
    private IMandator mandator;
    private Label leftLabel;
    private Label rightLabel;
    @Inject
    private ICodingService codingService;

    public TardocSpecialistComposite(Composite parent, int style) {
        super(parent, style);
        CoreUiUtil.injectServices((Object)((Object)this));
        this.setLayout((Layout)new GridLayout(1, false));
        Composite listComposite = new Composite((Composite)this, 0);
        GridData gdList = new GridData(4, 128, true, false);
        listComposite.setLayoutData((Object)gdList);
        GridLayout listLayout = new GridLayout(2, false);
        listLayout.marginWidth = 0;
        listLayout.horizontalSpacing = 10;
        listComposite.setLayout((Layout)listLayout);
        GridData gdLeft = new GridData(1, 128, false, false);
        this.leftLabel = new Label(listComposite, 64);
        this.leftLabel.setLayoutData((Object)gdLeft);
        GridData gdRight = new GridData(4, 128, true, false);
        this.rightLabel = new Label(listComposite, 64);
        this.rightLabel.setLayoutData((Object)gdRight);
    }

    public void openSelectionDialog() {
        if (this.mandator == null || this.codingService == null) {
            return;
        }
        List codes = this.codingService.getAvailableCodes("tardoc_dignitaet");
        GenericSelectionDialog gsd = new GenericSelectionDialog(this.getShell(), codes, Messages.TardocSpecialistComposite_selectDignitiesTitle, "");
        gsd.setLabelProvider(new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICoding) {
                    return ((ICoding)element).getCode() + " - " + ((ICoding)element).getDisplay();
                }
                return super.getText(element);
            }
        });
        gsd.setSelection(ArzttarifeUtil.getMandantTardocSepcialist((IMandator)this.mandator));
        if (gsd.open() == 0) {
            IStructuredSelection selection = gsd.getSelection();
            ArzttarifeUtil.setMandantTardocSepcialist((IMandator)this.mandator, (List)selection.toList());
            CoreModelServiceHolder.get().save((Identifiable)this.mandator);
            this.updateUi();
        }
    }

    public void dispose() {
        CoreUiUtil.uninjectServices((Object)((Object)this));
        super.dispose();
    }

    public void setMandator(IMandator mandator) {
        this.mandator = mandator;
        this.updateUi();
    }

    private void updateUi() {
        List specialist = ArzttarifeUtil.getMandantTardocSepcialist((IMandator)this.mandator);
        specialist.sort(Comparator.comparingInt(c -> {
            try {
                return Integer.parseInt(c.getCode().replaceAll("\\D", ""));
            }
            catch (NumberFormatException e) {
                return Integer.MAX_VALUE;
            }
        }));
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        int size = specialist.size();
        int mid = (size + 1) / 2;
        int i = 0;
        while (i < size) {
            StringBuilder target;
            ICoding c2 = (ICoding)specialist.get(i);
            StringBuilder stringBuilder = target = i < mid ? left : right;
            if (target.length() > 0) {
                target.append(System.lineSeparator());
            }
            target.append("- ").append(c2.getCode()).append(" - ").append(c2.getDisplay());
            ++i;
        }
        this.leftLabel.setText(left.toString());
        this.rightLabel.setText(right.toString());
        this.layout(true, true);
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(() -> {
                if (!this.isDisposed()) {
                    this.relayoutScrolledParent();
                }
            });
        }
    }

    private void relayoutScrolledParent() {
        TardocSpecialistComposite p = this;
        while (p != null && !p.isDisposed()) {
            if (p instanceof ScrolledComposite) {
                ScrolledComposite sc = (ScrolledComposite)p;
                Control ctrl = sc.getContent();
                if (ctrl == null || ctrl.isDisposed() || !(ctrl instanceof Composite)) break;
                Composite content = (Composite)ctrl;
                content.layout(true, true);
                sc.setMinSize(content.computeSize(-1, -1));
                break;
            }
            p = p.getParent();
        }
    }
}

