/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.ui.handler;

import ch.elexis.TarmedRechnung.TarmedACL;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.utils.CoreUtil;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.LoggerFactory;

@Component(property={"event.topics=org/eclipse/e4/ui/LifeCycle/appStartupComplete"})
public class StartupHandler
implements EventHandler {
    private static String CFG_UPDATE_BILLINGSYSTEMS_2026 = "ch.elexis.base.ch.arzttarife.billingsystems.2026";
    private static String PROP_UPDATE_BILLINGSYSTEMS_2026 = "/rsc/billingsystemfactor2026.properties";

    public void handleEvent(Event event) {
        LoggerFactory.getLogger(this.getClass()).info("APPLICATION STARTUP COMPLETE");
        if (!CoreUtil.isTestMode() && !this.isUpdateExecuted(CFG_UPDATE_BILLINGSYSTEMS_2026) && this.getClass().getResourceAsStream(PROP_UPDATE_BILLINGSYSTEMS_2026) != null) {
            CompletableFuture.runAsync(() -> {
                try {
                    Properties billingsystems2026 = new Properties();
                    billingsystems2026.load(this.getClass().getResourceAsStream(PROP_UPDATE_BILLINGSYSTEMS_2026));
                    Optional<String> kanton = this.getKanton();
                    List billingSystemFactors = CoreModelServiceHolder.get().getQuery(IBillingSystemFactor.class).execute();
                    LocalDate validFrom = LocalDate.of(2026, 1, 1);
                    for (IBillingSystemFactor billingSystemFactor : billingSystemFactors) {
                        if (billingSystemFactor.getValidTo().isBefore(validFrom) || billingSystemFactor.getSystem() == null) continue;
                        if (this.isMatchingLaw(billingSystemFactor, BillingLaw.UVG)) {
                            this.updateBillingSystemFactor(billingSystemFactor, null, BillingLaw.UVG, validFrom, billingsystems2026);
                            continue;
                        }
                        if (this.isMatchingLaw(billingSystemFactor, BillingLaw.IV)) {
                            this.updateBillingSystemFactor(billingSystemFactor, null, BillingLaw.IV, validFrom, billingsystems2026);
                            continue;
                        }
                        if (this.isMatchingLaw(billingSystemFactor, BillingLaw.MV)) {
                            this.updateBillingSystemFactor(billingSystemFactor, null, BillingLaw.MV, validFrom, billingsystems2026);
                            continue;
                        }
                        if (this.isMatchingLaw(billingSystemFactor, BillingLaw.VVG)) {
                            this.updateBillingSystemFactor(billingSystemFactor, null, BillingLaw.VVG, validFrom, billingsystems2026);
                            continue;
                        }
                        if (this.isMatchingLaw(billingSystemFactor, BillingLaw.ORG)) {
                            this.updateBillingSystemFactor(billingSystemFactor, null, BillingLaw.ORG, validFrom, billingsystems2026);
                            continue;
                        }
                        if (!this.isMatchingLaw(billingSystemFactor, BillingLaw.KVG)) continue;
                        this.updateBillingSystemFactor(billingSystemFactor, kanton.orElse(null), BillingLaw.KVG, validFrom, billingsystems2026);
                    }
                    this.setUpdateExecuted(CFG_UPDATE_BILLINGSYSTEMS_2026);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error updating billingsystems", (Throwable)e);
                }
            });
        }
    }

    private boolean isMatchingLaw(IBillingSystemFactor billingSystemFactor, BillingLaw law) {
        if (law == BillingLaw.IV) {
            return billingSystemFactor.getSystem().toUpperCase().startsWith(law.name()) || billingSystemFactor.getSystem().toUpperCase().endsWith(law.name()) || billingSystemFactor.getSystem().toUpperCase().startsWith("IVG") || billingSystemFactor.getSystem().toUpperCase().endsWith("IVG");
        }
        if (law == BillingLaw.MV) {
            return billingSystemFactor.getSystem().toUpperCase().startsWith(law.name()) || billingSystemFactor.getSystem().toUpperCase().endsWith(law.name()) || billingSystemFactor.getSystem().toUpperCase().startsWith("MVG") || billingSystemFactor.getSystem().toUpperCase().endsWith("MVG");
        }
        return billingSystemFactor.getSystem().toUpperCase().startsWith(law.name()) || billingSystemFactor.getSystem().toUpperCase().endsWith(law.name());
    }

    private boolean isUpdateExecuted(String string) {
        return ConfigServiceHolder.get().get(string, false);
    }

    private boolean setUpdateExecuted(String string) {
        return ConfigServiceHolder.get().set(string, true);
    }

    private void updateBillingSystemFactor(IBillingSystemFactor billingSystemFactor, String kanton, BillingLaw law, LocalDate validFrom, Properties billingFactors) {
        Double newValue;
        LocalDate currentEnd = billingSystemFactor.getValidTo();
        double currentValue = billingSystemFactor.getFactor();
        String propertyName = this.getPropertyName(law, kanton);
        if (StringUtils.isNotBlank((CharSequence)propertyName) && currentValue != (newValue = Double.valueOf((String)billingFactors.get(propertyName)))) {
            if (currentEnd.isAfter(validFrom)) {
                LoggerFactory.getLogger(this.getClass()).info("Update BillingSystemFactor [" + billingSystemFactor.getSystem() + "] [" + currentValue + " -> " + String.valueOf(newValue) + "]");
                IBillingSystemFactor newBillingSystemFactor = (IBillingSystemFactor)CoreModelServiceHolder.get().create(IBillingSystemFactor.class);
                newBillingSystemFactor.setFactor(newValue.doubleValue());
                newBillingSystemFactor.setSystem(billingSystemFactor.getSystem());
                newBillingSystemFactor.setValidFrom(validFrom);
                newBillingSystemFactor.setValidTo(LocalDate.of(9999, 12, 31));
                CoreModelServiceHolder.get().save((Identifiable)newBillingSystemFactor);
                billingSystemFactor.setValidTo(validFrom.minusDays(1L));
                CoreModelServiceHolder.get().save((Identifiable)billingSystemFactor);
            } else {
                LoggerFactory.getLogger(this.getClass()).info("BillingSystemFactor [" + billingSystemFactor.getSystem() + "] already correct");
            }
        }
    }

    private String getPropertyName(BillingLaw law, String kanton) {
        if (law == BillingLaw.KVG) {
            if (StringUtils.isBlank((CharSequence)kanton)) {
                LoggerFactory.getLogger(this.getClass()).warn("No Kanton for KVG");
                return "";
            }
            return String.valueOf(law) + "_" + kanton.toUpperCase();
        }
        return law.name().toUpperCase();
    }

    private Optional<String> getKanton() {
        HashSet<String> kanton = new HashSet<String>();
        List mandators = CoreModelServiceHolder.get().getQuery(IMandator.class).execute();
        for (IMandator mandator : mandators) {
            if (!StringUtils.isNotBlank((CharSequence)((String)mandator.getExtInfo((Object)TarmedACL.getInstance().KANTON)))) continue;
            kanton.add((String)mandator.getExtInfo((Object)TarmedACL.getInstance().KANTON));
        }
        if (!kanton.isEmpty()) {
            if (kanton.size() == 1) {
                return Optional.of((String)kanton.stream().findFirst().get());
            }
            LoggerFactory.getLogger(this.getClass()).warn("More than one kanton found " + Arrays.toString(kanton.toArray()));
        }
        return Optional.empty();
    }
}

