/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.base.ch.arzttarife.importer.TrustCenters;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.tarmedprefs.Messages;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarmedRequirements {
    public static final String INSURANCE_NUMBER = Messages.TarmedRequirements_InsuranceNumberName;
    public static final String CASE_NUMBER = Messages.TarmedRequirements_CaseNumberName;
    public static final String INTERMEDIATE = Messages.TarmedRequirements_IntermediateName;
    public static final String ACCIDENT_NUMBER = Messages.TarmedRequirements_AccidentNumberName;
    public static final String SSN = Messages.TarmedRequirements_SSNName;
    public static final String EAN_PSEUDO = "2000000000000";
    public static final String EAN_PROVIDER = "ean_provider";
    public static final String EAN_RESPONSIBLE = "ean_responsible";
    public static final String EAN_PATTERN = "[0-9]{13}";
    public static final String ACCIDENT_DATE = Messages.TarmedRequirements_AccidentDate;
    public static final String CASE_LAW = Messages.TarmedRequirements_Law;
    public static final String BILLINGSYSTEM_NAME = "TarmedLeistung";
    public static final String OUTPUTTER_NAME = "Tarmed-Drucker";
    public static final String DOMAIN_KSK = "www.xid.ch/id/ksk";
    public static final String DOMAIN_NIF = "www.xid.ch/id/nif";
    public static final String DOMAIN_SUVA = "www.xid.ch/id/suva";
    public static final String RESPONSIBLE_INFO_KEY = "ch.elexis.tarmedprefs.responsible";
    private static Logger logger = LoggerFactory.getLogger(TarmedRequirements.class);

    public static String getEAN(IContact contact) {
        if (contact == null) {
            return null;
        }
        IXid xid = contact.getXid("www.xid.ch/id/ean");
        if (xid == null) {
            if (contact.getExtInfo((Object)"EAN") instanceof String && StringUtils.isNotBlank((CharSequence)((String)contact.getExtInfo((Object)"EAN")))) {
                TarmedRequirements.setEAN(contact, (String)contact.getExtInfo((Object)"EAN"));
                xid = contact.getXid("www.xid.ch/id/ean");
            }
        } else if (StringUtils.isEmpty((CharSequence)xid.getDomainId())) {
            LoggerFactory.getLogger(TarmedRequirements.class).warn("Removing empty EAN Xid of [" + contact.getId() + "]");
            CoreModelServiceHolder.get().remove((Identifiable)xid);
            xid = null;
        }
        if (xid != null && xid.getDomainId() != null && !xid.getDomainId().isEmpty()) {
            return xid.getDomainId().trim();
        }
        if (xid == null) {
            return EAN_PSEUDO;
        }
        return "";
    }

    public static String getRecipientEAN(IContact contact) {
        if (contact == null) {
            return null;
        }
        IXid ret = contact.getXid("www.xid.ch/id/recipient_ean");
        if (ret == null || ret.getDomainId() == null || ret.getDomainId().isEmpty()) {
            return "unknown";
        }
        return ret.getDomainId().trim();
    }

    public static String getSuvaNr(IContact k) {
        IXid ret = k.getXid(DOMAIN_SUVA);
        return ret != null ? ret.getDomainId() : "";
    }

    public static String getIntermediateEAN(ICoverage coverage) {
        return CoverageServiceHolder.get().getRequiredString(coverage, INTERMEDIATE).trim();
    }

    public static String getProviderEAN(ICoverage coverage) {
        String ean = CoverageServiceHolder.get().getRequiredString(coverage, EAN_PROVIDER).trim();
        if (!ean.matches("(20[0-9]{11}|76[0-9]{11}|unknown|[A-Z][0-9]{6})")) {
            return "unknown";
        }
        return ean;
    }

    public static String getResponsibleEAN(ICoverage coverage) {
        String ean = CoverageServiceHolder.get().getRequiredString(coverage, EAN_RESPONSIBLE).trim();
        if (!ean.matches("(20[0-9]{11}|76[0-9]{11}|unknown|[A-Z][0-9]{6})")) {
            return "unknown";
        }
        return ean;
    }

    public static String normalizeKSK(String KSK, boolean bCompact) {
        if (!((String)KSK).matches("[a-zA-Z] ?[0-9]{4,4}\\.?[0-9]{2,2}")) {
            return "invalid";
        }
        KSK = ((String)KSK).replaceAll("[^a-zA-Z0-9]", "");
        if (bCompact) {
            return KSK;
        }
        KSK = ((String)KSK).substring(0, 1) + " " + ((String)KSK).substring(1, 5) + "." + ((String)KSK).substring(5);
        return ((String)KSK).trim();
    }

    public static String getKSK(IContact contact) {
        IXid xid = contact.getXid(DOMAIN_KSK);
        if (xid == null && contact.getExtInfo((Object)"KSK") instanceof String && StringUtils.isNotBlank((CharSequence)((String)contact.getExtInfo((Object)"KSK")))) {
            TarmedRequirements.setKSK(contact, (String)contact.getExtInfo((Object)"KSK"));
            xid = contact.getXid(DOMAIN_KSK);
        }
        return xid != null ? xid.getDomainId().replaceAll("[\\s\\.\\-]", "").trim() : "";
    }

    public static String getNIF(IContact contact) {
        IXid xid = contact.getXid(DOMAIN_NIF);
        if (xid == null && contact.getExtInfo((Object)"NIF") instanceof String && StringUtils.isNotBlank((CharSequence)((String)contact.getExtInfo((Object)"NIF")))) {
            TarmedRequirements.setNIF(contact, (String)contact.getExtInfo((Object)"NIF"));
            xid = contact.getXid(DOMAIN_NIF);
        }
        return xid != null ? xid.getDomainId().trim() : "";
    }

    public static boolean setEAN(IContact k, String ean) {
        if (!ean.matches("[0-9]{13,13}")) {
            return false;
        }
        k.addXid("www.xid.ch/id/ean", ean, true);
        return true;
    }

    public static void setKSK(IContact k, String ksk) {
        k.addXid(DOMAIN_KSK, ksk, true);
    }

    public static void setNIF(IContact k, String nif) {
        k.addXid(DOMAIN_NIF, nif, true);
    }

    public static void setSuvaNr(IContact k, String SuvaNr) {
        k.addXid(DOMAIN_SUVA, SuvaNr, true);
    }

    public static String getAHV(IPerson p) {
        String ret;
        IXid ahv = p.getXid("www.ahv.ch/xid");
        String string = ret = ahv != null ? ahv.getDomainId() : "";
        if (StringUtils.isBlank((CharSequence)ret)) {
            ret = StringUtils.defaultString((String)((String)p.getExtInfo((Object)SSN)));
            if (StringUtils.isBlank((CharSequence)ret)) {
                ret = StringUtils.defaultString((String)((String)p.getExtInfo((Object)INSURANCE_NUMBER)));
            }
            if (StringUtils.isNotBlank((CharSequence)ret)) {
                TarmedRequirements.setAHV(p, ret);
            }
        }
        return ret.trim();
    }

    public static void setAHV(IPerson p, String ahv) {
        p.addXid("www.ahv.ch/xid", ahv, true);
    }

    public static String getGesetz(ICoverage coverage) {
        String ret = coverage.getBillingSystem().getLaw().name();
        if (ret.equalsIgnoreCase("IV")) {
            ret = "IVG";
        } else if (ret.equalsIgnoreCase("MV")) {
            ret = "MVG";
        }
        return ret;
    }

    public static String getTCName(IContact mandant) {
        if (mandant != null) {
            String tc = (String)mandant.getExtInfo((Object)"TarmedTC");
            return tc;
        }
        return null;
    }

    public static String getTCCode(IContact mandant) {
        String tcname = TarmedRequirements.getTCName(mandant);
        Integer nr = TrustCenters.tc.get(tcname);
        if (nr == null) {
            return "00";
        }
        return Integer.toString(nr);
    }

    public static void setTC(IContact mandant, String value) {
        mandant.setExtInfo((Object)"TarmedTC", (Object)value);
    }

    public static void setHasTCContract(IContact mandant, boolean value) {
        mandant.setExtInfo((Object)"TarmedUseTC", (Object)(value ? "1" : "0"));
    }

    public static boolean hasTCContract(IContact mandant) {
        if (mandant != null) {
            String hc = (String)mandant.getExtInfo((Object)"TarmedUseTC");
            return "1".equals(hc);
        }
        return false;
    }
}

