/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.adjuster;

import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.IBillableAdjuster;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.CodeElementServiceHolder;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class TarmedVerrechnebarAdjuster
implements IBillableAdjuster {
    @Reference
    private IContextService contextService;

    public IBillable adjust(IBillable billable, IEncounter encounter) {
        ICoverage coverage;
        String law;
        ITarmedLeistung leistung;
        String leistungLaw;
        if (billable instanceof ITarmedLeistung && StringUtils.isNotEmpty((CharSequence)(leistungLaw = (leistung = (ITarmedLeistung)billable).getLaw())) && this.isPerformLawCheck() && !leistungLaw.equalsIgnoreCase(law = (coverage = encounter.getCoverage()).getBillingSystem().getLaw().name())) {
            Optional tarmedCode = CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.SERVICE, "Tarmed");
            billable = ((ICodeElementServiceContribution)tarmedCode.get()).loadFromCode(leistung.getCode(), CodeElementServiceHolder.createContext((IEncounter)encounter)).orElse(null);
        }
        return billable;
    }

    private boolean isPerformLawCheck() {
        if (this.contextService.getNamed("tarmed.nolawcheck").isPresent()) {
            this.contextService.getRootContext().setNamed("tarmed.nolawcheck", null);
            return false;
        }
        return true;
    }
}

