/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.Messages;
import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterBalance;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.Money;
import ch.rgw.tools.XMLTool;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.jdom2.Content;
import org.jdom2.Element;

public class XMLExporterEsr9 {
    private static final String ATTR_PARTICIPANT_NUMBER = "participant_number";
    private static final String ATTR_TYPE = "type";
    private Element esr9Element;

    private XMLExporterEsr9(Element esr9) {
        this.esr9Element = esr9;
    }

    public Element getElement() {
        return this.esr9Element;
    }

    public static XMLExporterEsr9 buildEsr9(IInvoice invoice, XMLExporterBalance balance, XMLExporter xmlExporter) {
        String participantNumber;
        Element element;
        IMandator actMandant = invoice.getMandator();
        String esrmode = (String)actMandant.getBiller().getExtInfo((Object)XMLExporter.ta.ESR5OR9);
        ESR besr = xmlExporter.getBesr();
        if (StringUtils.isNotBlank((CharSequence)esrmode) && esrmode.equals("esr9")) {
            element = new Element("esr9", XMLExporter.nsinvoice);
            participantNumber = besr.makeParticipantNumber(true);
            if (StringUtils.isEmpty((CharSequence)participantNumber)) {
                MessageDialog.openError(null, (String)Messages.XMLExporter_MandatorErrorCaption, (String)(Messages.XMLExporter_MandatorErrorEsr + " [" + actMandant.getLabel() + "]"));
                return null;
            }
        } else {
            MessageDialog.openError(null, (String)Messages.XMLExporter_MandatorErrorCaption, (String)Messages.XMLExporter_MandatorErrorText);
            return null;
        }
        element.setAttribute(ATTR_PARTICIPANT_NUMBER, participantNumber);
        element.setAttribute(ATTR_TYPE, "16or27");
        String refnr = besr.makeRefNr(true);
        String codingline = besr.createCodeline(XMLTool.moneyToXmlDouble((Money)balance.getDue()).replaceFirst("[.,]", ""), null);
        element.setAttribute("reference_number", refnr);
        element.setAttribute("coding_line", codingline);
        String bankid = (String)actMandant.getBiller().getExtInfo((Object)XMLExporter.ta.RNBANK);
        if (StringUtils.isNotBlank((CharSequence)bankid)) {
            Optional bank = CoreModelServiceHolder.get().load(bankid, IOrganization.class);
            bank.ifPresent(b -> {
                Element eBank = new Element("bank", XMLExporter.nsinvoice);
                Element company = XMLExporterUtil.buildAdressElement((IContact)b);
                eBank.addContent((Content)company);
                element.addContent((Content)eBank);
            });
        }
        return new XMLExporterEsr9(element);
    }
}

