/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.views;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedKumulation;
import ch.elexis.base.ch.arzttarife.tarmed.ITarmedLeistung;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationArt;
import ch.elexis.base.ch.arzttarife.tarmed.TarmedKumulationTyp;
import ch.elexis.base.ch.arzttarife.util.TarmedDefinitionenUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TarmedDetailDisplay
implements IDetailDisplay {
    public static final TimeTool INFINITE = new TimeTool("19991231");
    private FormToolkit tk;
    private ScrolledForm form;
    private String[] fields = new String[]{Messages.TarmedDetailDisplay_DigniQuant, Messages.TarmedDetailDisplay_DigniQual, Messages.TarmedDetailDisplay_Sparte, Messages.TarmedDetailDisplay_RiskClass, Messages.TarmedDetailDisplay_TPDoc, Messages.TarmedDetailDisplay_TPTec, Messages.TarmedDetailDisplay_TPAss, Messages.TarmedDetailDisplay_NumbereAss, Messages.TarmedDetailDisplay_TimeAct, Messages.TarmedDetailDisplay_TimeBeforeAfter, Messages.TarmedDetailDisplay_TimeWrite, Messages.TarmedDetailDisplay_TimeChange, Messages.TarmedDetailDisplay_TimeRoom, Messages.TarmedDetailDisplay_Relation, Messages.TarmedDetailDisplay_NameInternal};
    private String[] retrieve = new String[]{"DigniQuanti", "DigniQuali", "Sparte", "Anaesthesie", "TP_AL", "TP_TL", "TP_ASSI", "ANZ_ASSI", "LSTGIMES_MIN", "VBNB_MIN", "BEFUND_MIN", "WECHSEL_MIN", "RAUM_MIN", "Bezug", "Nickname"};
    private Text[] inputs = new Text[this.fields.length];
    private FormText medinter;
    private FormText techinter;
    private FormText exclusion;
    private FormText inclusion;
    private FormText limits;
    private FormText hirarchy;
    private FormText validity;
    private ITarmedLeistung actCode;

    @Inject
    public void selection(@Optional @Named(value="ch.elexis.views.codeselector.tarmed.selection") ITarmedLeistung tarmed) {
        if (tarmed != null && !this.form.isDisposed()) {
            this.display(tarmed);
        }
    }

    public Composite createDisplay(Composite parent, IViewSite notUsed) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        LabeledInputField.Tableau cFields = new LabeledInputField.Tableau(this.form.getBody());
        int i = 0;
        while (i < this.fields.length) {
            this.inputs[i] = (Text)cFields.addComponent(this.fields[i]).getControl();
            ++i;
        }
        final int last = this.fields.length - 1;
        this.inputs[last].addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TarmedDetailDisplay.this.actCode != null) {
                    TarmedDetailDisplay.this.actCode.setNickname(TarmedDetailDisplay.this.inputs[last].getText());
                }
            }
        });
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        cFields.setLayoutData((Object)twd);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_MedInter);
        this.medinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_TecInter);
        this.techinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DontCombine);
        this.exclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DoCombine);
        this.inclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_PossibleAdd);
        this.hirarchy = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Limits);
        this.limits = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Validity);
        this.validity = this.tk.createFormText(this.form.getBody(), false);
        return this.form.getBody();
    }

    public Composite createDisplayFromDeteils(Composite parent, IViewSite notUsed) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createScrolledForm(parent);
        TableWrapLayout twl = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)twl);
        TableWrapData twd = new TableWrapData(256);
        twd.grabHorizontal = true;
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_MedInter);
        this.medinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_TecInter);
        this.techinter = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DontCombine);
        this.exclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_DoCombine);
        this.inclusion = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_PossibleAdd);
        this.hirarchy = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Limits);
        this.limits = this.tk.createFormText(this.form.getBody(), false);
        this.tk.createLabel(this.form.getBody(), Messages.TarmedDetailDisplay_Validity);
        this.validity = this.tk.createFormText(this.form.getBody(), false);
        return this.form.getBody();
    }

    public Class getElementClass() {
        return ITarmedLeistung.class;
    }

    public void display(Object obj) {
        if (obj instanceof ITarmedLeistung) {
            this.actCode = (ITarmedLeistung)obj;
            this.form.setText(this.actCode.getLabel());
            if (this.actCode.isChapter()) {
                if (this.inputs[0] != null) {
                    Arrays.asList(this.inputs).forEach(i -> i.setText(""));
                }
                this.exclusion.setText("", false, false);
                this.inclusion.setText("", false, false);
                this.hirarchy.setText("", false, false);
                this.medinter.setText("", false, false);
                this.techinter.setText("", false, false);
                this.limits.setText("", false, false);
                this.validity.setText("", false, false);
            } else {
                Object text;
                if (this.inputs[0] != null) {
                    this.inputs[0].setText(this.actCode.getDigniQuanti());
                    this.inputs[1].setText(this.actCode.getDigniQuali());
                    this.inputs[2].setText(this.actCode.getSparte());
                    this.inputs[3].setText(TarmedDefinitionenUtil.getTextForRisikoKlasse((String)((String)this.actCode.getExtension().getExtInfo((Object)"ANAESTHESIE"))));
                    int i2 = 4;
                    while (i2 < this.fields.length - 1) {
                        String val = (String)this.actCode.getExtension().getExtInfo((Object)this.retrieve[i2]);
                        if (val == null) {
                            val = "";
                        }
                        this.inputs[i2].setText(val);
                        ++i2;
                    }
                    this.inputs[this.fields.length - 1].setText(this.actCode.getNickname());
                }
                this.medinter.setText(this.actCode.getExtension().getMedInterpretation(), false, false);
                this.techinter.setText(this.actCode.getExtension().getTechInterpretation(), false, false);
                List kumulations = this.actCode.getKumulations(TarmedKumulationArt.SERVICE);
                this.exclusion.setText(this.getKumulationsString(kumulations, this.actCode.getCode(), TarmedKumulationTyp.EXCLUSION), false, false);
                this.inclusion.setText(this.getKumulationsString(kumulations, this.actCode.getCode(), TarmedKumulationTyp.INCLUSION), false, false);
                List hirarchyCodes = this.actCode.getHierarchy(this.actCode.getValidFrom());
                this.hirarchy.setText(String.join((CharSequence)", ", hirarchyCodes), false, false);
                String limit = (String)this.actCode.getExtension().getExtInfo((Object)"limits");
                if (limit != null) {
                    String[] ll;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<form>");
                    String[] stringArray = ll = limit.split("#");
                    int n = ll.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        String[] f = line.split(",");
                        if (f.length == 6) {
                            sb.append("<li>");
                            if (f[0].equals("<=")) {
                                sb.append(Messages.TarmedDetailDisplay_max).append(" ");
                            } else {
                                sb.append(f[0]).append(" ");
                            }
                            sb.append(f[1]).append(Messages.TarmedDetailDisplay_times);
                            if (f[3].equals("P")) {
                                sb.append(Messages.TarmedDetailDisplay_per);
                            } else {
                                sb.append(Messages.TarmedDetailDisplay_after);
                            }
                            sb.append(f[2]).append(" ");
                            sb.append(TarmedDefinitionenUtil.getTextForZR_Einheit((String)f[4]));
                            sb.append("</li>");
                        }
                        ++n2;
                    }
                    sb.append("</form>");
                    this.limits.setText(sb.toString(), true, false);
                } else {
                    this.limits.setText("", false, false);
                }
                TimeTool tGueltigVon = new TimeTool(this.actCode.getValidFrom());
                TimeTool tGueltigBis = new TimeTool(this.actCode.getValidTo());
                if (tGueltigVon != null && tGueltigBis != null) {
                    String from = tGueltigVon.toString(4);
                    String to = tGueltigBis.isSameDay(INFINITE) ? "" : tGueltigBis.toString(4);
                    text = from + "-" + to;
                } else {
                    text = "";
                }
                this.validity.setText((String)text, false, false);
            }
            this.form.reflow(true);
        }
    }

    private String getKumulationsString(List<ITarmedKumulation> list, String code, TarmedKumulationTyp typ) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            List slaveServices = list.stream().filter(k -> k.getTyp() == typ && k.getSlaveArt() == TarmedKumulationArt.SERVICE && k.getSlaveCode().equals(code) && k.getMasterArt() == TarmedKumulationArt.SERVICE).collect(Collectors.toList());
            List masterServices = list.stream().filter(k -> k.getTyp() == typ && k.getMasterArt() == TarmedKumulationArt.SERVICE && k.getMasterCode().equals(code) && k.getSlaveArt() == TarmedKumulationArt.SERVICE).collect(Collectors.toList());
            if (!slaveServices.isEmpty() || !masterServices.isEmpty()) {
                sb.append("Leistungen: ");
                StringJoiner sj = new StringJoiner(", ");
                for (ITarmedKumulation tarmedKumulation : slaveServices) {
                    if (sj.toString().contains(tarmedKumulation.getMasterCode())) continue;
                    sj.add(tarmedKumulation.getMasterCode());
                }
                for (ITarmedKumulation tarmedKumulation : masterServices) {
                    if (sj.toString().contains(tarmedKumulation.getSlaveCode())) continue;
                    sj.add(tarmedKumulation.getSlaveCode());
                }
                sb.append(sj.toString());
            }
            List slaveGroups = list.stream().filter(k -> k.getTyp() == typ && k.getSlaveArt() == TarmedKumulationArt.GROUP).collect(Collectors.toList());
            List masterGroups = list.stream().filter(k -> k.getTyp() == typ && k.getMasterArt() == TarmedKumulationArt.GROUP).collect(Collectors.toList());
            if (!slaveGroups.isEmpty() || !masterGroups.isEmpty()) {
                sb.append(" ");
                sb.append("Gruppen: ");
                StringJoiner sj = new StringJoiner(", ");
                for (ITarmedKumulation tarmedKumulation : slaveGroups) {
                    if (sj.toString().contains(tarmedKumulation.getSlaveCode())) continue;
                    sj.add(tarmedKumulation.getSlaveCode());
                }
                for (ITarmedKumulation tarmedKumulation : masterGroups) {
                    if (sj.toString().contains(tarmedKumulation.getMasterCode())) continue;
                    sj.add(tarmedKumulation.getMasterCode());
                }
                sb.append(sj.toString());
            }
        }
        return sb.toString();
    }

    public String getTitle() {
        return "Tarmed";
    }
}

