/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.tarmedprefs;

import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ResponsibleComposite
extends Composite {
    private ComboViewer responsibleViewer;
    private Mandant mandant;
    private NoMandant noMandant = new NoMandant();

    public ResponsibleComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout());
        this.responsibleViewer = new ComboViewer((Composite)this);
        this.responsibleViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.responsibleViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.responsibleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)ResponsibleComposite.this.responsibleViewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Mandant selected = (Mandant)selection.getFirstElement();
                    if (selected != ResponsibleComposite.this.noMandant) {
                        ResponsibleComposite.this.mandant.setInfoElement("ch.elexis.tarmedprefs.responsible", (Object)selected.getId());
                    } else {
                        ResponsibleComposite.this.mandant.setInfoElement("ch.elexis.tarmedprefs.responsible", (Object)"");
                    }
                }
            }
        });
        this.responsibleViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Mandant) {
                    return ((Mandant)element).getLabel();
                }
                return super.getText(element);
            }
        });
    }

    public void setMandant(Mandant mandant) {
        this.mandant = mandant;
        this.updateViewer();
    }

    private void updateViewer() {
        if (this.mandant != null) {
            Mandant responsible;
            Query qbe = new Query(Mandant.class);
            List input = qbe.execute();
            input.add(0, this.noMandant);
            this.responsibleViewer.setInput((Object)input);
            String responsibleId = (String)this.mandant.getInfoElement("ch.elexis.tarmedprefs.responsible");
            if (responsibleId != null && !responsibleId.isEmpty() && (responsible = Mandant.load((String)responsibleId)) != null && responsible.exists()) {
                this.responsibleViewer.setSelection((ISelection)new StructuredSelection((Object)responsible));
            }
        } else {
            this.responsibleViewer.setInput((Object)Collections.EMPTY_LIST);
        }
    }

    private class NoMandant
    extends Mandant {
        public String getLabel(boolean shortLabel) {
            return "";
        }
    }
}

