/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.TarmedRechnung;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IInvoice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLExporterDocuments {
    private static Logger logger = LoggerFactory.getLogger(XMLExporterDocuments.class);
    public static final String ELEMENT_DOCUMENTS = "documents";
    public static final String ELEMENT_DOCUMENT = "document";
    public static final String ELEMENT_BASE64 = "base64";
    private Element documentElement = null;

    public XMLExporterDocuments(Element element, List<Element> documents) {
        this.documentElement = element;
        this.documentElement.setAttribute("number", Integer.toString(documents.size()));
        this.documentElement.addContent(documents);
    }

    @Nullable
    public static XMLExporterDocuments buildDocuments(IInvoice invoice, XMLExporter xmlExporter) {
        List attachments = invoice.getAttachments();
        if (attachments != null && attachments.size() > 0) {
            ArrayList<Element> documents = new ArrayList<Element>();
            for (IDocument attachment : attachments) {
                String mimeType = attachment.getMimeType();
                if (mimeType == null || !mimeType.endsWith("pdf")) {
                    logger.warn("Cannot add attachment [{}], mimeType is null or not pdf", (Object)attachment.getId());
                    continue;
                }
                try {
                    InputStream content = attachment.getContent();
                    if (content != null) {
                        byte[] byteArray = IOUtils.toByteArray((InputStream)attachment.getContent());
                        byte[] encoded = Base64.getEncoder().encode(byteArray);
                        Element document = new Element(ELEMENT_DOCUMENT, XMLExporter.nsinvoice);
                        document.setAttribute("filename", attachment.getTitle());
                        document.setAttribute("mimeType", "application/pdf");
                        Element base64 = new Element(ELEMENT_BASE64, XMLExporter.nsinvoice);
                        base64.addContent(new String(encoded));
                        document.addContent((Content)base64);
                        documents.add(document);
                        continue;
                    }
                    logger.warn("Cannot add attachment [{}], content is null", (Object)attachment.getId());
                }
                catch (IOException e) {
                    logger.warn("Cannot add attachment [{}], cannot read content", (Object)attachment.getId(), (Object)e);
                }
            }
            if (documents.size() > 0) {
                return new XMLExporterDocuments(new Element(ELEMENT_DOCUMENTS, XMLExporter.nsinvoice), documents);
            }
        }
        return null;
    }

    public Element getElement() {
        return this.documentElement;
    }
}

