/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.base.ch.arzttarife.tarmed.model.importer;

import ch.elexis.arzttarife_schweiz.Messages;
import ch.elexis.base.ch.arzttarife.tarmed.model.importer.EntityUtil;
import ch.elexis.core.jpa.entities.TarmedDefinitionen;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.LoggerFactory;

public class DefinitionImport {
    private JdbcLink cacheDb;
    private String lang;
    private String law;

    public DefinitionImport(JdbcLink cacheDb, String lang, String law) {
        this.cacheDb = cacheDb;
        this.lang = lang;
        this.law = law;
    }

    public IStatus doImport(IProgressMonitor ipm) {
        String[] fields = new String[]{"ANAESTHESIE", "DIGNI_QUALI", "DIGNI_QUANTI", "LEISTUNG_BLOECKE", "LEISTUNG_GRUPPEN", "LEISTUNG_TYP", "PFLICHT", "REGEL_EL_ABR", "SEITE", "SEX", "SPARTE", "ZR_EINHEIT"};
        JdbcLink.Stm stmCached = null;
        try {
            try {
                ipm.subTask(Messages.TarmedImporter_definitions);
                stmCached = this.cacheDb.getStatement();
                String[] stringArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    ResultSet res = stmCached.query(String.format("SELECT * FROM %sCT_" + s + " WHERE SPRACHE='%s'", "TARMED_IMPORT_", this.lang));
                    this.importNewest(s, res);
                    res.close();
                    ++n2;
                }
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error importing definition", (Throwable)e);
                if (stmCached != null) {
                    this.cacheDb.releaseStatement(stmCached);
                }
            }
        }
        finally {
            if (stmCached != null) {
                this.cacheDb.releaseStatement(stmCached);
            }
        }
        return Status.OK_STATUS;
    }

    protected void importNewest(String spalte, ResultSet res) throws SQLException {
        ArrayList<String[]> sorted = new ArrayList<String[]>();
        while (res.next()) {
            String[] values = new String[]{res.getString(1), res.getString(3), res.getString("GUELTIG_VON")};
            sorted.add(values);
        }
        sorted.sort(new Comparator<String[]>(){
            private TimeTool leftTime = new TimeTool();
            private TimeTool rightTime = new TimeTool();

            @Override
            public int compare(String[] left, String[] right) {
                int ret = left[0].compareTo(right[0]);
                if (ret == 0) {
                    this.leftTime.set(left[2]);
                    this.rightTime.set(right[2]);
                    ret = this.rightTime.compareTo((Calendar)this.leftTime);
                }
                return ret;
            }
        });
        this.importNewest(spalte, sorted);
    }

    protected void importNewest(String spalte, List<String[]> sorted) {
        String lastCode = null;
        ArrayList<Object> newDefinitionen = new ArrayList<Object>();
        for (String[] strings : sorted) {
            if (strings[0].equals(lastCode)) continue;
            TarmedDefinitionen definitionen = new TarmedDefinitionen();
            definitionen.setSpalte(spalte);
            definitionen.setKuerzel(strings[0]);
            definitionen.setTitel(strings[1]);
            definitionen.setLaw(this.law);
            newDefinitionen.add(definitionen);
            lastCode = strings[0];
        }
        EntityUtil.save(newDefinitionen);
    }
}

